package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;

import mlproject.phylo.PhylogeneticTree;

public class EvidenceCompositeInputReader implements InputReader{
    private NucleotideFastaInputReader fr;
    private MultipleAlignmentReader mr;
    private IntegerFastaInputReader er;
    private IntegerFastaInputReader wr;
    
    public EvidenceCompositeInputReader(String fastaFile, PhylogeneticTree tree, String alignmentFile, String exonerateFile, String weaselFile) throws FileNotFoundException, IOException {
        fr = new NucleotideFastaInputReader(fastaFile);
        mr = new MultipleAlignmentReader(alignmentFile,tree);
        er = new IntegerFastaInputReader(exonerateFile);
        wr = new IntegerFastaInputReader(weaselFile);
    }

    public InputSequence readNextSequence() throws IOException {
        InputSequence result = new InputSequenceComposite();
        result.addComponent(fr.readNextSequence());
        result.addComponent(mr.readNextSequence());
        result.addComponent(er.readNextSequence());
        result.addComponent(wr.readNextSequence());
            
        int nullCount = 0;
        
        for(int i=0;i<4;i++){
            if(result.getComponent(i)==null)
                nullCount++;
        }
        
        if(nullCount == 4) return null;
        if(nullCount > 0){
            throw new RuntimeException("Incorrect number of input sequences in composite");
        }
        for(int i=1;i<4;i++){
            if(result.getComponent(i).length() != result.getComponent(i-1).length())
                throw new RuntimeException("Incorrect size of input sequence");
        }
         
        return result;
    }
}
