package mlproject.io;

import java.util.ArrayList;

public class InputSequenceComposite implements InputSequence{
    ArrayList<InputSequence> components = new ArrayList<InputSequence>();
    
    public InputSequenceComposite() {
    }

    public String getName() {
        if(components.size() == 0)
            return null;
        else
            return components.get(0).getName();
    }

    public Object getX(int x) {
        return null;
    }

    public int length() {
        if(components.size() == 0)
            return 0;
        else return components.get(0).length();
    }

    public InputSequence getComponent(int component) {
        return components.get(component);
    }

    public void addComponent(InputSequence component) {
        components.add(component);
    }

    public void removeComponent(int component) {
        components.remove(component);
    }

    public boolean isComposite() {
        return true;
    }

    public int numberOfComponents() {
        return components.size();
    }
}
