package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;

public class NucleotideFastaInputReader implements InputReader<Integer> {
    FastaIterator fi;

    public NucleotideFastaInputReader(String file) throws FileNotFoundException, IOException {
        fi = new FastaIterator(file);
    }

    public InputSequence<Integer> readNextSequence() throws IOException {
        String[] next = fi.next();
        if (next == null)
            return null;
        int[] seq = new int[next[1].length()];
        for (int i = 0; i < seq.length; i++) {
            switch (next[1].charAt(i)) {
            case 'A':
                seq[i] = 0;
                break;
            case 'C':
                seq[i] = 1;
                break;
            case 'G':
                seq[i] = 2;
                break;
            case 'T':
                seq[i] = 3;
                break;
            case 'N':
                seq[i] = 4;
                break;
            default:
                throw new RuntimeException("Unknown symbol:"+next[1].charAt(i));
            }
        }
        return new IntegerInputSequence(next[0],seq);
    }
}
