package mlproject.phylo;

public class JukesCantorModel extends NucleotideSubstitutionModel {
    double omega;
    public JukesCantorModel(double omega) {
        this.omega = omega;
    }
    
    public double[][] getSubstitutionProbs(double time) {
        double change =  (1 - Math.exp(-4 / (double)3 * time * omega)) / 4;
        double same = (1 + 3 * Math.exp(-4 / (double)3 * time * omega)) / 4;
            
        double [][] result = new double[4][4];
        for(int i=0;i<4;i++)
            for(int j=0;j<4;j++)
                if(i==j)
                    result[i][j] = same;
                else
                    result[i][j] = change;
        return result;    
    }
}
