#! /usr/bin/perl -w
#Extract genome from genbank/*.gb files to algn/'.$filename.'-'.$organism.'.fa fasta files
use strict;

my $fasta_file = $ARGV[0];
my $input_location = $ARGV[1];
my $output_location = $ARGV[2];

my @value_files = ('exon.values','intron.values','inter.values');

my %gene_names;

open(FASTA, "<$fasta_file");

while(<FASTA>){
	if(/>(\w+)/){
		$gene_names{$1} = $1;
	}
}

close(FASTA);

foreach my $file_name(@value_files) {
	open(VALUES, "<$input_location$file_name");
	open(VALUES_OUT, ">$output_location$file_name");
	my $print_out = 0;
	while(<VALUES>){
		
		if(/>(\w+)/){
			if(defined $gene_names{$1}){
				$print_out = 1;
				print VALUES_OUT ">$1\n";
				next;
			} else {
				$print_out = 0;
			}
		}

		print VALUES_OUT $_ if($print_out);
	}
	close(VALUES);
	close(VALUES_OUT);
}

 
 
