#! /usr/bin/perl -w

use strict;
use Data::Dumper;

my $piA = 0.43914528597477975; 
my $piC = 0.08378919793512597;
my $piG = 0.1197832395921617;
my $piT = 0.35728227649793254;
my $fasta_names_in = 'Sacce;Sacpa;Nakba;Canca;Nakde;Cangl;Sacse;Sacca;Vanpo;Kluth;Klula;Ashgo;Canvi;Canso;Canal;Canne;Canma;Picfa;Debha;Canpa;Canor;Canme;Canji;Cansu;Picca;Hanuv;Brecu;Dekbr;Yarli;Canze;Schja;Schoc;Schpo'; 
my $codons_len = 10000;

my @fasta_names = split(';' ,$fasta_names_in);

foreach my $name (@fasta_names) {
	print "\n>$name\n";
	for(my $i=0;$i < $codons_len;$i++) {
		my $codon = "";
		for(my $j=0;$j < 3;$j++) {
			my $next = rand();
			if($next < $piA){$codon .= 'A';next;}
			if($next < $piA + $piC){$codon .= 'C';next;}
			if($next < $piA + $piC + $piG){$codon .= 'G';next;}
			$codon .= 'T';
		}
		if($codon eq 'TAA' || $codon eq 'TAG'){
			$i--;
			next;
		} else {
			print $codon;
		}
	}
}
