<?php

require_once 'classes/Session.php';
require_once 'classes/Controler.php';
require_once 'classes/Portlet.php';
require_once 'classes/Sedna.php';
require_once 'classes/Filters.php';
require_once 'classes/SortQueries.php';
require_once 'classes/Tagging.php';

class TagAdmin implements Portlet {

/*
TODO:

*/
	private $tagging;
	public function init($params) {
		$this->tagging = Tagging::getInstance();
	}
	public function getXML($params) {
		$data="";
		switch ($params['type']) {
			case "tagAdmin": {
				$data = '<module name="TagAdmin" lang="'.$this->tagging->lang.'">'.$this->data($params).'</module>';
				break;
			}
		}
		return $data;
	}
	public function getXSLlist($params) {
		switch ($params['type']) {
			case "tagAdmin":{
				return array('classes/modules/tagAdmin.xsl');
				break;
			}
		}
		return array();
	}
	
	public function getXSLParams($params) {
		switch ($params['type']) {
			case "tagAdmin":{
				return array('base'=>BASE,'page'=>$params['page'],'filter'=>formatText($params['filter'])); //aj aktualny user
				break;
			}
		}
		return array();
	}
	
	public function data($params){
		if(!$_SESSION['session']->getUser()) return "<message>Treba sa prihlasit</message>";
		if (!$_SESSION['session']->getUser()->getUserPermissions('canEditTags')) return "<message>Nemas potrebne prava.</message>";
		//return "<message>Secko v poradku</message>";
		$this->processInput($params);
		switch($params['page']){
			case 'importAnnotations':'<importResult>'.$this->tagging->clearAndimportAnnotations().'</importResult>';
				break;
			case 'importAnnotations':'<importResult>'.$this->tagging->resetSystem().'</importResult>';
				break;
			case 'statistics':
			return "<statistics>".$this->tagging->cloudMaker->getStatistics()."</statistics>";
			break;
			default:
				return $this->tagging->tagregator->tagList($params['filter'],$params['pagination']);
			break;
		}
	}
	public function processInput($params){ //when calling this, make sure user is admin
		if (!empty($params['tag'])){
			if(!empty($params['display'])){
				if ($params['display']=="true") $this->tagging->tagregator->setTagVisibility($params['tag'],true);
					else $this->tagging->tagregator->setTagVisibility($params['tag'],false);
			}
		}
		if(!empty($params['split'])){
				if(!is_numeric($params['split'])) exit('nono, nehackovat!');
				$this->tagging->tagregator->splitFromUnder($params['split']);
		}
		if(!empty($_POST['merge'])){
			$id = $this->tagging->tagregator->getRootCanonicalID($_POST['canonical'],false);
			if ($id!=-1)$this->tagging->tagregator->mergeUnder($_POST['tag'],$id);
		}
		
		
		switch ($params['page']){
			case 'resetSystem': $this->tagging->resetSystem(); break;
		}
	}
}

$GLOBALS['controler']->registerPortlet(TagAdmin);

?>
