﻿package  {
	import flash.display.MovieClip;
	import flash.events.Event;
	import wassil.utils.Waiter;
	import wassil.utils.XMLLoader;
	import wassil.debug.Console;
	import flash.events.MouseEvent;
	import flash.media.Sound;
	import flash.net.URLRequest;
	/**
	 * ...
	 * @author wassil
	 */
	public class CoPlayerFinder extends MovieClip{
		var fbID:String;
		var xmlLoader:XMLLoader;
		var gamesRunningLoader:XMLLoader;
		var xml:XML;
		var waiter:Waiter;
		var responseTime:Number = 0;
		var complete:Boolean = false;
		var soundOn:Boolean = false;
		public function CoPlayerFinder() {
			waiting.visible = false;
			waiting.stop();
			soundControl.noSound.mouseEnabled = false;
			soundControl.soundIcon.buttonMode = true;
		}
		public function init(fbID:String) {
			soundControl.visible = false;
			this.fbID = fbID;
			complete = false;
			waiter = new Waiter();
			gamesRunningLoader = new XMLLoader(Main.gamesRunning, gamesRunningLoaded);
			btnAutomaticGame.addEventListener(MouseEvent.CLICK, btnAutomaticGameClicked);
			soundControl.addEventListener(MouseEvent.CLICK, soundClicked);
		}
		private function btnAutomaticGameClicked(e:Event) {
			soundControl.visible = true;
			btnAutomaticGame.visible = false;
			waiting.visible = true;
			//preloader
			xml = new XML();
			loadXML();
			waiter.waitAndCall(2000,checkOut);
		}
		private function gamesRunningLoaded(e:Event) {
			//tfGamesRunning.text = gamesRunningLoader.xml;
		}
		private function loadXML() {
			waiting.gotoAndStop((waiting.currentFrame+1) % (waiting.totalFrames+1));
			xmlLoader = new XMLLoader(Main.findCoPlayer + "&fbID=" + fbID, response);
		}
		private function response(e:Event) {
			responseTime = new Date().getTime();
			xml = xmlLoader.xml;
			//Console.trace(xml);
			if (xml.info.@coPlayerFound == "true") {
				Console.trace("spoluhrac najdeny");
				dispatchEvent(new Event(Event.COMPLETE));
				complete = true;
				if (soundOn) {
					var snd:Sound = new Sound();
					snd.load(new URLRequest(Main.mp3));
					snd.play();
				}
			} else loadXML();
		}
		private function checkOut() {
			if (!complete){
				if (new Date().getTime() - responseTime > 2000) {
					Console.trace("vypadol jeden request, zacnem znova");
					loadXML();
				}
				waiter.waitAndCall(2000,checkOut);
			}
		}
		private function soundClicked(e:Event = null) {
			soundOn = !soundOn;
			if (soundOn) {
				soundControl.noSound.visible = false;
			} else {
				soundControl.noSound.visible = true;
			}
		}
		
	}

}