#ifndef _PTS_H
#define _PTS_H

#include <linux/rculist.h>
#include <linux/lsm_audit.h>
#include <linux/string.h>
#include <linux/mutex.h>

#include <linux/xattr.h>
#include <linux/pagemap.h>
#include <linux/mount.h>
#include <linux/stat.h>
#include <linux/ext2_fs.h>
#include <linux/kd.h>
#include <asm/ioctls.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/mutex.h>
#include <linux/pipe_fs_i.h>
#include <net/netlabel.h>
#include <net/cipso_ipv4.h>
#include <linux/audit.h>
#include <linux/magic.h>
#include <linux/security.h>
#include <linux/fs.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/security.h>
#include <linux/capability.h>

#include <linux/init.h>
#include <linux/kernel.h>

#include <linux/capability.h>
#include <linux/spinlock.h>
#include <linux/security.h>
#include <linux/in.h>
#include <net/netlabel.h>
#include <linux/list.h>


/* moznost editovat pri nasadeni politiky podla vlastnych potrieb */


#define PTS_LABELLEN 23		// max dlzka labelov
#define SYSTEM_USERS {0,1,2,3,4,5,6,7,8,9,10,13,33,34,38,39,41,65534,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114}	// systemovi uzivatelia

/* STANDARD SECURITY BOUNDS */
#define C_MIN 0
#define C_MAX 2

#define I_MIN 0
#define I_MAX 2

/* SYSTEM CONSTANTS */

#define DEF_C_APPR 1
#define DEF_C_SHAR 1
#define DEF_I_SHAR 1


/* OBJECT PTS CLASS CONSTANTS */

#define DEF_C_O 1
#define DEF_I_O 1
#define DEF_L_O "\0"
#define DEF_U_O 0

/* SUBJECT PTS CLASS CONSTANTS */

#define DEF_CR_S 1
#define DEF_CW_S 1
#define DEF_CRL_S 1
#define DEF_CWL_S 1

#define DEF_IR_S 1
#define DEF_IW_S 1
#define DEF_IRL_S 1
#define DEF_IWL_S 1

#define DEF_CN_S 1
#define DEF_IN_S 1
#define DEF_U_S 0
#define DEF_LN_S "\0"

/* koniec moznosti editacie */











#define XATTR_PTS_SUFFIX "PTS"
#define XATTR_NAME_PTS XATTR_SECURITY_PREFIX XATTR_PTS_SUFFIX

#define XATTR_BIN_PTS_SUFFIX "BIN_PTS"
#define XATTR_NAME_BIN_PTS XATTR_SECURITY_PREFIX XATTR_BIN_PTS_SUFFIX

#define task_security(task)     (task_cred_xxx((task), security))



extern int system_users[];

static void printBoolean(int boolean) {
	if (boolean == 0) {
		printk(KERN_INFO "FALSE");
	}
	else {
		printk(KERN_INFO "TRUE");
	}
}

static void normalize_label(char *from, char *to) {
	int i;
	int end_founded = 0;
	for (i=0; i<PTS_LABELLEN; i++) {
		if (end_founded) {
			to[i] = '\0';
		}
		else {
			if (from[i] == '\0') {
				end_founded = 1;
			}
			to[i] = from[i];
		}
	}
	to[PTS_LABELLEN] = '\0';
}


static char *normalized_label(char *from) {
	char *result = kzalloc(sizeof(char)*PTS_LABELLEN, GFP_KERNEL);
	normalize_label(from,result);
	return result;
}

static int valid_char(char ch) {
	if ( ((ch >= 'a') && (ch <= 'z')) || ((ch >= 'A') && (ch <= 'Z')) || ((ch >= '0') && (ch <= '9')) )
		return 1;
	return 0;
}

static int is_digit(char ch) {
	if ( (ch >= '0') && (ch <= '9') )
		return 1;
	return 0;
}

/* LABEL item */

struct label_item {
	struct list_head list;
	char label[PTS_LABELLEN];
};

static struct label_item *new_label_item(char *labelArg) {
	struct label_item *result;
	result = kzalloc(sizeof(struct label_item), GFP_KERNEL);
	if (result == NULL) {
		return NULL;
	}
	result->label[0] = '\0';
	normalize_label(labelArg,result->label);
	return result;

}

static struct label_item *new_label_item_gfp(char *labelArg,gfp_t gfp) {
	struct label_item *result;
	result = kzalloc(sizeof(struct label_item), gfp);
	if (result == NULL) {
		return NULL;
	}
	result->label[0] = '\0';
	normalize_label(labelArg,result->label);
	return result;

}

static void free_label_item(struct label_item *li) {
	kfree(li);
}

static void print_label_item(struct label_item *li) {
	printk(KERN_INFO "%s;",li->label);
}

static int compare_label_items(struct label_item *li1, struct label_item *li2) {
	return strncmp(li1->label, li2->label, PTS_LABELLEN);
}


/* UID item */

struct user_id_item {
	struct list_head list;
	uid_t user_id;
};


/* standardne metody ku wrapperom labelov a uid */
static struct user_id_item *new_user_id_item(unsigned int usId) {
	struct user_id_item *result;
	result = kzalloc(sizeof(struct user_id_item), GFP_KERNEL);
	if (result == NULL) {
		return NULL;
	}
	result->user_id = usId;
	return result;

}

static struct user_id_item *new_user_id_item_gfp(unsigned int usId,gfp_t gfp) {
	struct user_id_item *result;
	result = kzalloc(sizeof(struct user_id_item), gfp);
	if (result == NULL) {
		return NULL;
	}
	result->user_id = usId;
	return result;

}

static void free_user_id_item(struct user_id_item *uidi) {
	kfree(uidi);
}

static void print_user_id_item(struct user_id_item *uidi) {
	printk(KERN_INFO "%d;",uidi->user_id);
}

static int compare_user_id_items(struct user_id_item *uidi1, struct user_id_item *uidi2) {
	if (uidi1->user_id == uidi2->user_id) {
		return 0;
	}
	return 1;
}


/* vseobecne makra pre pracu s listami */

#define display(sec_struct,zoznam_member,item_type,member,pfunction) {\
	item_type *item;\
	list_for_each_entry(item, &(sec_struct->zoznam_member), member) {\
		pfunction(item);\
	}\
}\


#define clear(sec_struct,zoznam_member,item_type,member,dfunction) {\
	item_type *item;\
	item_type *lookahead;\
	list_for_each_entry_safe(item, lookahead, &(sec_struct->zoznam_member), member) {\
		list_del(&(item->member));\
		dfunction(item);\
	}\
}\



#define containsDefinition(fName,lock_member,item_type,member,valueType,cfunction,afunction,dfunction) static int fName (struct subject_pts *sec_struct,struct list_head *zoznam,valueType value) {\
	int found = 0;\
	item_type *item;\
	item_type *new_item = afunction(value);\
	list_for_each_entry(item, zoznam, member) {\
		if (!cfunction(item,new_item)) {\
			found = 1;\
			break;\
		}\
	}\
	dfunction(new_item);\
	return found;\
}



#define add(sec_struct,lock_member,zoznam,item_type,member,value,cfunction,afunction,dfunction) {\
	int found = 0;\
	item_type *item;\
	item_type *new_item = afunction(value);\
	list_for_each_entry(item, &(sec_struct->zoznam), member) {\
		if (!cfunction(item,new_item)) {\
			found = 1;\
			break;\
		}\
	}\
	if (!found) {\
		list_add(&new_item->member, &(sec_struct->zoznam));\
	}\
	else {\
		dfunction(new_item);\
	}\
}

#define add_gfp(sec_struct,lock_member,zoznam,item_type,member,value,cfunction,afunction,dfunction,gfp) {\
	int found = 0;\
	item_type *item;\
	item_type *new_item = afunction(value,gfp);\
	list_for_each_entry(item, &(sec_struct->zoznam), member) {\
		if (!cfunction(item,new_item)) {\
			found = 1;\
			break;\
		}\
	}\
	if (!found) {\
		list_add(&new_item->member, &(sec_struct->zoznam));\
	}\
	else {\
		dfunction(new_item);\
	}\
}



#define delete(sec_struct,lock_member,zoznam,item_type,member,value,cfunction,afunction,dfunction) {\
	item_type *item;\
	item_type *new_item = afunction(value);\
	int found = 0;\
	list_for_each_entry(item, &(sec_struct->zoznam), member) {\
		if (!cfunction(item,new_item)) {\
			found = 1;\
			break;\
		}\
	}\
	if (found) {\
		list_del(&(item->member));\
		dfunction(item);\
	}\
	dfunction(new_item);\
}\






extern int c_appr;
extern int c_shar;
extern int i_shar;


extern int def_c_o;
extern int def_i_o;
extern char *def_l_o;
extern uid_t def_u_o;

/* kontrola hranic */

static int c_value_in_bounds(int c) {
	if (c > C_MAX)
		return 0;
	if (c < C_MIN)
		return 0;
	return 1;
}

static int i_value_in_bounds(int i) {
	if (i > I_MAX)
		return 0;
	if (i < I_MIN)
		return 0;
	return 1;
}




static void normalize_c_value(int *c) {
	if (*c < C_MIN)
		*c = C_MIN;
	if (*c > C_MAX)
		*c = C_MAX;	
}

static void normalize_i_value(int *i) {
	if (*i < I_MIN)
		*i = I_MIN;
	if (*i > I_MAX)
		*i = I_MAX;	
}



/* BEZPECNOSTNA STRUKTURA OBJEKTOV */

struct object_pts {
	int c_o;
	int i_o;
	char l_o[PTS_LABELLEN];
	uid_t u_o;

	struct mutex lock; // locky nevyuzivam
};


/* novy objekt s defaultnymi atributmi */
static struct object_pts  *new_object_pts(void) {
	struct object_pts *result;
	result = kzalloc(sizeof(struct object_pts), GFP_KERNEL);
	if (result == NULL) {
		return NULL;
	}
	result->c_o = def_c_o;
	result->i_o = def_i_o;
	result->l_o[0] = '\0';
	normalize_label(def_l_o, result->l_o);
	result->u_o = def_u_o;
	mutex_init(&(result->lock));
	return result;
}

static void del_object_pts(struct object_pts *del_obj) {
	kfree(del_obj);
}

/* zmena objektu podla textovej reprezentacie */
static int string_to_object_pts(char *s, struct object_pts *obj) {
	int next_member(char *s) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if (strncmp("c_o=",s,4) == 0) {
			return 1; // c_o
		}
		if (strncmp("i_o=",s,4) == 0) {
			return 2; // i_o
		}

		if ( strncmp("u_o=",s,4) == 0) {
			return 3; // u_o
		}
		if ( strncmp("l_o=",s,4) == 0) {
			return 4; // l_o
		}
		return -EINVAL;
	}

	int load_value(char *s,int member, struct object_pts *obj) {
		int plus = 1;
		int num = 0,cifra,i,counter=0;
		if ( (member==1) || (member==2) ) {
			if (*s == '+') {
				s++;
				counter++;
			}
			else if (*s == '-') {
				plus = 0;
				s++;
				counter++;
			}
			while (*s != ';') {
				cifra = ((*s)-'0');
				num *= 10;
				num += cifra;
				s++;
				counter++;
			}
			if (!plus)
				num *= (-1);
			if (member == 1) {
				obj->c_o = num;
			}
			else {
				obj->i_o = num;
			}
			return counter;
		}
		else if (member == 3) {
			/* ZMENA UZIVATELA SA ROBI TRADICNE */
			while (*s != ';') {
				s++;
				counter++;
			}
			return counter;
		}
		else if (member == 4) {
			for (i=0; i<PTS_LABELLEN; i++) {
				obj->l_o[i] = '\0';
			}
			i = 0;
			while (*s != ';') {
				obj->l_o[i] = *s;
				s++;
				counter++;
				i++;
			}
			return counter;
		}
		else
			return -EINVAL;
	}

	int rc,rc2;
	if (obj==NULL) {
		return -EINVAL;
	}
	
	
	rc = next_member(s);
	
	mutex_lock(&(obj->lock));
	while (rc != 0) {
		if (rc < 0) {
			mutex_unlock(&(obj->lock));
			return rc;
		}
		s += 4;
		rc2 = load_value(s, rc, obj);
		if (rc2 < 0) {
			mutex_unlock(&(obj->lock));
			return rc2;
		}
		s += (rc2+1);
		rc = next_member(s);
	}
	mutex_unlock(&(obj->lock));
	return 0;
}



/* validacia textovej reprezentacie */
static int valid_object_pts_string(char *s) {
	int next_member(char *s) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if ( (strncmp("c_o=",s,4) == 0) || (strncmp("i_o=",s,4) == 0) ) {
			return 1; // int
		}
		if ( strncmp("u_o=",s,4) == 0) {
			return 2; // unsigned int
		}
		if ( strncmp("l_o=",s,4) == 0) {
			return 3; // PTS_LABEL
		}
		return -EINVAL;

	}

	// vracia pocet precitanych spravnych symbolov,alebo zapornu chybu
	int check_member(char *s, int m) {
		int counter = 0,i;
		if (m == 1) {
			if ( (*s == '+') || (*s == '-') ) {
				s++;
				counter++;
			}
		}
		if ( (m == 1) || (m == 2) ) {
			i = 0;
			while ( (*s != ';') ) {
				if ( (!is_digit(*s)) || (*s == '\0') || (counter > 10) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m == 3) {
			i = 0;
			while ( (*s != ';') ) {
				if ( (!valid_char(*s)) || (*s == '\0') || (counter > PTS_LABELLEN) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		return counter;
	}

	int rc,rc2;

	rc = next_member(s);
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += 4;
		rc2 = check_member(s, rc);
		if (rc2 < 0)
			return rc2;
		s += (rc2+1);
		rc = next_member(s);
	}
	return 0;
}

/* pomocne funkcie */
static int int_len(int i) {
	int result = 1;
	if (i<0) {
		result++;
	}
	i /= 10;
	while (i != 0) {
		result++;
		i /= 10;
	}
	return result;
}

static int str_len(char *s,int max) {
	int result = 0;
	if (s==NULL) {
		return 0;
	}
	while ( (*s !='\0') && ( (max < 0) || (result < max) ) ) {
		result++;
		s++;
	}
	return result;
}

static int str_append(char *from, char *to) {
	int size = 0;
	while (*from != '\0') {
		(*to) = (*from);
		from++;
		to++;
		size++;
	}
	return size;
}

static int int_append(int from, char *to) {
	int l,i,cifra,size = 0;
	char *s;
	if (from < 0) {
		*to = '-';
		to++;
		from = from*(-1);
		size++;
	}
	l = int_len(from);
	s = kzalloc(sizeof(char)*l, GFP_KERNEL);
	if (s == NULL) {
		return -ENOMEM;
	}
	for (i = 0; i < l; i++) {
		cifra = from % 10;
		from /= 10;
		s[i] = ('0'+cifra-0);
	}
	for (i = l-1; i >= 0; i--) {
		(*to) = s[i];
		to++;
		size++;
	}
	kfree(s);
	return size;
}



/* serializacia */
/* U_O zapamatane inde,nebude sa udrziavat v xattr */

static char *object_pts_to_string(struct object_pts *obj, int *size) {
	char *result = NULL,*s;
	int len = 1,rc;
	if (obj == NULL) {
		*size = -EINVAL;
		return NULL;
	}

	len += int_len(obj->c_o);
	len += int_len(obj->i_o);
	len += str_len(obj->l_o,-1);
	len += 20;

	result = kzalloc(sizeof(char)*len, GFP_KERNEL);
	if (result == NULL) {
		*size = -ENOMEM;
		goto unlock_fault;
	}
	result[len-1] = '\0';
	s = result;

	
	s += str_append("c_o=\0",s);
	rc = int_append(obj->c_o,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);



	s += str_append("i_o=\0",s);
	rc = int_append(obj->i_o,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);



	s += str_append("l_o=\0",s);
	s += str_append(obj->l_o,s);
	s += str_append(";\0",s);


	mutex_unlock(&(obj->lock));

	*size = len;
	return result;

	unlock_fault:
		mutex_unlock(&(obj->lock));
		return NULL;
}


/* kontrola hranic */
static int bounded_object_pts_struct(struct object_pts *ob) {
	if (ob->c_o > C_MAX)
		return 0;
	if (ob->c_o < C_MIN)
		return 0;
	if (ob->i_o > I_MAX) 
		return 0;
	if (ob->i_o < I_MIN) 
		return 0;
	return 1;
}

static int bounded_object_pts_string(char *s) {
	int next_member(char *s) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if (strncmp("c_o=",s,4) == 0) {
			return 1; // c_o
		}
		if (strncmp("i_o=",s,4) == 0) {
			return 2; // i_o
		}

		if ( strncmp("u_o=",s,4) == 0) {
			return 3; // u_o
		}
		if ( strncmp("l_o=",s,4) == 0) {
			return 4; // l_o
		}
		return -EINVAL;
	}

	int load_value(char *s,int member) {
		int plus = 1;
		int num = 0,cifra,i,counter=0;
		if ( (member==1) || (member==2) ) {
			if (*s == '+') {
				s++;
				counter++;
			}
			else if (*s == '-') {
				plus = 0;
				s++;
				counter++;
			}
			while (*s != ';') {
				cifra = ((*s)-'0');
				num *= 10;
				num += cifra;
				s++;
				counter++;
			}
			if (!plus)
				num *= (-1);
			if (member == 1) {
				if (! c_value_in_bounds(num))
					return 0;
			}
			else {
				if (! i_value_in_bounds(num))
					return 0;
			}
			return counter;
		}
		else if (member == 3) {
			/* ZMENA UZIVATELA SA ROBI TRADICNE */
			while (*s != ';') {
				s++;
				counter++;
			}
			return counter;
		}
		else if (member == 4) {
			i = 0;
			while (*s != ';') {
				s++;
				counter++;
				i++;
			}
			return counter;
		}
		else
			return -EINVAL;
	}

	int rc,rc2;	

	if (valid_object_pts_string(s) != 0)
		return -EINVAL;
	
	
	rc = next_member(s);
	
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += 4;
		rc2 = load_value(s, rc);
		if (rc2 <= 0) {
			return rc2;
		}
		s += (rc2+1);
		rc = next_member(s);
	}
	return 1;
}




extern int def_cr_s;
extern int def_cw_s;
extern int def_crl_s;
extern int def_cwl_s;

extern int def_ir_s;
extern int def_iw_s;
extern int def_irl_s;
extern int def_iwl_s;

extern int def_cn_s;
extern int def_in_s;
extern uid_t def_u_s;
extern char *def_ln_s;

/* zakladna struktura pre subjekty */

struct subject_pts {
	int cr_s;
	int cw_s;
	int crl_s;
	int cwl_s;
	struct list_head crls_s;
	struct list_head cwls_s;

	int ir_s;
	int iw_s;
	int irl_s;
	int iwl_s;
	struct list_head irls_s;
	struct list_head iwls_s;

	int cn_s;
	int in_s;
	char ln_s[PTS_LABELLEN];
	uid_t u_s;
	struct list_head irus_s;
	struct list_head cwus_s;

	int mac_admin;
	int chown;
	int setuid;

	int heritable;
	struct mutex lock;	// nepouzivane
};

/* makra pre pracu s mnozinami */

#define display_label_list(ss,z) display(ss,z,struct label_item,list,print_label_item)
#define display_user_id_list(ss,z) display(ss,z,struct user_id_item ,list,print_user_id_item)

#define clear_label_list(ss,z) clear(ss,z,struct label_item,list,free_label_item)
#define clear_user_id_list(ss,z) clear(ss,z,struct user_id_item,list,free_user_id_item)

#define add_label_list(ss,z,val) add(ss,lock,z,struct label_item,list,val,compare_label_items,new_label_item,free_label_item)
#define add_user_id_list(ss,z,val) add(ss,lock,z,struct user_id_item,list,val,compare_user_id_items,new_user_id_item,free_user_id_item)

#define add_label_list_gfp(ss,z,val,gfp) add_gfp(ss,lock,z,struct label_item,list,val,compare_label_items,new_label_item_gfp,free_label_item,gfp)
#define add_user_id_list_gfp(ss,z,val,gfp) add_gfp(ss,lock,z,struct user_id_item,list,val,compare_user_id_items,new_user_id_item_gfp,free_user_id_item,gfp)

#define del_label_list(ss,z,val) delete(ss,lock,z,struct label_item,list,val,compare_label_items,new_label_item,free_label_item)
#define del_user_id_list(ss,z,val) delete(ss,lock,z,struct user_id_item,list,val,compare_user_id_items,new_user_id_item,free_user_id_item)

containsDefinition(contains_label_listFn,lock,struct label_item,list,char*,compare_label_items,new_label_item,free_label_item)
containsDefinition(contains_user_id_listFn,lock,struct user_id_item,list,uid_t,compare_user_id_items,new_user_id_item,free_user_id_item)

#define contains_label_list(ss,z,val) contains_label_listFn(ss,&(ss->z),val)
#define contains_user_id_list(ss,z,val) contains_user_id_listFn(ss,&(ss->z),val)

#define set_member(ss,memb,val) ss->memb = val;


/* resetovanie na defaultne hodnoty */
static void reset_subject_pts(struct subject_pts *del_sub) {
	struct label_item *entry;
	struct label_item *lookahead;


	list_for_each_entry_safe(entry,lookahead,&(del_sub->crls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->cwls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->irls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->iwls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}
	{
	struct user_id_item *entry,*lookahead;

	list_for_each_entry_safe(entry,lookahead,&(del_sub->irus_s),list) {
		list_del(&(entry->list));
		free_user_id_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->cwus_s),list) {
		list_del(&(entry->list));
		free_user_id_item(entry);
	}
	}
	
	del_sub->cr_s = 1;
	del_sub->cw_s = 1;
	del_sub->crl_s = 1;
	del_sub->cwl_s = 1;

	del_sub->ir_s = 1;
	del_sub->iw_s = 1;
	del_sub->irl_s = 1;
	del_sub->iwl_s = 1;

	del_sub->cn_s = 1;
	del_sub->in_s = 1;
	normalize_label("\0",del_sub->ln_s);
	del_sub->heritable = -1;
}

/* zmena atributov podla textovej reprezentacie, pred zmenou reset atributov, moznost neresetovat dedicnost */
static int string_to_subject_pts(char *s, struct subject_pts *sub, int resetHeritable) {
	int next_member(char *s,int *member,int* op) {
		int i = 1,temp,len = 0;
		char *memb[]={"\0","cr_s\0","cw_s\0","ir_s\0","iw_s\0","cn_s\0","in_s\0","crl_s\0","cwl_s\0","irl_s\0","iwl_s\0", // 1-10
						"crls_s\0","cwls_s\0","irls_s\0","iwls_s\0", // 11-14
						"irus_s\0","cwus_s\0",	// 15-16
						"ln_s\0","heritable\0"};	//17,18
		char *ops[] = {"=\0","+=\0","-=\0"};

		*op = 0;
		*member = 0;

		if (*s == '\0') {
			*member = 0;
			*op = 0;
			return 0; // end of string
		}

		for (i=1; i<=18; i++) {
			if (strncmp(memb[i],s,str_len(memb[i],-1)) == 0) {
				*member = i;
				temp = str_len(memb[i],-1);
				len += temp;
				s += temp;
				goto op_find;
			}
		}
		return -EINVAL;

		op_find:
			for (i=0; i<=2; i++) {
				if (strncmp(ops[i],s,str_len(ops[i],-1)) == 0) {
					*op = i;
					temp = str_len(ops[i],-1);
					len += temp;
					s += temp;
					goto result;
				}
			}
		return -EINVAL;

		result:
			if ( ( ((*member >= 1) && (*member <= 10))   ||  (*member == 17) || (*member == 18) ) && (*op != 0) )
				return -EINVAL;
			return len;

		return -EINVAL;
	}

	int load_value(char *s, struct subject_pts *sub, int member, int op) {
		/* return values: <0 ERROR   0 END    1 NEXT INT CONTINUING */
		int load_int(char *s, int *result, int *len) {
			int cifra;
			int plus = 1;
			*len = 0;
			*result = 0;
			if (*s == '+') {
				s++;
				(*len)++;
			}
			else if (*s == '-') {
				plus = 0;
				s++;
				(*len)++;
			}
			while (is_digit(*s)) {
				cifra = ((*s)-'0');
				(*result) *= 10;
				(*result) += cifra;
				s++;
				(*len)++;
			}
			if (!plus) {
				(*result) *= (-1);
			}
			if (*s == ';') {
				return 0;
			}
			else if (*s == ',') {
				(*len)++;
				return 1;
			}
			return -EINVAL;
		}

		/* return values: <0 ERROR   0 END    1 NEXT LABEL CONTINUING */
		int load_label(char *s, char *result, int *len) {
			int i;
			*len = 0;
			for (i=0; i< PTS_LABELLEN; i++) {
				result[i]='\0';
			}
			while (valid_char(*s) && (*len <PTS_LABELLEN)) {
				result[*len] = *s;
				s++;
				(*len)++;
			}
			if (*len == PTS_LABELLEN)
				return -EINVAL;
			result[(*len)+1] = '\0';
			if (*s == ';') {
				return 0;
			}
			else if (*s == ',') {
				(*len)++;
				return 1;
			}
			return -EINVAL;
		}

		int counter = 0,len = 0,num = 0,rc;
		char label[PTS_LABELLEN];

		if ( (member>=15) && (member<=16) ) {
			if (op == 0) {
				if (member == 15)
					clear_user_id_list(sub,irus_s);
				if (member == 16)
					clear_user_id_list(sub,cwus_s);
			}
			if ( (op == 0) || (op == 1) ) {
				rc = load_int(s,&num,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (member == 15)
						add_user_id_list(sub,irus_s,num);
					if (member == 16)
						add_user_id_list(sub,cwus_s,num);
					if (rc == 0)
						return counter;
					rc = load_int(s,&num,&len);
				}
			}
			if (op == 2) {
				rc = load_int(s,&num,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (member == 11)
						del_user_id_list(sub,irus_s,num);
					if (member == 12)
						del_user_id_list(sub,cwus_s,num);
					if (rc == 0)
						return counter;
					rc = load_int(s,&num,&len);
				}
			}

		}
		if ( (member>=11) && (member<=14) ) {
			if (op == 0) {
				if (member == 11)
					clear_label_list(sub,crls_s);
				if (member == 12)
					clear_label_list(sub,cwls_s);
				if (member == 13)
					clear_label_list(sub,irls_s);
				if (member == 14)
					clear_label_list(sub,iwls_s);
			}
			if ( (op == 0) || (op == 1) ) {
				rc = load_label(s,label,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (member == 11)
						add_label_list(sub,crls_s,label);
					if (member == 12)
						add_label_list(sub,cwls_s,label);
					if (member == 13)
						add_label_list(sub,irls_s,label);
					if (member == 14)
						add_label_list(sub,iwls_s,label);
					if (rc == 0)
						return counter;
					rc = load_label(s,label,&len);
				}
			}
			if (op == 2) {
				rc = load_label(s,label,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (member == 11)
						del_label_list(sub,crls_s,label);
					if (member == 12)
						del_label_list(sub,cwls_s,label);
					if (member == 13)
						del_label_list(sub,irls_s,label);
					if (member == 14)
						del_label_list(sub,iwls_s,label);
					if (rc == 0)
						return counter;
					rc = load_label(s,label,&len);
				}
			}


		}
		if ( ( (member >= 1) && (member <= 10) )   ||  (member == 18)  ) {
			rc = load_int(s,&num,&len);
			if (rc != 0) {
				return -EINVAL;
			}
			counter = len;
			if (member == 18) {
				sub->heritable = num;
			}
			else if (member == 1) {
				sub->cr_s = num;
			}
			else if (member == 2) {
				sub->cw_s = num;
			}
			else if (member == 3) {
				sub->ir_s = num;
			}
			else if (member == 4) {
				sub->iw_s = num;
			}
			else if (member == 5) {
				sub->cn_s = num;
			}
			else if (member == 6) {
				sub->in_s = num;
			}
			else if (member == 7) {
				sub->crl_s = num;
			}
			else if (member == 8) {
				sub->cwl_s = num;
			}
			else if (member == 9) {
				sub->irl_s = num;
			}
			else if (member == 10) {
				sub->iwl_s = num;
			}
			return counter;
		}
		if (member == 17) {
			rc = load_label(s, label, &len);
			if (rc != 0) {
				return -EINVAL;
			}
			counter = len;
			normalize_label(label,sub->ln_s);
			return counter;
		}
		return -EINVAL;
	}

	int mem,op,oldHeritable;
	int rc,rc2;

	if (sub==NULL) {
		return -EINVAL;
	}
	oldHeritable = sub->heritable;
	reset_subject_pts(sub);
	if (resetHeritable == 0) {		
		sub->heritable = oldHeritable;
	}
	
	rc = next_member(s,&mem,&op);
	//mutex_lock(&(sub->lock));
	while (rc != 0) {
		if (rc < 0) {
			//mutex_unlock(&(sub->lock));
			return rc;
		}
		s += rc;
		rc2 = load_value(s, sub, mem, op);
		if (rc2 < 0) {
			//mutex_unlock(&(sub->lock));
			return rc2;
		}
		s += (rc2+1);
		rc = next_member(s,&mem,&op);
	}
	//mutex_unlock(&(sub->lock));
	return 0;


}

/* validacia textovej reprezentacie */
static int valid_subject_pts_string(char *s) {
	int next_member(char *s,int *len) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if ( (strncmp("cr_s=",s,5) == 0) || (strncmp("cw_s=",s,5) == 0) ||
		    (strncmp("ir_s=",s,5) == 0) || (strncmp("iw_s=",s,5) == 0) ||
		    (strncmp("cn_s=",s,5) == 0) || (strncmp("in_s=",s,5) == 0) ) {
			*len =  5;
			return 1; // int
		}
		if (strncmp("heritable=",s,10) == 0) {
			*len = 10;
			return 1; // int
		}
		if ( (strncmp("crl_s=",s,6) == 0) || (strncmp("cwl_s=",s,6) == 0) ||
		    (strncmp("irl_s=",s,6) == 0) || (strncmp("iwl_s=",s,6) == 0) ) {
			*len =  6;
			return 1; //int
		}
		if ( strncmp("ln_s=",s,5) == 0) {
			*len =  5;
			return 2; // PTS_LABEL
		}
		if ( (strncmp("crls_s=",s,7) == 0)  || (strncmp("cwls_s=",s,7) == 0)  ||
		    (strncmp("irls_s=",s,7) == 0) || (strncmp("iwls_s=",s,7) == 0)  ) {
			*len = 7;
			return 3; // PTS_LABEL LIST
		}

		if ( (strncmp("crls_s+=",s,8) == 0) || (strncmp("crls_s-=",s,8) == 0) ||
		     (strncmp("cwls_s+=",s,8) == 0) || (strncmp("cwls_s-=",s,8) == 0) ||
		     (strncmp("irls_s+=",s,8) == 0) || (strncmp("irls_s-=",s,8) == 0) ||
		     (strncmp("iwls_s+=",s,8) == 0) || (strncmp("iwls_s-=",s,8) == 0) ) {
			*len = 8;
			return 3; // PTS_LABEL LIST
		}
		if  ( (strncmp("irus_s=",s,7) == 0) || (strncmp("cwus_s=",s,7) == 0)  ) {
			*len = 7;
			return 4; // UID LIST
		}
		if  ( (strncmp("irus_s+=",s,8) == 0) || (strncmp("irus_s-=",s,8) == 0) ||
		    (strncmp("cwus_s+=",s,8) == 0) || (strncmp("cwus_s-=",s,8) == 0) ) {
			*len = 8;
			return 4; // UID LIST
		}

		return -EINVAL;
	}

	int check_member(char *s, int m) {
		int counter = 0,i = 0;
		if (m==1) {
			if ( (*s == '+') || (*s == '-') ) {
				s++;
				counter++;
			}
			while ( (*s != ';') ) {
				if ( (!is_digit(*s)) || (*s == '\0') || (counter > 10) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m==2) {
			while ( (*s != ';') ) {
				if ( (!valid_char(*s)) || (*s == '\0') || (counter > PTS_LABELLEN) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m==3) {
			while (true) {
				i = 0;
				while ( (valid_char(*s)) && (i < PTS_LABELLEN) ){
					i++;
					s++;
					counter++;
				}
				if (*s == ',') {
					s++;
					counter++;
					continue;
				}
				else if (*s == ';')
					return counter;
				else
					return -EINVAL;
			}
		}
		else if (m==4) {
			while (true) {
				i = 0;
				if ( (*s == '+') || (*s=='-') ) {
					s++;
					counter++;
					i++;
				}
				while ( (is_digit(*s)) && (i <= 10) ){
					i++;
					s++;
					counter++;
				}
				if (*s == ',') {
					s++;
					counter++;
					continue;
				}
				else if (*s == ';')
					return counter;
				else
					return -EINVAL;
			}
		}
		return counter;
	}

	int rc,rc2,len = 0;

	rc = next_member(s,&len);
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += len;
		rc2 = check_member(s, rc);
		if (rc2 < 0)
			return rc2;
		s += (rc2+1);
		rc = next_member(s,&len);
	}
	return 0;
}

/* serializacia */
static char *subject_pts_to_string(struct subject_pts *sub, int *size) {
	char *result = NULL,*s;
	struct label_item *label;
	struct user_id_item *uid;

	int len = 1,rc,posun = 0,empty = 1;
	if (sub == NULL) {
		*size = -EINVAL;
		return NULL;
	}
	//mutex_lock(&(sub->lock));
	len += (int_len(sub->heritable)+11);
	len += (int_len(sub->cr_s)+6);
	len += (int_len(sub->cw_s)+6);
	len += (int_len(sub->crl_s)+7);
	len += (int_len(sub->cwl_s)+7);


	len += 7;
	list_for_each_entry(label, &(sub->crls_s), list) {
		len += (str_len(label->label,PTS_LABELLEN)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}


	empty = 1;
	len += 7;
	list_for_each_entry(label, &(sub->cwls_s), list) {
		len += (str_len(label->label,PTS_LABELLEN)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}


	len += (int_len(sub->ir_s)+6);
	len += (int_len(sub->iw_s)+6);
	len += (int_len(sub->irl_s)+7);
	len += (int_len(sub->iwl_s)+7);


	empty = 1;
	len += 7;
	list_for_each_entry(label, &(sub->irls_s), list) {
		len += (str_len(label->label,PTS_LABELLEN)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}


	empty = 1;
	len += 7;
	list_for_each_entry(label, &(sub->iwls_s), list) {
		len += (str_len(label->label,PTS_LABELLEN)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}



	len += (int_len(sub->cn_s)+6);
	len += (int_len(sub->in_s)+6);
	len += (str_len(sub->ln_s,PTS_LABELLEN)+6);



	empty = 1;
	len += 7;
	list_for_each_entry(uid, &(sub->irus_s), list) {
		len += (int_len(uid->user_id)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}

	empty = 1;
	len += 7;
	list_for_each_entry(uid, &(sub->cwus_s), list) {
		len += (int_len(uid->user_id)+1);
		empty = 0;
	}
	if (empty) {
		len++;
	}


	result = kzalloc(sizeof(char)*len, GFP_KERNEL);
	if (result == NULL) {
		*size = -ENOMEM;
		goto unlock_fault;
	}
	result[len-1] = '\0';
	s = result;


	s += str_append("heritable=\0",s);
	rc = int_append(sub->heritable,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);
	
	
	s += str_append("cr_s=\0",s);
	rc = int_append(sub->cr_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);


	s += str_append("cw_s=\0",s);
	rc = int_append(sub->cw_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);

	s += str_append("crl_s=\0",s);
	rc = int_append(sub->crl_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);


	s += str_append("cwl_s=\0",s);
	rc = int_append(sub->cwl_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);

	posun = 0;
	s += str_append("crls_s=\0",s);
	list_for_each_entry(label, &(sub->crls_s), list) {
		s += str_append(label->label,s);
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;


	s += str_append("cwls_s=\0",s);
	list_for_each_entry(label, &(sub->cwls_s), list) {
		s += str_append(label->label,s);
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;


	s += str_append("ir_s=\0",s);
	rc = int_append(sub->ir_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);

	s += str_append("iw_s=\0",s);
	rc = int_append(sub->iw_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);

	s += str_append("irl_s=\0",s);
	rc = int_append(sub->irl_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);


	s += str_append("iwl_s=\0",s);
	rc = int_append(sub->iwl_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);


	posun = 0;
	s += str_append("irls_s=\0",s);
	list_for_each_entry(label, &(sub->irls_s), list) {
		s += str_append(label->label,s);
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;


	s += str_append("iwls_s=\0",s);
	list_for_each_entry(label, &(sub->iwls_s), list) {
		s += str_append(label->label,s);
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;


	s += str_append("cn_s=\0",s);
	rc = int_append(sub->cn_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);

	s += str_append("in_s=\0",s);
	rc = int_append(sub->in_s,s);
	if (rc < 0) {
		*size = rc;
		goto unlock_fault;
	}
	s += rc;
	s += str_append(";\0",s);


	s += str_append("ln_s=\0",s);
	s += str_append(sub->ln_s,s);
	s += str_append(";\0",s);


	s += str_append("irus_s=\0",s);
	list_for_each_entry(uid, &(sub->irus_s), list) {
		rc = int_append(uid->user_id,s);
		if (rc < 0) {
			*size = rc;
			goto unlock_fault;
		}
		s += rc;
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;



	s += str_append("cwus_s=\0",s);
	list_for_each_entry(uid, &(sub->cwus_s), list) {
		rc = int_append(uid->user_id,s);
		if (rc < 0) {
			*size = rc;
			goto unlock_fault;
		}
		s += rc;
		s += str_append(",\0",s);
		posun = -1;
	}
	s[posun] = ';';
	if (posun == 0)
		s++;
	posun = 0;


	//mutex_unlock(&(sub->lock));

	*size = len;
	return result;

	unlock_fault:
		//mutex_unlock(&(sub->lock));
		return NULL;
}

/* novy subjekt s defaultnymi atributmi */
static struct subject_pts  *new_subject_pts(gfp_t gfp) {
	struct subject_pts *result;
	result = kzalloc(sizeof(struct subject_pts), gfp);
	if (result == NULL) {
		return NULL;
	}

	result->heritable = -1;
	
	result->cr_s = def_cr_s;
	result->cw_s = def_cw_s;
	result->crl_s = def_crl_s;
	result->cwl_s = def_cwl_s;

	result->ir_s = def_ir_s;
	result->iw_s = def_iw_s;
	result->irl_s = def_irl_s;
	result->iwl_s = def_iwl_s;

	result->cn_s = def_cn_s;
	result->in_s = def_in_s;
	result->u_s = def_u_s;
	result->ln_s[0] = '\0';
	normalize_label(def_ln_s, result->ln_s);

	INIT_LIST_HEAD(&(result->crls_s));
	INIT_LIST_HEAD(&(result->cwls_s));
	INIT_LIST_HEAD(&(result->irls_s));
	INIT_LIST_HEAD(&(result->iwls_s));
	INIT_LIST_HEAD(&(result->irus_s));
	INIT_LIST_HEAD(&(result->cwus_s));

	result->mac_admin = 0;
	result->chown = 0;
	result->setuid = 0;
	mutex_init(&(result->lock));

	return result;
}


/* duplikacia subject_pts struktury */
static struct subject_pts *duplicate_subject_pts(struct subject_pts *sub,gfp_t gfp) {
	struct subject_pts *result = new_subject_pts(gfp);
	struct label_item *label;
	struct user_id_item *uid;

	if (result == NULL) {
		return NULL;
	}

	
	result->heritable = sub->heritable;
	result->cr_s = sub->cr_s;
	result->cw_s = sub->cw_s;
	result->crl_s = sub->crl_s;
	result->cwl_s = sub->cwl_s;

	result->ir_s = sub->ir_s;
	result->iw_s = sub->iw_s;
	result->irl_s = sub->irl_s;
	result->iwl_s = sub->iwl_s;

	result->cn_s = sub->cn_s;
	result->in_s = sub->in_s;
	result->u_s = sub->u_s;

	result->mac_admin = sub->mac_admin;
	result->chown = sub->chown;
	result->setuid = sub->setuid;


	normalize_label(sub->ln_s,result->ln_s);

	list_for_each_entry(label, &(sub->crls_s), list) {
		add_label_list_gfp(result,crls_s,label->label,gfp);
	}

	list_for_each_entry(label, &(sub->cwls_s), list) {
		add_label_list_gfp(result,cwls_s,label->label,gfp);
	}

	list_for_each_entry(label, &(sub->irls_s), list) {
		add_label_list_gfp(result,irls_s,label->label,gfp);
	}

	list_for_each_entry(label, &(sub->iwls_s), list) {
		add_label_list_gfp(result,iwls_s,label->label,gfp);
	}

	list_for_each_entry(uid, &(sub->irus_s), list) {
		add_user_id_list_gfp(result,irus_s,uid->user_id,gfp);
	}

	list_for_each_entry(uid, &(sub->cwus_s), list) {
		add_user_id_list_gfp(result,cwus_s,uid->user_id,gfp);
	}


	
	return result;
}


/* uvolnenie pamate */
static void del_subject_pts(struct subject_pts *del_sub) {
	struct label_item *entry;
	struct label_item *lookahead;

	


	list_for_each_entry_safe(entry,lookahead,&(del_sub->crls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->cwls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->irls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->iwls_s),list) {
		list_del(&(entry->list));
		free_label_item(entry);
	}
	{
	struct user_id_item *entry,*lookahead;

	list_for_each_entry_safe(entry,lookahead,&(del_sub->irus_s),list) {
		list_del(&(entry->list));
		free_user_id_item(entry);
	}

	list_for_each_entry_safe(entry,lookahead,&(del_sub->cwus_s),list) {
		list_del(&(entry->list));
		free_user_id_item(entry);
	}
	}
	
	kfree(del_sub);
}

/* vytvorenie objektu subjektom */
static struct object_pts *new_object_pts_by_subject(struct subject_pts *sub) {
	struct object_pts *obj = new_object_pts();
	obj->c_o = sub->cn_s;
	obj->i_o = sub->in_s;
	normalize_label(sub->ln_s, obj->l_o);
	obj->u_o = sub->u_s;

	return obj;
}

/* kontrola hranic */
static int bounded_subject_pts_struct(struct subject_pts *sub) {
	if (sub->cr_s > C_MAX)
		return 0;
	if (sub->cr_s < C_MIN)
		return 0;
	if (sub->cw_s > C_MAX)
		return 0;
	if (sub->cw_s < C_MIN)
		return 0;
	if (sub->ir_s > I_MAX) 
		return 0;
	if (sub->ir_s < I_MIN) 
		return 0;
	if (sub->iw_s > I_MAX) 
		return 0;
	if (sub->iw_s < I_MIN) 
		return 0;
	return 1;
}


static int bounded_subject_pts_string(char *s) {
	int next_member(char *s,int *member,int* op) {
		int i = 1,temp,len = 0;
		char *memb[]={"\0","cr_s\0","cw_s\0","ir_s\0","iw_s\0","cn_s\0","in_s\0","crl_s\0","cwl_s\0","irl_s\0","iwl_s\0", // 1-10
						"crls_s\0","cwls_s\0","irls_s\0","iwls_s\0", // 11-14
						"irus_s\0","cwus_s\0",	// 15-16
						"ln_s\0","heritable\0"};	//17,18
		char *ops[] = {"=\0","+=\0","-=\0"};

		*op = 0;
		*member = 0;

		if (*s == '\0') {
			*member = 0;
			*op = 0;
			return 0; // end of string
		}

		for (i=1; i<=18; i++) {
			if (strncmp(memb[i],s,str_len(memb[i],-1)) == 0) {
				*member = i;
				temp = str_len(memb[i],-1);
				len += temp;
				s += temp;
				goto op_find;
			}
		}
		return -EINVAL;

		op_find:
			for (i=0; i<=2; i++) {
				if (strncmp(ops[i],s,str_len(ops[i],-1)) == 0) {
					*op = i;
					temp = str_len(ops[i],-1);
					len += temp;
					s += temp;
					goto result;
				}
			}
		return -EINVAL;

		result:
			if ( ( ((*member >= 1) && (*member <= 10))   ||  (*member == 17) || (*member == 18) ) && (*op != 0) )
				return -EINVAL;
			return len;

		return -EINVAL;
	}

	int load_value(char *s, int member, int op) {
		/* return values: <0 ERROR   0 END    1 NEXT INT CONTINUING */
		int load_int(char *s, int *result, int *len) {
			int cifra;
			int plus = 1;
			*len = 0;
			*result = 0;
			if (*s == '+') {
				s++;
				(*len)++;
			}
			else if (*s == '-') {
				plus = 0;
				s++;
				(*len)++;
			}
			while (is_digit(*s)) {
				cifra = ((*s)-'0');
				(*result) *= 10;
				(*result) += cifra;
				s++;
				(*len)++;
			}
			if (!plus) {
				(*result) *= (-1);
			}
			if (*s == ';') {
				return 0;
			}
			else if (*s == ',') {
				(*len)++;
				return 1;
			}
			return -EINVAL;
		}

		/* return values: <0 ERROR   0 END    1 NEXT LABEL CONTINUING */
		int load_label(char *s, char *result, int *len) {
			int i;
			*len = 0;
			for (i=0; i< PTS_LABELLEN; i++) {
				result[i]='\0';
			}
			while (valid_char(*s) && (*len <PTS_LABELLEN)) {
				result[*len] = *s;
				s++;
				(*len)++;
			}
			if (*len == PTS_LABELLEN)
				return -EINVAL;
			result[(*len)+1] = '\0';
			if (*s == ';') {
				return 0;
			}
			else if (*s == ',') {
				(*len)++;
				return 1;
			}
			return -EINVAL;
		}

		int counter = 0,len = 0,num = 0,rc;
		char label[PTS_LABELLEN];

		if ( (member>=15) && (member<=16) ) {
			if ( (op == 0) || (op == 1) ) {
				rc = load_int(s,&num,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (rc == 0)
						return counter;
					rc = load_int(s,&num,&len);
				}
			}
			if (op == 2) {
				rc = load_int(s,&num,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (rc == 0)
						return counter;
					rc = load_int(s,&num,&len);
				}
			}

		}
		if ( (member>=11) && (member<=14) ) {
			if ( (op == 0) || (op == 1) ) {
				rc = load_label(s,label,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (rc == 0)
						return counter;
					rc = load_label(s,label,&len);
				}
			}
			if (op == 2) {
				rc = load_label(s,label,&len);
				while (true) {
					if (rc < 0)
						return -EINVAL;
					counter += len;
					s += len;
					if (rc == 0)
						return counter;
					rc = load_label(s,label,&len);
				}
			}


		}
		if ( ( (member >= 1) && (member <= 10) )   ||  (member == 18)  ) {
			rc = load_int(s,&num,&len);
			if (rc != 0) {
				return -EINVAL;
			}
			counter = len;
			if (member == 1) {
				if (!c_value_in_bounds(num) )
					return 0;
			}
			else if (member == 2) {
				if (!c_value_in_bounds(num) )
					return 0;
			}
			else if (member == 3) {
				if (!i_value_in_bounds(num) )
					return 0;
			}
			else if (member == 4) {
				if (!i_value_in_bounds(num) )
					return 0;
			}			
			return counter;
		}
		if (member == 17) {
			rc = load_label(s, label, &len);
			if (rc != 0) {
				return -EINVAL;
			}
			counter = len;
			return counter;
		}
		return -EINVAL;
	}

	int mem,op;
	int rc,rc2;


	
	rc = next_member(s,&mem,&op);
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += rc;
		rc2 = load_value(s, mem, op);
		if (rc2 <= 0) {
			return rc2;
		}
		s += (rc2+1);
		rc = next_member(s,&mem,&op);
	}
	return 1;
}


/* ACCESS FUNCTION */
/*
   MAY_EXEC 1
   MAY_WRITE 2
   MAY_READ 4
   MAY_APPEND 8
   MAY_ACCESS 16
   MAY_OPEN 32
   MAY_CHDIR 64
*/
#define MAY_ANY         (MAY_READ | MAY_WRITE | MAY_APPEND | MAY_EXEC)
#define MAY_ANYREAD     (MAY_READ | MAY_EXEC)
#define MAY_ANYWRITE    (MAY_WRITE | MAY_APPEND)
#define MAY_READWRITE   (MAY_READ | MAY_WRITE)
#define MAY_NOT         0

#define MAY_READ_PTS (MAY_EXEC | MAY_READ | MAY_ACCESS | MAY_OPEN)
#define MAY_WRITE_PTS (MAY_WRITE | MAY_APPEND )


/* zakladna funkcia pristupova */
static int pts_access(struct subject_pts *sub,struct object_pts *obj,int request) {
	int may = 0;
	/* PTS READ */
	
	if (!( (sub->cr_s >= obj->c_o) || ((sub->crl_s >= obj->c_o) && contains_label_list(sub,crls_s,obj->l_o)) || (sub->cr_s==-1) || (obj->c_o ==-1)  ))
		goto write_test;
	if (!( (sub->ir_s <= obj->i_o) || ( (sub->irl_s <= obj->i_o) && contains_label_list(sub,irls_s,obj->l_o) ) || (sub->ir_s==-1) || (obj->i_o ==-1) ))
		goto write_test;
	if (!( (sub->u_s == obj->u_o) || (obj->c_o <= c_shar) || (obj->c_o == -1) ))
		goto write_test;
	if (!( (sub->u_s == obj->u_o) || (contains_user_id_list(sub,irus_s,obj->u_o)) || (sub->ir_s <= i_shar) || (sub->ir_s == -1) ))
		goto write_test;
	may = (may | MAY_READ_PTS);

	/* PTS WRITE */
	write_test:
	if (!( (sub->cw_s <= obj->c_o) || ( (sub->cwl_s <= obj->c_o) && (contains_label_list(sub,cwls_s,obj->l_o)) ) || (sub->cw_s==-1) || (obj->c_o ==-1) ))
			goto result;
	if (!( (sub->iw_s >= obj->i_o) || ( (sub->iwl_s >= obj->i_o) && (contains_label_list(sub,iwls_s,obj->l_o)) ) || (sub->iw_s==-1) || (obj->i_o ==-1) ))
			goto result;
	if (!( (sub->u_s == obj->u_o) || (obj->i_o <= i_shar) || (obj->i_o == -1) ))
			goto result;
	if (!( (sub->u_s == obj->u_o) || (contains_user_id_list(sub,cwus_s,obj->u_o)) || (sub->cw_s <= c_shar) || (sub->cw_s == -1) ))
			goto result;
	may = (may | MAY_WRITE_PTS);

	result:

	if ( (request & may) == request ) {
		return 0;
	}
	return -EACCES;
}

/* vypis cesty */
static void printDentryPath(struct dentry *dentry) {
	struct dentry *parent;
	parent = dentry->d_parent;
	while (parent != dentry) {
		printk(KERN_INFO "CESTA: %s", parent->d_iname);
		parent = parent->d_parent;
		dentry = dentry->d_parent;
	}
}

/* vypis suboroveho systemu */
static void printInodeType(struct inode *inode) {
	struct super_block *sbp;
	sbp = inode->i_sb;

	switch (sbp->s_magic) {
		case PIPEFS_MAGIC:
			printk(KERN_INFO "TYP INODU: PIPE");
			return;
		case DEVPTS_SUPER_MAGIC:
			printk(KERN_INFO "TYP INODU: DEVICE");
			return;
		case SOCKFS_MAGIC:
			printk(KERN_INFO "TYP INODU: SOCKET");
			return;
		case PROC_SUPER_MAGIC:
			printk(KERN_INFO "TYP INODU: PROCFS");
			return;
		case TMPFS_MAGIC:
			printk(KERN_INFO "TYP INODU: TMPFS");
			return;
		case EXT4_SUPER_MAGIC:
			printk(KERN_INFO "TYP INODU: EXT");
			return;
		default:
			printk(KERN_INFO "TYP INODU: OTHER");
			return;
	}
}




/* hook funkcie a pomocne funkcie zdielane v permissive aj ostrom mode */
int my_inode_alloc_security(struct inode *);
void my_inode_free_security(struct inode *);


int my_inode_init_security(struct inode *, struct inode *,char **, void **, size_t *);
int my_inode_getsecurity(const struct inode *, const char *, void **, bool);
int my_inode_setsecurity(struct inode *, const char *,const void *, size_t, int);
int my_inode_getxattr(struct dentry *, const char *);
int dentry_has_capability(struct dentry *, int );
int my_inode_removexattr(struct dentry *, const char *);
int my_inode_setxattr(struct dentry *, const char *,const void *, size_t, int);
void my_inode_post_setxattr(struct dentry *, const char *, const void *, size_t, int);
int my_inode_listsecurity(struct inode *, char *,size_t);
void my_d_instantiate(struct dentry *, struct inode *);
int my_getprocattr(struct task_struct *, char *, char **);
int my_setprocattr(struct task_struct *, char *, void *, size_t);
int my_cred_alloc_blank(struct cred *, gfp_t );
void my_cred_free(struct cred *);
int my_cred_prepare(struct cred *, const struct cred *,gfp_t);
void my_cred_transfer(struct cred *, const struct cred *);
inline void bprm_clear_caps(struct linux_binprm *);
int bprm_has_capability(struct linux_binprm *, bool *,int);
int my_bprm_set_creds(struct linux_binprm *);
void my_bprm_committed_creds(struct linux_binprm *);



int is_system_user(int);



#endif
