/* PERMISIVNE ZVOLENA POLITIKA, ZMENY XATTR POLITIKY A PROCESS KONTEXTOV NIE JE PERMISIVNA */

#define MODULE_NAME "pts2"
#define PERMISSIVE_MODE 1
#define PRINT_MODE 1

#include "pts.h"

/* povolenie pri vytvarani specialneho objektu */
static int my_inode_mknod2(struct inode *dir, struct dentry *dentry, int mode, dev_t dev) {
	int rc = 0,len;
	struct object_pts *ob = (struct object_pts *) dir->i_security;
	struct subject_pts *sub = (struct subject_pts *) current_security();

	if (capable(CAP_MAC_ADMIN))
		return 0;

	ob->u_o = dir->i_uid;
	sub->u_s = current_euid();

	rc = pts_access(sub,ob,MAY_READ_PTS);
	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI VYTVARANI SUBORU %s.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel adresara: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(ob,&len),current_euid(),dir->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}

	rc = pts_access(sub,ob,MAY_WRITE_PTS);
	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI VYTVARANI SUBORU %s.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel adresara: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(ob,&len),current_euid(),dir->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}

	return 0;
}


/* povolenie pri vytvarani standardneho suboru */
static int my_inode_create2(struct inode *dir, struct dentry *dentry, int mode) {
	int rc = 0,len;
	struct object_pts *ob = (struct object_pts *) dir->i_security;
	struct subject_pts *sub = (struct subject_pts *) current_security();

	if (capable(CAP_MAC_OVERRIDE))
		return 0;

	ob->u_o = dir->i_uid;
	sub->u_s = current_euid();

	rc = pts_access(sub,ob,MAY_READ_PTS);
	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI VYTVARANI SUBORU %s.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel adresara: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(ob,&len),current_euid(),dir->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}

	rc = pts_access(sub,ob,MAY_WRITE_PTS);
	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI VYTVARANI SUBORU %s.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel adresara: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(ob,&len),current_euid(),dir->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}

	return 0;
}


/* mazanie inode na adrese dentry */
static int my_inode_unlink2(struct inode *dir, struct dentry *dentry) {
	struct object_pts *unl_ob = (struct object_pts *) dentry->d_inode->i_security;
	struct object_pts *dir_ob = (struct object_pts *) dir->i_security;
	struct subject_pts *sub = (struct subject_pts *) current_security();
	int rc,len;

	if (capable(CAP_MAC_ADMIN))
		return 0;

	sub->u_s = current_euid();
	unl_ob->u_o = dentry->d_inode->i_uid;
	dir_ob->u_o = dir->i_uid;
	
	
	rc = pts_access(sub,unl_ob,MAY_WRITE_PTS);
	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI MAZANI SUBORU %s.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel suboru: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(unl_ob,&len),current_euid(),dentry->d_inode->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}
	rc = pts_access(sub,dir_ob,MAY_WRITE_PTS);

	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI MAZANI SUBORU %s, RODICOVSKY ADRESAR WRITE DENIED.",current->comm,dentry->d_iname);
			printk(KERN_INFO "atrs: %s   %s,majitel procesu: %d, majitel suboru: %d.",subject_pts_to_string(sub,&len),object_pts_to_string(unl_ob,&len),current_euid(),dentry->d_inode->i_uid);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}
	
	return 0;
}

/* premenovanie inodu */
static int my_inode_rename2(struct inode *old_inode,
			      struct dentry *old_dentry,
			      struct inode *new_inode,
			      struct dentry *new_dentry)
{
	int rc,len;	

	struct subject_pts *sub = (struct subject_pts *) current_security();
	struct object_pts *ob = (struct object_pts *) old_dentry->d_inode->i_security;
	
	sub->u_s = current_euid();	
	ob->u_o = old_dentry->d_inode->i_uid;

	if (capable(CAP_MAC_ADMIN))
		return 0;

	rc = pts_access(sub,ob,MAY_WRITE_PTS | MAY_READ_PTS);

	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "ZAKAZ: PREMENOVAVAM SUBOR %s s atrs: %s ,majitel: %d ",old_dentry->d_iname, object_pts_to_string((struct object_pts *) old_dentry->d_inode->i_security,&len), ob->u_o);
			printk(KERN_INFO "ZAKAZ: PREMENOVAVAJUCI PROCES: %s , atrs: %s ,majitel: %d", current->comm, subject_pts_to_string((struct subject_pts *) current_security(),&len), sub->u_s);
		}
		if (PERMISSIVE_MODE) {
			return 0;
		}
		return rc;
	}
	
	

	if ( (new_dentry != NULL) && (new_dentry->d_inode != NULL) && (new_dentry->d_inode->i_security != NULL) ) {
		ob = (struct object_pts *) new_dentry->d_inode->i_security;
		ob->u_o = new_dentry->d_inode->i_uid;

		rc = pts_access(sub,ob,MAY_WRITE_PTS);

		if (rc != 0) {
			if (PRINT_MODE) {
				printk(KERN_INFO "ZAKAZ: PREMENOVAVANY SUBOR %s s atrs: %s ,majitel: %d.",new_dentry->d_iname, object_pts_to_string((struct object_pts *) new_dentry->d_inode->i_security,&len), ob->u_o);	
				printk(KERN_INFO "PREMENOVAVAJUCI PROCES: %s , atrs: %s ,majitel: %d", current->comm, subject_pts_to_string((struct subject_pts *) current_security(),&len), sub->u_s);
			}
			if (PERMISSIVE_MODE) {
				return 0;
			}
			return rc;
		}
	}
	
	return 0;
}




/* kontrola pristupu k inode */
static int my_inode_permission2(struct inode *inode, int mask) {
	int rc,len;
	struct object_pts *ob = (struct object_pts *) inode->i_security;
	struct subject_pts *sub = (struct subject_pts *) current_security();

	if ( (ob == NULL) || (sub == NULL) )	
		return 0;
	if (capable(CAP_MAC_ADMIN)) {
		return 0;
	}

	ob->u_o = inode->i_uid;
	sub->u_s = current_euid();

	if (S_ISDIR(inode->i_mode)) {
		mask = ((~1) & mask);
	}

	rc = pts_access(sub,ob,mask);

	if (rc != 0) {
		if (PRINT_MODE) {
			printk(KERN_INFO "PRISTUP BY BOL ZAMIETNUTY PROCESU %s PRI INODE,atrs: %s   %s,majitel procesu: %d,majitel inodu:%d, operacia: %d.",current->comm,subject_pts_to_string(sub,&len),object_pts_to_string(ob,&len),current_euid(),inode->i_uid,mask);
			printInodeType(inode);
			printk(KERN_INFO "SB MAGIC: %ld, INODE NUMBER: %ld", inode->i_sb->s_magic,inode->i_ino);
			if (inode->i_sb->s_root != NULL)
				printDentryPath(inode->i_sb->s_root);
		}
		if (PERMISSIVE_MODE) {		
			return 0;
		}
	}	
	
	return rc;
}

/* kontrola nastavovania atributov inodu */
static int my_inode_setattr2(struct dentry *dentry, struct iattr *attr) {
	int l;
	struct subject_pts *sub = (struct subject_pts *) current_security();

	if (capable(CAP_MAC_ADMIN))
		return 0;
	
	if ((attr->ia_valid & ATTR_UID) && (dentry->d_inode->i_uid != attr->ia_uid)) {
		if (sub->chown) {
			goto nextCheck;
		}
		if (is_system_user(dentry->d_inode->i_uid) && is_system_user(attr->ia_uid)) {
			goto nextCheck;
		}
		if (PRINT_MODE) {
			printk(KERN_INFO "CHOWN PROCES: %s , atrs:%s..",current->comm, subject_pts_to_string((struct subject_pts *) current_security(),&l) );		
			printk(KERN_INFO "CHOWN OLD UID: %d, NEW UID: %d, atrs: %s",dentry->d_inode->i_uid, attr->ia_uid, object_pts_to_string((struct object_pts *) dentry->d_inode->i_security, &l));
			printk(KERN_INFO "CHOWN FILE: %s.",dentry->d_iname);			
			printInodeType(dentry->d_inode);
			printk(KERN_INFO "CHOWN SB MAGIC: %ld, INODE NUMBER: %ld", dentry->d_inode->i_sb->s_magic,dentry->d_inode->i_ino);
			printDentryPath(dentry);
		}
		if (PERMISSIVE_MODE) {
			goto nextCheck;
		}
		return -EPERM;
		
	}
	nextCheck:
		return 0;
}


/* zmena uid procesu */
static int my_task_setuid2(uid_t id0, uid_t id1, uid_t id2, int flags) {
	int l;
	struct subject_pts *sub = (struct subject_pts *) current_security();
	
	if ((flags == LSM_SETID_RE) || (flags == LSM_SETID_RES)) {
		if (id1 != current_euid()) {
			if (sub->setuid) {
				return 0;
			}
			if (is_system_user(id1) && is_system_user(current_euid())) {
				return 0;
			}
			if (PRINT_MODE) {
				printk(KERN_INFO "SETUID ZAMIETNUTE, PROCES: %s , atrs:%s.",current->comm, subject_pts_to_string((struct subject_pts *) current_security(),&l) );
				printk(KERN_INFO "SETUID VALUES old:%d new:%d", id1, current_euid());
			}
			if (PERMISSIVE_MODE)
				return 0;
			return -EPERM;
		}
	}
	if (flags == LSM_SETID_ID) {
		if (id0 != current_euid()) {
			if (sub->setuid) {
				return 0;
			}
			if (is_system_user(id0) && is_system_user(current_euid())) {
				return 0;
			}
			
			if (PRINT_MODE) {
				printk(KERN_INFO "SETUID ZAMIETNUTE, PROCES: %s , atrs:%s.",current->comm, subject_pts_to_string((struct subject_pts *) current_security(),&l) );
				printk(KERN_INFO "SETUID VALUES old:%d new:%d", id1, current_euid());
			}
			if (PERMISSIVE_MODE)
				return 0;
			return -EPERM;
		}
	}
	return 0;
}



struct security_operations my_ops2 = {
  .name = MODULE_NAME,

  .bprm_set_creds = my_bprm_set_creds,
  .inode_alloc_security = my_inode_alloc_security,
  .inode_free_security =  my_inode_free_security,
  .inode_init_security =  my_inode_init_security,
  .inode_create = my_inode_create2,
  .inode_mknod = my_inode_mknod2,
  .inode_unlink = my_inode_unlink2,
  .inode_rename = my_inode_rename2,  
  .inode_setattr = my_inode_setattr2,	
  .inode_permission = my_inode_permission2,
  .inode_listsecurity = my_inode_listsecurity,
  .inode_getsecurity =  my_inode_getsecurity,
  .inode_setsecurity =  my_inode_setsecurity,
  .inode_getxattr =  my_inode_getxattr,
  .inode_setxattr =  my_inode_setxattr,
  .inode_removexattr = my_inode_removexattr,
  .inode_post_setxattr = my_inode_post_setxattr,

  .getprocattr = my_getprocattr,
  .setprocattr = my_setprocattr,
  .d_instantiate = my_d_instantiate,

  .cred_alloc_blank =	my_cred_alloc_blank,
  .cred_free =			my_cred_free,
  .cred_prepare =		my_cred_prepare,
  .cred_transfer =		my_cred_transfer,
	
  .task_setuid = my_task_setuid2,
	
};

static __init int my_init2(void) {
	struct cred *cred;
	struct subject_pts *sub;
	if (!security_module_enable(&my_ops2))
		return 0;
	printk(KERN_INFO "PTS: spustanie politiky.\n");
	sub = new_subject_pts(GFP_KERNEL);
	if (sub == NULL)
		return -ENOMEM;
	cred = (struct cred *) current->cred;
	cred->security = sub;
	cap_lower(cred->cap_permitted, CAP_MAC_ADMIN);
    cap_lower(cred->cap_effective, CAP_MAC_ADMIN);
	if (register_security(&my_ops2))
		panic("PTS: nepodarila sa registracia.\n");
	return 0;
}

security_initcall(my_init2);

