#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <security/pam_modules.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <pwd.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/prctl.h>




const char *service_name;
const char *user;
const struct pam_conv *pam_conversation;
pam_handle_t **pamh;

int misc_conv(num_msg, msgm, response, appdata_ptr);

static struct pam_conv conv = {
	misc_conv,
	NULL
};



/* autentifikacia bezpecnostneho administratora */
int auth() {
  pam_handle_t *pamh=NULL;
  int retval;
  struct pam_response *pp=NULL;

  retval = pam_start("admin", "securityadministrator" , &conv, &pamh);
  retval = pam_authenticate(pamh, 0);
  pam_end(pamh,retval);
  if (retval==PAM_SUCCESS) {
  }
  else {
    printf("Autentifikacia zlyhala.\n",retval);
	exit(-1);
  }
  

}


int main(int argc, char *argv[]) {
	int count,cmd_start,ret,i,orig_uid,retval;
    char **cmd;

	orig_uid = getuid();
	setuid(0);
	printf("Musite sa autentifikovat ako bezpecnostny administrator.\n");
	auth();
	setuid(orig_uid);
	
	
	
	
	cmd_start = 1;
	count = argc-cmd_start;
    cmd = (char **) malloc(sizeof(char *)*(count+1));
    cmd[count] = (char *) 0;


    for (i = 0; i<count; i++) {
        cmd[i] = argv[cmd_start+i];
    }


    ret = execvp(argv[cmd_start], cmd);
	if (ret == -1)
		printf("Nepodarilo sa spustenie pozadovanych prikazov.\n");
	printf( "%s\n", strerror(errno) );
    return ret;
}