#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <security/pam_modules.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <pwd.h>
#include <sys/types.h>
#include <attr/xattr.h>
#include <unistd.h>
#include <sys/stat.h>
#include <ftw.h>

#define PTS_LABELLEN 23
#define EINVAL 22

#define true 1



int valid_char(char ch) {
	if ( ((ch >= 'a') && (ch <= 'z')) || ((ch >= 'A') && (ch <= 'Z')) || ((ch >= '0') && (ch <= '9')) )
		return 1;
	return 0;
}

int is_digit(char ch) {
	if ( (ch >= '0') && (ch <= '9') )
		return 1;
	return 0;
}

int valid_subject_pts_string(char *s) {
	int next_member(char *s,int *len) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if ( (strncmp("cr_s=",s,5) == 0) || (strncmp("cw_s=",s,5) == 0) ||
		    (strncmp("ir_s=",s,5) == 0) || (strncmp("iw_s=",s,5) == 0) ||
		    (strncmp("cn_s=",s,5) == 0) || (strncmp("in_s=",s,5) == 0) ) {
			*len =  5;
			return 1; // int
		}
		if (strncmp("heritable=",s,10) == 0) {
			*len = 10;
			return 1; // int
		}
		if ( (strncmp("crl_s=",s,6) == 0) || (strncmp("cwl_s=",s,6) == 0) ||
		    (strncmp("irl_s=",s,6) == 0) || (strncmp("iwl_s=",s,6) == 0) ) {
			*len =  6;
			return 1; //int
		}
		if ( strncmp("ln_s=",s,5) == 0) {
			*len =  5;
			return 2; // PTS_LABEL
		}
		if ( (strncmp("crls_s=",s,7) == 0)  || (strncmp("cwls_s=",s,7) == 0)  ||
		    (strncmp("irls_s=",s,7) == 0) || (strncmp("iwls_s=",s,7) == 0)  ) {
			*len = 7;
			return 3; // PTS_LABEL LIST
		}

		if ( (strncmp("crls_s+=",s,8) == 0) || (strncmp("crls_s-=",s,8) == 0) ||
		     (strncmp("cwls_s+=",s,8) == 0) || (strncmp("cwls_s-=",s,8) == 0) ||
		     (strncmp("irls_s+=",s,8) == 0) || (strncmp("irls_s-=",s,8) == 0) ||
		     (strncmp("iwls_s+=",s,8) == 0) || (strncmp("iwls_s-=",s,8) == 0) ) {
			*len = 8;
			return 3; // PTS_LABEL LIST
		}
		if  ( (strncmp("irus_s=",s,7) == 0) || (strncmp("cwus_s=",s,7) == 0)  ) {
			*len = 7;
			return 4; // UID LIST
		}
		if  ( (strncmp("irus_s+=",s,8) == 0) || (strncmp("irus_s-=",s,8) == 0) ||
		    (strncmp("cwus_s+=",s,8) == 0) || (strncmp("cwus_s-=",s,8) == 0) ) {
			*len = 8;
			return 4; // UID LIST
		}

		return -EINVAL;
	}

	int check_member(char *s, int m) {
		int counter = 0,i = 0;
		if (m==1) {
			if ( (*s == '+') || (*s == '-') ) {
				s++;
				counter++;
			}
			while ( (*s != ';') ) {
				if ( (!is_digit(*s)) || (*s == '\0') || (counter > 10) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m==2) {
			while ( (*s != ';') ) {
				if ( (!valid_char(*s)) || (*s == '\0') || (counter > PTS_LABELLEN) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m==3) {
			while (1) {
				i = 0;
				while ( (valid_char(*s)) && (i < PTS_LABELLEN) ){
					i++;
					s++;
					counter++;
				}
				if (*s == ',') {
					s++;
					counter++;
					continue;
				}
				else if (*s == ';')
					return counter;
				else
					return -EINVAL;
			}
		}
		else if (m==4) {
			while (1) {
				i = 0;
				if ( (*s == '+') || (*s=='-') ) {
					s++;
					counter++;
					i++;
				}
				while ( (is_digit(*s)) && (i <= 10) ){
					i++;
					s++;
					counter++;
				}
				if (*s == ',') {
					s++;
					counter++;
					continue;
				}
				else if (*s == ';')
					return counter;
				else
					return -EINVAL;
			}
		}
		return counter;
	}

	int rc,rc2,len = 0;

	rc = next_member(s,&len);
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += len;
		rc2 = check_member(s, rc);
		if (rc2 < 0)
			return rc2;
		s += (rc2+1);
		rc = next_member(s,&len);
	}
	return 0;
}

int blankChar(int c) {
    if ( (c==' ') || (c== '\t'))
        return 1;
    return 0;
}

char *filterProfileFile(FILE *f) {

    int counter = 0,c,skippingLine = 0, readingLineStart = 1;
    char *result;

    while ((c = fgetc(f)) != EOF) {
        if (c == '\n') {
            readingLineStart = 1;
            skippingLine = 0;
        }
        else if (readingLineStart) {
            if (!blankChar(c)) {
                if (c=='#') {
                    skippingLine = 1;
                }
                else {
                    counter++;
                }
                readingLineStart = 0;
            }
        }
        else if (skippingLine) {
        }
        else if (!blankChar(c)) {
            counter++;
        }
    }

    result = (char *) malloc(sizeof(char)*(counter+1));
    result[counter] = '\0';
    fseek(f,0,SEEK_SET);

    counter = 0;
    skippingLine = 0;
    readingLineStart = 1;

    while ((c = fgetc(f)) != EOF) {
        if (c == '\n') {
            readingLineStart = 1;
            skippingLine = 0;
        }
        else if (readingLineStart) {
            if (!blankChar(c)) {
                if (c=='#') {
                    skippingLine = 1;
                }
                else {
                    result[counter] = c;
                    counter++;
                }
                readingLineStart = 0;
            }
        }
        else if (skippingLine) {
        }
        else if (!blankChar(c)) {
            result[counter] = c;
            counter++;
        }
    }

    return result;
}




const char *service_name;
const char *user;
const struct pam_conv *pam_conversation;
pam_handle_t **pamh;

int misc_conv(num_msg, msgm, response, appdata_ptr);

static struct pam_conv conv = {
	misc_conv,
	NULL
};


int auth() {
  pam_handle_t *pamh=NULL;
  int retval;
  struct pam_response *pp=NULL;

  retval = pam_start("adminBinmng", "securityadministrator" , &conv, &pamh);
  retval = pam_authenticate(pamh, 0);
  pam_end(pamh,retval);
  if (retval==PAM_SUCCESS) {
  }
  else {
    printf("Autentifikacia zlyhala.\n",retval);
	exit(-1);
  }
  

}





int main(int argc, char *argv[]) {
	int ret,len,uid;
	char *buf, *safetyAttrs;
	struct stat st;
	FILE *f;
	//int setxattr (const char *path, const char *name,const void *value, size_t size, int flags);
	int orig_uid = getuid();

	if (argc < 2) {
        printf("Nespravne argumenty, pozadovany jeden z tvarov: \"-g subor\" na prezeranie binattr, \"-s bezpecnostneAtributy binarka\" pri nastavovani alebo \"-d subor\" pri mazani.\n");
        exit(-1);
    }

	if (strcmp("-g",argv[1]) == 0 ) {
		if (argc != 3) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-g subor\" na prezeranie xattr.\n");
		    exit(-1);
		}
		len =  getxattr (argv[2], "security.BIN_PTS\0",NULL,0);
		if (len == -1) {
			printf("Chyba citania rozsireneho atributu. Atribut pravdepodobne nie je nastaveny.\n");
		    exit(-1);
		}	
		buf = (char *) malloc(sizeof(char)*(len+1));
		if (buf == 0) {
			printf("Chyba citania rozsireneho atributu.\n");
		    exit(-1);
		}
		buf[len] = '\0';
		ret = getxattr(argv[2], "security.BIN_PTS\0",buf,len);
		if (ret == -1) {
			printf("Chyba citania rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);
		}
		printf("%s\n",buf);
		return 0;
	}
	else if (strcmp("-s",argv[1]) == 0) {
		if (argc != 4) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-s bezpecnostneAtributy binarka\" pri nastavovani bezpecnostneho atributu binarky.\n");
		    exit(-1);
		}
		setuid(0);
		auth();
		printf("Musite sa autentifikovat ako bezpecnostny administrator.\n");
		setuid(orig_uid);

		if (valid_subject_pts_string(argv[2])!= 0) {
			printf("Nespravna hodnota nastavovaneho bezpecnostneho atributu binarky.\n");
			exit(-1);
		}
		ret = setxattr(argv[3], "security.BIN_PTS\0",argv[2], strlen(argv[2]), 0);
		if (ret == -1) {
			printf("Chyba zapisu rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);			
		}
		return 0;
	}
	else if (strcmp("-d",argv[1]) == 0) {
		if (argc != 3) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-d binarka\" na mazanie binattr.\n");
		    exit(-1);
		}
		setuid(0);
		auth();
		printf("Musite sa autentifikovat ako bezpecnostny administrator.\n");
		setuid(orig_uid);
	
		ret = removexattr(argv[2], "security.BIN_PTS\0");
		if (ret == -1) {
			printf("Chyba mazania rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);			
		}
		return 0;
	}
	else if (strcmp("-sp",argv[1]) == 0) {
		if (argc != 4) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-sp profil binarka\" pri rekurzivnom nastavovani bezpecnostneho atributu.\n");
		    exit(-1);
		}		

		setuid(0);
		auth();
		printf("Musite sa autentifikovat ako bezpecnostny administrator.\n");
		setuid(orig_uid);

		f = fopen(argv[2],"r");
        if (f == NULL) {
            printf("Nepodarilo sa otvorit subor s bezpecnostnym profilom.\n");
            exit(-1);
        }
        safetyAttrs = filterProfileFile(f);
        fclose(f);
        if (valid_subject_pts_string(safetyAttrs)!= 0) {
			printf("Nespravna hodnota nastavovaneho bezpecnostneho atributu binarky.\n");
			exit(-1);
		}
		ret = setxattr(argv[3], "security.BIN_PTS\0",safetyAttrs, strlen(safetyAttrs), 0);
		if (ret == -1) {
			printf("Chyba zapisu rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);			
		}
		return 0;
	}	
	printf("Nespravne argumenty, pozadovany jeden z tvarov: \"-g subor\" na prezeranie binattr, \"-s bezpecnostneAtributy binarka\" pri nastavovani alebo \"-d subor\" pri mazani.\n");
	exit(-1);
	
}



