#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <security/pam_modules.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <pwd.h>
#include <sys/types.h>
#include <attr/xattr.h>
#include <unistd.h>
#include <sys/stat.h>

int orig_uid;

const char *service_name;
const char *user;
const struct pam_conv *pam_conversation;
pam_handle_t **pamh;

int misc_conv(num_msg, msgm, response, appdata_ptr);

static struct pam_conv conv = {
	misc_conv,
	NULL
};


int auth(int uid_auth) {
  pam_handle_t *pamh=NULL;
  int retval;
  struct pam_response *pp=NULL;
  struct passwd *pw = getpwuid(uid_auth);

  if (pw == NULL) {
	  printf("Nenajdeny login!\n");
	  exit(-1);
  }


  retval = pam_start("pswd", pw->pw_name , &conv, &pamh);
  retval = pam_authenticate(pamh, 0);
  pam_end(pamh,retval);

  if (retval==PAM_SUCCESS) {
	  return 0;
  }
  else {
    printf("Autentifikacia zlyhala.\n",retval);
	exit(-1);
  }
  

}




int main(int argc, char *argv[]) {
	int count,cmd_start,ret,i;    
    char **cmd;
	orig_uid = getuid();
	
	if ( (argc != 1) && (argc != 2) ) {
		printf("Nespravny pocet argumentov: spravne pouzitie je \"pswd\" ak chcete menit vlastne heslo alebo \"pswd login\" ak ste bezpecnostny administrator a menite heslo ineho pouzivatela.");
		exit(-1);
	}
	if (argc == 1) {
		seteuid(0);
		auth(orig_uid);
		ret = execl("/usr/bin/passwd","passwd",NULL);
		if (ret == -1)
			printf( "%s\n", strerror(errno) );
		return ret;
		
		
	}
	else {
		setuid(0);
		printf("Musite sa autentifikovat ako bezpecnostny administrator.\n");
		auth(999);


		ret = execl("/usr/bin/passwd","passwd",argv[1],NULL);
		if (ret == -1)
			printf( "%s\n", strerror(errno) );
		
		return ret;
		
	}

	
	


	

}
