#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <security/pam_modules.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <pwd.h>
#include <sys/types.h>
#include <attr/xattr.h>
#include <unistd.h>
#include <sys/stat.h>
#include <ftw.h>

#define PTS_LABELLEN 23
#define EINVAL 22


char *set_value = NULL;
int orig_uid;

int valid_char(char ch) {
	if ( ((ch >= 'a') && (ch <= 'z')) || ((ch >= 'A') && (ch <= 'Z')) || ((ch >= '0') && (ch <= '9')) )
		return 1;
	return 0;
}

int is_digit(char ch) {
	if ( (ch >= '0') && (ch <= '9') )
		return 1;
	return 0;
}

/* validacia textovej reprezentacie objektu */
static int valid_object_pts_string(char *s) {
	int next_member(char *s) {
		if (*s == '\0') {
			return 0; // end of string
		}
		if ( (strncmp("c_o=",s,4) == 0) || (strncmp("i_o=",s,4) == 0) ) {
			return 1; // int
		}
		if ( strncmp("u_o=",s,4) == 0) {
			return 2; // unsigned int
		}
		if ( strncmp("l_o=",s,4) == 0) {
			return 3; // PTS_LABEL
		}
		return -EINVAL;

	}

	// vracia pocet precitanych spravnych symbolov,alebo zapornu chybu
	int check_member(char *s, int m) {
		int counter = 0,i;
		if (m == 1) {
			if ( (*s == '+') || (*s == '-') ) {
				s++;
				counter++;
			}
		}
		if ( (m == 1) || (m == 2) ) {
			i = 0;
			while ( (*s != ';') ) {
				if ( (!is_digit(*s)) || (*s == '\0') || (counter > 10) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		else if (m == 3) {
			i = 0;
			while ( (*s != ';') ) {
				if ( (!valid_char(*s)) || (*s == '\0') || (counter > PTS_LABELLEN) )
					return -EINVAL;
				s++;
				counter++;
			}
		}
		return counter;
	}

	int rc,rc2;

	rc = next_member(s);
	while (rc != 0) {
		if (rc < 0) {
			return rc;
		}
		s += 4;
		rc2 = check_member(s, rc);
		if (rc2 < 0)
			return rc2;
		s += (rc2+1);
		rc = next_member(s);
	}
	return 0;
}



const char *service_name;
const char *user;
const struct pam_conv *pam_conversation;
pam_handle_t **pamh;

int misc_conv(num_msg, msgm, response, appdata_ptr);

static struct pam_conv conv = {
	misc_conv,
	NULL
};


/* autentifikacia */
int auth() {
	pam_handle_t *pamh=NULL;
	int retval;
	struct pam_response *pp=NULL;
	struct passwd *pw;

	
	if ((pw = getpwuid(orig_uid)) == NULL) {
		(void) fprintf(stderr, "Neviem zistit pouzivatelske meno: %s\n",
			strerror(errno));
		exit(1);
	}

	retval = pam_start("xattrmng", pw->pw_name , &conv, &pamh);
	retval = pam_authenticate(pamh, 0);
	pam_end(pamh,retval);
	if (retval==PAM_SUCCESS) {
	}
	else {
		printf("Autentifikacia zlyhala.\n",retval);
		exit(-1);
	}


}

/* pomocne funkcie pri rekurzivnom prehladavani suboroveho systemu */
int rem_xattr(const char *name, const struct stat *status, int type);
int set_xattr(const char *name, const struct stat *status, int type);


int main(int argc, char *argv[]) {
	int ret,len,uid;
	char *buf;	
	struct stat st;
	set_value = argv[2];
	orig_uid = getuid();
	//int setxattr (const char *path, const char *name,const void *value, size_t size, int flags);

	if (argc < 2) {
        printf("Nespravne argumenty, pozadovany jeden z tvarov: \"-g subor\" na prezeranie xattr, \"-s bezpecnostneAtributy subor\" pri nastavovani alebo \"-d subor\" pri mazani.\n");
        exit(-1);
    }

	if (strcmp("-g",argv[1]) == 0 ) {
		if (argc != 3) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-g subor\" na prezeranie xattr.\n");
		    exit(-1);
		}
		len =  getxattr (argv[2], "security.PTS\0",NULL,0);
		if (len == -1) {
			printf("Chyba citania rozsireneho atributu.\n");
		    exit(-1);
		}	
		buf = (char *) malloc(sizeof(char)*(len+1));
		if (buf == 0) {
			printf("Chyba citania rozsireneho atributu.\n");
		    exit(-1);
		}
		buf[len] = '\0';
		ret = getxattr(argv[2], "security.PTS\0",buf,len);
		if (ret == -1) {
			printf("Chyba citania rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);
		}
		printf("%s\n",buf);
		return 0;
	}
	else if (strcmp("-s",argv[1]) == 0) {
		if (argc != 4) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-s bezpecnostneAtributy subor\" pri nastavovani bezpecnostneho atributu.\n");
		    exit(-1);
		}
		
		ret = stat(argv[3], &st);
		if (ret == -1) {
			printf("Chyba zistovania vlastnika:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);
		}
		
		uid = st.st_uid;
		if (uid != geteuid()) {
			printf("Musite byt vlastnikom meneneho objektu.\n");
			exit(-1);
		}
		
		auth();
		if (valid_object_pts_string(argv[2])!= 0) {
			printf("Nespravna hodnota nastavovaneho bezpecnostneho atributu.\n");
			exit(-1);
		}
		ret = setxattr(argv[3], "security.PTS\0",argv[2], strlen(argv[2]), 0);
		if (ret == -1) {
			printf("Chyba zapisu rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);			
		}
		return 0;
	}
	else if (strcmp("-d",argv[1]) == 0) {
		if (argc != 3) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-d subor\" na mazanie xattr.\n");
		    exit(-1);
		}
		
		ret = stat(argv[2], &st);
		if (ret == -1) {
			printf("Chyba zistovania vlastnika:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);
		}
		
		uid = st.st_uid;
		if (uid != geteuid()) {
			printf("Musite byt vlastnikom meneneho objektu.\n");
			exit(-1);
		}
		
		auth();		
		ret = removexattr(argv[2], "security.PTS\0");
		if (ret == -1) {
			printf("Chyba mazania rozsireneho atributu:");
			printf( " %s\n", strerror(errno) );
		    exit(-1);			
		}
		return 0;
	}
	else if (strcmp("-sr",argv[1]) == 0) {
		if (argc != 4) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-sr bezpecnostneAtributy subor/adresar\" pri rekurzivnom nastavovani bezpecnostneho atributu.\n");
		    exit(-1);
		}
	
		
		auth();
		if (valid_object_pts_string(argv[2])!= 0) {
			printf("Nespravna hodnota nastavovaneho bezpecnostneho atributu.\n");
			exit(-1);
		}
		ftw(argv[3], set_xattr, 1);
		return 0;
	}
	else if (strcmp("-dr",argv[1]) == 0) {
		if (argc != 3) {
		    printf("Nespravne argumenty, pozadovany tvar: \"-dr subor\" na rekurzivne mazanie xattr.\n");
		    exit(-1);
		}

		
		auth();		
		ftw(argv[2], rem_xattr, 1);
		return 0;
	}			
	printf("Nespravne argumenty, pozadovany jeden z tvarov: \"-g subor\" na prezeranie xattr, \"-s bezpecnostneAtributy subor\" pri nastavovani alebo \"-d subor\" pri mazani.\n");
	exit(-1);
	
}

int rem_xattr(const char *name, const struct stat *status, int type) {
	int ret;
	if ( (type == FTW_F) || (type == FTW_D && strcmp(".", name) != 0) ) {
		ret = removexattr(name, "security.PTS\0");
		if (ret == -1) {
			printf("Chyba mazania rozsireneho atributu suboru: %s .",name);
			printf( "Popis chyby: %s\n", strerror(errno) );		    
		}
	}
	return 0;	
}

int set_xattr(const char *name, const struct stat *status, int type) {
	int ret;
	if ( (type == FTW_F) || (type == FTW_D && strcmp(".", name) != 0) ) {
		ret = setxattr(name, "security.PTS\0",set_value, strlen(set_value), 0);
		if (ret == -1) {
			printf("Chyba zapisu rozsireneho atributu suboru: %s .",name);
			printf( "Popis chyby: %s\n", strerror(errno) );
		}
	}
	return 0;
}

