# Diplomová práca

## Nástroj PINTOOL

V zložke pintool sa nachádza naša implementácia. Kompiláciu spustíme príkazom:
`make Train Clasify Decode TraceSeq all TraceAnd`

Na spustenie kompilácie musí byť nastavená $PIN_ROOT na adresu nástroj PIN.

### Nástroj na sledovanie 
Spúšťa sa nasledovne:
`pin -t ./pintool/obj-intel64/DiploTool ARGUMENTY -- program ...`

Ako argument je dôležitý argument *-files=x*, ktorý načíta zoznám adries ku
knižiciam a súborom, ktoré ma program sledovať (používa sa na to aby nesledoval
všetky knižnice alebo iba nami zvolené).

### Nástroj na trénovanie
pintool/Train slúži na trénovanie. Podporuje nasledujúce flagy:
```
  -changeSize (Change size to...) type: int32 default: 0
  -clasifier () type: string default: "ClusterClasifierNone"
  -clustering (ReadClustering from file.) type: string default: ""
  -outputDir (Output directory.) type: string default: "./out"
```
navyše ako argument berie zoznam behov z ktorých sa má trénovať.

### Nástroj na vyhodnotenie behu
pintool/Clasify slúži na vyhodnotenie anomálnosti behu. Ako prvý argument je
cesta k modelu a zvyšné sú cesty k testovaným behom. Navyše podporuje nasledujúci
flag:
`    -changeSize (Change size to...) type: int32 default: 0`

### Ostatné nástroje
Ostatné nástroje pintool/{TraceSeq, TraceAnd, Decode} sme používali pri vývoji
a vyhodnocovaní kvalít modelov a na debugovacie potreby. Odporúčame používateľovi
v prípade záujmu analyzovať zdrojové súbory.

## Príklad použitia
Ak su dáta z jednotlivých behov uložené v zložkách train, test, evil. Tak môžeme
použiť nasledujúce príkazy na trénovanie a testovania.

```
mkdir out
mkdir outBinary
pintool/Train -outputDir=./out ./train/*
parallel "pintool/Train --clasifier=ClusterClasifierSeqBinary --outputDir=./outBinary{1} --clustering ./out/clusters.{} ./train/*"  ::: {00001..00049}
pintool/Clasify ./outBinary/MODEL ./evil/*
pintool/Clasify ./outBinary/MODEL ./test/*
```


## PoC Linksys

Obsahuje zdrojové súbory nášho PoC pre Linsys a pomocné skripty na jeho testovanie.

## Kontakt
V prípade potreby ma kontaktujte na jozef.brandys@gmail.com