#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>

#include "linksys_libs.c"

FILE *conn_fp;

int
Start_EPI(char *value) 
{
	char cmd[254];

	if(!strcmp(value, "1")) 
	{
		char *ant = websGetVar(wp, "wl_ant", NULL);
		char *rate = websGetVar(wp, "wl_rate", NULL);
		char *ttcp_num = websGetVar(wp, "ttcp_num", "3000");
		char *ttcp_ip = websGetVar(wp, "ttcp_ip", NULL);
		char *ttcp_size = websGetVar(wp, "ttcp_size", "1472");


		if(ant) {
			sprintf(cmd, "wl antdiv %s", ant);				
			mysystem(cmd);
			sprintf(cmd, "wl txant %s", ant);				
			mysystem(cmd);
		}
	
		if(rate) {
			sprintf(cmd, "wl rate %s", rate);				
			mysystem(cmd);
		}

		if(ttcp_ip) {
			sprintf(cmd, "epi_ttcp -tsufm -l %s -n %s %s &", ttcp_size, ttcp_num, ttcp_ip);				
			mysystem(cmd);
		}
	}
	
	return 0;
}

int
apply_cgi(FILE *wp, char *urlPrefix, char *webDir, int arg, 
	  char *url, char *path, char *query) {
	char *value;
	char *submit_button;
	int ret_code;
	ret_code = -1;

  /********************/
  value = websGetVar(wp, "change_action", "");

  /********************/
	if (!query)
		goto footer;

	value = websGetVar(wp, "StartEPI", NULL);
	printf("\nBarry StartEPI,value=%s\n",value);
	if(value){
		Start_EPI(value);
		goto footer;
	}

	value = websGetVar(wp, "action", "");
	if (value) {
		doSomeStuff(value);
		goto footer;
	}


	value = websGetVar(wp, "actionSpecialCGI", "");
	if (value) {
		doSomeStuffCGI(value);
		goto footer;
	}

	printf("Invalid action %s<br>", value);
footer:

	return 1;
}

static void do_apply_cgi(char *url, FILE *stream){
	char *path, *query;

  query=url;
  path = strsep(&query, "?") ? : url;
	init_cgi(query);

	if(!query)
		return;	
	apply_cgi(stream, NULL, NULL, 0, url, path, query);
	init_cgi(NULL);
}

struct mime_handler {
	const char *pattern;
	const char *mime_type;
	const char *extra_header;
	void (*input)(char *path, FILE *stream, int len, char *boundary);
	void (*output)(char *path, FILE *stream);
	void (*auth)(char *userid, char *passwd, char *realm);
};

struct mime_handler mime_handlers[] = {
	{ "**.css", "text/css", NULL, NULL, do_file, do_auth },
	{ "**.js", "text/javascript", NULL, NULL, do_file, do_auth },
	{ "apply.cgi*", "text/html", no_cache, NULL, do_apply_cgi, do_auth },
	{ "tmUnblock.cgi*", "text/html", no_cache, NULL, do_apply_cgi, NULL },
	{ "hndUnblock.cgi*", "text/html", no_cache, NULL, do_apply_cgi, NULL },
	{ "tmBlock.cgi**", "text/html", no_cache, NULL, do_apply_cgi, NULL },
	{ "hndBlock.cgi**", "text/html", no_cache, NULL, do_apply_cgi, NULL },
	{ NULL, NULL, NULL, NULL, NULL, NULL }
};

static void
handle_request(void) {
	char line[10000], *cur;
	char *method, *path, *protocol, *authorization, *boundary;
	char *cp;
	char *file;
	int len;
	struct mime_handler *handler;
	int cl = 0;


	/* Initialize the request variables. */
	authorization = boundary = NULL;
	//bzero( line, sizeof (line) );
	memset(line, '\0', sizeof(line));

	/* Parse the first line of the request. */
	if ( wfgets( line, sizeof(line), conn_fp ) == (char *)0 ) {	
		send_error( 400, "Bad Request", (char*) 0, "No request found." );
		return;
	}

	if ( strncasecmp(line, "GET", 3) && strncasecmp(line, "POST", 4)) {
		send_error( 501, "Not Implemented", (char*) 0, "That method is not implemented." );
		return;
	}

	method = path = line;
	strsep(&path, " ");
	if (!path) {
		send_error( 400, "Bad Request", (char*) 0, "Can't parse request." );
		return;
	}
	while (*path == ' ') path++;

	protocol = path;
	strsep(&protocol, " ");
  if (!protocol) {
		send_error( 400, "Bad Request", (char*) 0, "Can't parse request." );
		return;
	}	
	while (*protocol == ' ') protocol++;
    	
  cp = protocol;
  strsep(&cp, " ");
  cur = protocol + strlen(protocol) + 1;
    
	/* Parse the rest of the request headers. */
	while ( wfgets( cur, line + sizeof(line) - cur, conn_fp ) != 0 ) {
		if ( strcmp( cur, "\n" ) == 0 || strcmp( cur, "\r\n" ) == 0 ) {
			break;
		} else if ( strncasecmp( cur, "Authorization:", 14 ) == 0 ){
			cp = &cur[14];
			cp += strspn( cp, " \t" );
			authorization = cp;
			cur = cp + strlen(cp) + 1;
		}	else if (strncasecmp( cur, "Content-Length:", 15 ) == 0) {
			cp = &cur[15];
			cp += strspn( cp, " \t" );
			cl = strtoul( cp, NULL, 0 );
		}
	}
	
  if ( path[0] != '/' ) {
		send_error( 400, "Bad Request", (char*) 0, "Bad filename." );
		return;
  }
  file = &(path[1]);
  len = strlen( file );
  if ( file[0] == '/' || strcmp( file, ".." ) == 0 || strncmp( file, "../", 3 ) == 0 || strstr( file, "/../" ) != (char*) 0 || strcmp( &(file[len-3]), "/.." ) == 0 ) {
		send_error( 400, "Bad Request", (char*) 0, "Illegal filename." );
		return;
  }

  if (!auth_check(auth_realm, authorization)) {
    send_error( 401, "Unauthorized", NULL, "Authorization required." );
    return;
  }

  for (handler = &mime_handlers[0]; handler->pattern; handler++) {
    if (match(handler->pattern, file)) {
	    if (handler->auth) {
		    handler->auth(auth_userid, auth_passwd, auth_realm); //r
		    if (!auth_check(auth_realm, authorization)) {
	        send_error( 401, "Unauthorized", NULL, "Authorization required." );
			    return;
		    }
	    }
	    send_headers( 200, "Ok", handler->extra_header, handler->mime_type );
	    if (handler->output) {	
		    handler->output(file, conn_fp);
	    }
	    break;
    }
  }

  if (!handler->pattern) 
    send_error( 404, "Not Found", (char*) 0, "File not found." );
}

int main(int argc, char** argv) {
	conn_fp = stdin;
	handle_request();
}