// Copyright 2017 <Jozef Brandys>
#include <gflags/gflags.h>
#include <fstream>
#include <vector>
#include <memory>
#include <iostream>
#include <boost/dynamic_bitset.hpp>
#include <boost/filesystem.hpp>
#include <boost/range/numeric.hpp>

#include "Trace_binary.h"
#include "Clustering.h"

namespace fs = boost::filesystem;

DEFINE_int32(changeSize, 0, "Change size to...");

int main(int argc, char *argv[]) {
  gflags::ParseCommandLineFlags(&argc, &argv, true);
  if (argc < 3) {
    printf("Usage: %s clustering trace_1 ... trace_n\n", argv[0]);
    return 0;
  }

  int accepted_count = 0, declined_count = 0;
  std::ifstream in(argv[1]);
  Clustering clustering(in);
  for (int i = 2; i < argc; i++) {
    std::ifstream infile(argv[i]);
    while (infile >> std::ws && infile.peek() != EOF) {
      Trace_binary act(infile);
      if (FLAGS_changeSize) act.ChangeSize(FLAGS_changeSize);
      act.name = fs::basename(argv[i]) + fs::extension(argv[i]);
      auto cluster = clustering.FindCluster(act);
      if (cluster) {
        LOG(INFO) << "ACCEPTED " << act.name;
        accepted_count++;
      } else {
        LOG(INFO) << "DECLINED " << act.name;
        declined_count++;
      }
    }
  }
  std::cout << "Accepted          : " << accepted_count << "\n";
  std::cout << "Declined          : " << declined_count << "\n";
  std::cout << "FailedInterClust. : " <<
          declined_count - clustering.stats.numBelongsFailed[0] << "\n";
  std::cout << "FailedCooccurence : " << clustering.stats.numBelongsFailed[0] <<
          "\n";
}
