// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_CLUSTER_CLASIFIER_H_
#define PINTOOL_CLUSTER_CLASIFIER_H_

#include <iostream>
#include <string>
#include <vector>

#include "Trace_binary.h"

const char kClusterClasifierNone[] = "ClusterClasifierNone";
const char kClusterClasifierSeqBinary[] = "ClusterClasifierSeqBinary";

class ClusterClasifier {
 protected:
  ClusterClasifier() {}
 public:
  virtual void Train(const std::vector<Trace_binary> &traces) = 0;
  virtual void Print(std::ostream &out) = 0;
  virtual void Read(std::istream &in) = 0;
  virtual bool AcceptsTrace(const Trace_binary &trace) = 0;
  virtual void Clear() = 0;

  static ClusterClasifier *makeNewClasifier(std::string clasifier);
};

#endif  // PINTOOL_CLUSTER_CLASIFIER_H_
