// Copyright 2017 <Jozef Brandys>
#include <gflags/gflags.h>
#include <glog/logging.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <memory>
#include <boost/iostreams/device/file_descriptor.hpp>
#include <boost/iostreams/filtering_stream.hpp>
#include <boost/iostreams/filter/zlib.hpp>
#include <boost/iostreams/copy.hpp>

int main(int argc, char *argv[]) {
  boost::iostreams::filtering_istream in_filter;
  in_filter.push(boost::iostreams::zlib_decompressor());
  in_filter.push(std::cin);
  std::istream in(in_filter.rdbuf());
  boost::iostreams::filtering_ostream out_filter;
  out_filter.push(std::cout);
  boost::iostreams::copy(in_filter, out_filter);
}
