// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_H_
#define PINTOOL_TRACE_H_

#include <cmath>
#include <iostream>
#include <fstream>
#include <string>

class Trace {
 protected:
  // Size of tracer, is in the form of 2^x
  uint64_t size_;
  uint64_t from_, to_;
  uint64_t mask_;

  Trace() {}
  explicit Trace(int mask_size) : from_(0), to_(0) {
    size_ = (1 << mask_size);
    mask_ = size_ - 1;
  }
  explicit Trace(std::ifstream &in) {
    Read(in);
  }

 public:
  std::string name;

  uint64_t size() const {
    return size_;
  }

  void setRange(uint64_t from, uint64_t to) {
    from_ = from;
    to_ = to;
  }

  virtual void trace(uint32_t ID) {}
  void PrintMeta(std::ostream &out) {
    out << std::hex << from_ << " " << to_ << " " <<
         std::dec << size_ << std::endl;
  }
  virtual void PrintData(std::ostream &out) = 0;
  void Print(std::ostream &out) {
    PrintMeta(out);
    PrintData(out);
  }

  virtual void ReadData(std::ifstream &in) = 0;
  void ReadMeta(std::ifstream &in) {
    in >> std::hex >> from_ >> to_ >> std::dec >> size_;
  }
  void Read(std::ifstream &in) {
    ReadMeta(in);
    ReadData(in);
  }

  void ChangeSize(uint64_t new_size) {
    ChangeSizeInternal(new_size);
    size_ = new_size;
  }

  virtual void ChangeSizeInternal(uint64_t new_size) = 0;

  virtual void PrintDebug(std::ostream &out) = 0;

  virtual ~Trace() {}
};

#endif  // PINTOOL_TRACE_H_
