// Copyright 2017 <Jozef Brandys>
#include <gflags/gflags.h>
#include <glog/logging.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <memory>
#include <boost/dynamic_bitset.hpp>
#include <boost/filesystem.hpp>

#include "Trace_binary.h"
#include "Clustering.h"

DEFINE_int32(changeSize, 0, "Change size to...");

int main(int argc, char *argv[]) {
  gflags::ParseCommandLineFlags(&argc, &argv, true);
  FLAGS_logtostderr = 1;
  google::InitGoogleLogging(argv[0]);

  if (argc < 2) {
    printf("Usage: %s trace_0 trace_1 ... trace_n\n", argv[0]);
    return 0;
  }
  CoMatrix mat, mat2;
  for (int i = 1; i < argc; i++) {
    std::ifstream infile(argv[i]);
    while (infile >> std::ws && infile.peek() != EOF) {
      Trace_binary act(infile);
      if (FLAGS_changeSize) act.ChangeSize(FLAGS_changeSize);
      if (i == 1) {
        mat = act.GetBitmap();
        mat2 = act.GetBitmap();
      } else {
        mat |= act.GetBitmap();
        mat2 &= act.GetBitmap();
      }
    }
  }
  LOG(INFO) << "Number of bits in OrCoMatrix : " << mat.count();
  LOG(INFO) << "Number of bits in AndCoMatrix: " << mat2.count();
}
