// Copyright 2017 <Jozef Brandys>
#include <gflags/gflags.h>
#include <glog/logging.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <memory>
#include <boost/dynamic_bitset.hpp>
#include <boost/filesystem.hpp>

#include "Trace_binary.h"
#include "Clustering.h"
#include "Trace_all.h"
#include "Trace_stat.h"

DEFINE_int32(size, 10, "Size of hashmap");

int main(int argc, char *argv[]) {
  google::InitGoogleLogging(argv[0]);
  gflags::ParseCommandLineFlags(&argc, &argv, true);
  LOG(INFO) << "Parsing trace ";
  CHECK_LT(FLAGS_size, 15);
  FLAGS_logtostderr = 1;

  Trace_all trace(FLAGS_size);
  int nextEvent;
  while (std::cin >> nextEvent) {
    trace.trace(nextEvent);
  }
  std::ostream & objOstreamCout = std::cout;
  std::ostream & objOstreamCerr = std::cerr;
  trace.Print(objOstreamCout);
  trace.PrintDebug(objOstreamCerr);
}
