// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_ALL_H_
#define PINTOOL_TRACE_ALL_H_

#include <set>
#include <vector>

#include "Trace.h"
#include "Trace_basic.h"
#include "Trace_seq.h"

#define TRACE_COUNT if (false)

class Trace_all: virtual public Trace_basic, virtual public Trace_seq {
 protected:
  Trace_all() {}

 public:
  explicit Trace_all(int mask_size) : Trace(mask_size), Trace_basic(mask_size),
      Trace_seq(mask_size) {}

  explicit Trace_all(std::ifstream &in) {
    Read(in);
  }

  void trace(uint32_t ID) {
    Trace_basic::trace(ID);
    Trace_seq::trace(ID);
  }

  void PrintData(std::ostream &out) {
    Trace_basic::PrintData(out);
    Trace_seq::PrintData(out);
  }

  void ReadData(std::ifstream &in) {
    Trace_basic::ReadData(in);
    Trace_seq::ReadData(in);
  }

  void PrintDebug(std::ostream &out) {
    Trace_basic::PrintDebug(out);
    Trace_seq::PrintDebug(out);
  }
  void ChangeSizeInternal(uint64_t new_size) {
    Trace_basic::ChangeSizeInternal(new_size);
    Trace_seq::ChangeSizeInternal(new_size);
  }
};

#endif  // PINTOOL_TRACE_ALL_H_
