// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_BASIC_H_
#define PINTOOL_TRACE_BASIC_H_

#include <signal.h>
#include <algorithm>
#include <set>
#include <vector>

#include "Trace.h"

class Trace_basic : public virtual Trace {
 protected:
  std::vector<uint8_t> mem_;

  // ID of last traced instruction
  uint64_t lastID_ = 0;

  Trace_basic() {}

 public:
  explicit Trace_basic(int mask_size) : Trace(mask_size) {
    mem_.resize(size_, 0);
  }

  explicit Trace_basic(std::ifstream &in) : Trace() {
    Read(in);
  }

  void trace(uint32_t ID) {
    if (((lastID_ ^ ID) & mask_) == 1505) {
      raise(SIGINT);
    }
    mem_[(lastID_ ^ ID) & mask_]++;
    if (mem_[(lastID_ ^ ID) & mask_] == 0) {  // Prevent overflow
      mem_[(lastID_ ^ ID) & mask_] = 0xff;
    }
    lastID_ = ID << 1;
  }

  void PrintData(std::ostream &out) {
    out << std::hex;
    for (auto &cell : mem_) {
      uint64_t tmp = cell;
      out << tmp << " ";
    }
    out << std::endl;
  }

  void ReadData(std::ifstream &in) {
    mem_.resize(size_);
    in >> std::hex;
    for (auto &cell : mem_) {
      uint64_t tmp;
      in >> tmp;
      cell = tmp;  // Hack for reading uint_8 as number
    }
  }

  void ChangeSizeInternal(uint64_t new_size) {
    for (uint64_t i = 1; i < new_size; i++) {
      for (uint64_t j = i; j < size_; j+= new_size) {
        mem_[i] = std::min(0xff, static_cast<int>(mem_[i]) +
                                   static_cast<int>(mem_[j]));
      }
    }
    mem_.resize(new_size);
  }

  void PrintDebug(std::ostream &out) {}
};

#endif  // PINTOOL_TRACE_BASIC_H_
