// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_BINARY_H_
#define PINTOOL_TRACE_BINARY_H_

#include "Trace_all.h"
#include "Typedefs.h"

class Trace_binary : public virtual Trace_all {
 private:
  bool bitmap_actual_ = false;
  boost::dynamic_bitset<> bitmap_;

 public:
  explicit Trace_binary(std::ifstream &in) : Trace_all() {
    Read(in);
    InitBitmap();
  }

  void InitBitmap() {
    bitmap_.resize(size_);
    for (size_t i = 0; i < size_; i++) {
      if (mem_[i]) {
        bitmap_[i] = true;
      } else {
        bitmap_[i] = false;
      }
    }
    bitmap_actual_ = true;
  }

  boost::dynamic_bitset<> GetBitmap() const {
    assert(bitmap_actual_);
    return bitmap_;
  }

  void ChangeSizeInternal(uint64_t new_size) {
    Trace_all::ChangeSizeInternal(new_size);
    size_ = new_size;
    InitBitmap();
    size_ = new_size;
  }
};

#endif  // PINTOOL_TRACE_BINARY_H_
