// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_SEQ_H_
#define PINTOOL_TRACE_SEQ_H_

#include <algorithm>
#include <set>
#include <vector>
#include <utility>

#include "Trace.h"

#define TRACE_COUNT if (false)

class Trace_seq : virtual public Trace {
 protected:
  std::vector<uint64_t> mem_first_;
  std::vector<uint64_t> mem_last_;

  // ID of last traced instruction
  uint64_t lastID_ = 0;
  uint64_t seqNum_ = 0;

  Trace_seq() {}

 public:
  explicit Trace_seq(int mask_size) : Trace(mask_size) {
    mem_first_.resize(size_, 0);
    mem_last_.resize(size_, 0);
  }
  explicit Trace_seq(std::ifstream &in) : Trace() {
    Read(in);
  }

  void trace(uint32_t ID) {
    seqNum_++;
    if (mem_first_[(lastID_ ^ ID) & mask_] == 0) {
      mem_first_[(lastID_ ^ ID) & mask_] = seqNum_;
    }
    mem_last_[(lastID_ ^ ID) & mask_] = seqNum_;
    lastID_ = ID << 1;
  }

  void PrintData(std::ostream &out) {
    out << std::hex;
    for (uint64_t cell : mem_first_) {
      out << cell << " ";
    }
    out << std::endl;
    for (uint64_t cell : mem_last_) {
      out << cell << " ";
    }
    out << std::endl;
  }

  void ReadData(std::ifstream &in) {
    mem_first_.resize(size_);
    mem_last_.resize(size_);
    in >> std::hex;
    for (auto &cell : mem_first_) {
      uint64_t tmp;
      in >> tmp;
      cell = tmp;  // Hack for reading uint_8 as number
    }
    for (auto &cell : mem_last_) {
      uint64_t tmp;
      in >> tmp;
      cell = tmp;  // Hack for reading uint_8 as number
    }
  }

  void ChangeSizeInternal(uint64_t new_size) {
    for (uint64_t i = 1; i < new_size; i++) {
      for (uint64_t j = i; j < size_; j+= new_size) {
        if (mem_first_[i] != 0 && mem_first_[i] != 0) {
          mem_first_[i] = std::min(mem_first_[i], mem_first_[j]);
        } else {
          mem_first_[i] = std::max(mem_first_[i], mem_first_[j]);
        }
        mem_last_[i] = std::max(mem_last_[i], mem_last_[j]);
      }
    }
    mem_first_.resize(new_size);
    mem_last_.resize(new_size);
  }

  void PrintDebug(std::ostream &out) {}

  // Returns order of first occurences of events starting from the earliest
  std::vector<int> GetSorted() const {
    std::vector<int> res;
    std::vector<std::pair<int, int>> seq;
    for (uint i = 0; i < size_; i++) {
      seq.emplace_back(mem_first_[i], i);
    }
    std::sort(seq.begin(), seq.end());
    for (auto &p : seq) {
      if (p.first != 0) res.push_back(p.second);
    }
    return res;
  }

  // Returns the order of last occurences of events starting from the latest
  std::vector<int> GetSortedReverse() const {
    std::vector<int> res;
    std::vector<std::pair<int, int>> seq;
    for (uint i = 0; i < size_; i++) {
      seq.emplace_back(mem_last_[i], i);
    }
    std::sort(seq.rbegin(), seq.rend());
    for (auto &p : seq) {
      if (p.first != 0) res.push_back(p.second);
    }
    return res;
  }
};

#endif  // PINTOOL_TRACE_SEQ_H_
