// Copyright 2017 <Jozef Brandys>
#ifndef PINTOOL_TRACE_STAT_H_
#define PINTOOL_TRACE_STAT_H_

#include <set>
#include <vector>
#include <bitset>
#include <utility>

#include "Trace.h"

class Trace_stat : public virtual Trace {
 protected:
  std::set<uint64_t> all_, occupied_, ids_, ids_mask_;
  std::set<std::pair<uint64_t, uint64_t>> edges_;

  // ID of last traced instruction
  uint64_t lastID_ = 0;
  uint64_t traces_count = 0;

  Trace_stat() {}

 public:
  explicit Trace_stat(int mask_size) : Trace(mask_size) {}

  explicit Trace_stat(std::ifstream &in) : Trace() {
    Read(in);
  }

  void trace(uint32_t ID) {
    traces_count++;
    ids_.insert(ID);
    ids_mask_.insert(ID & mask_);
    occupied_.insert((lastID_ ^ ID) & mask_);
    all_.insert((lastID_ ^ ID));
    edges_.insert({ID, lastID_});
    lastID_ = ID;
  }

  void PrintData(std::ostream &out) {}

  void ReadData(std::ifstream &in) {}

  void ChangeSizeInternal(uint64_t new_size) {}

  void PrintDebug(std::ostream &out) {
    out << "Actual size      : " << size_ << "\n";
    out << "Mask is        : " << std::bitset<16>(mask_) << "\n";
    out << "Traces number    : " << traces_count << "\n";
    out << "Different IDS    : " << ids_.size() << "\n";
    out << "Different xor mask   : " << ids_mask_.size() << "\n";
    out << "Unique edges xor   : " << all_.size() << "\n";
    out << "Unique edges in table: " << occupied_.size() << "\n";
    out << "Unique edges pair  : " << edges_.size() << "\n";
  }
};

#endif  // PINTOOL_TRACE_STAT_H_
