// Copyright 2017 <Jozef Brandys>
#include <gflags/gflags.h>
#include <glog/logging.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <memory>
#include <boost/dynamic_bitset.hpp>
#include <boost/filesystem.hpp>

#include "Trace_binary.h"
#include "Clustering.h"

namespace fs = boost::filesystem;

DEFINE_string(clasifier, kClusterClasifierNone, "");
DEFINE_string(clustering, "", "ReadClustering from file.");
DEFINE_string(outputDir, "./out", "Output directory.");
DEFINE_int32(changeSize, 0, "Change size to...");

int main(int argc, char *argv[]) {
  gflags::ParseCommandLineFlags(&argc, &argv, true);
  FLAGS_logtostderr = 1;
  google::InitGoogleLogging(argv[0]);

  if (argc < 2) {
    printf("Usage: %s trace_0 trace_1 ... trace_n\n", argv[0]);
    return 0;
  }
  std::vector<Trace_binary> traces;
  for (int i = 1; i < argc; i++) {
    std::ifstream infile(argv[i]);
    while (infile >> std::ws && infile.peek() != EOF) {
      Trace_binary act(infile);
      if (FLAGS_changeSize) act.ChangeSize(FLAGS_changeSize);
      act.name = fs::basename(argv[i]) + fs::extension(argv[i]);
      traces.push_back(act);
      act.InitBitmap();
      CHECK(act.GetBitmap().any()) << act.name;
    }
  }

  LOG(INFO) << "Reading of traces finished: " << traces.size();
  if (FLAGS_clustering == "") {
    Clustering clustering(traces, FLAGS_clasifier, FLAGS_outputDir);
  } else {
    std::ifstream in(FLAGS_clustering);
    Clustering clustering(in);
    clustering.ChangeClasifier(FLAGS_clasifier);
    std::ofstream out(FLAGS_outputDir + "/" + fs::basename(FLAGS_clustering) +
      fs::extension(FLAGS_clustering));
    clustering.RunClusterTraining(traces, out);
    clustering.PrintStats(std::cout, traces);
  }
}
