import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class DoubledProgramEvaluation {
	Program pr1;
	Program pr2;
	Program init;
	Hashtable wfmodel = new Hashtable();
	NaiveEvaluation bottomup = new NaiveEvaluation();
	boolean show_iterations = false;
	boolean show_bottomup = false;
	
	void makeDoubled(Program pr) {
		Vector idb = pr.getIdbPredicates();
		
		
		for(int i=0; i<pr.rules.size(); i++) {
			Rule rule = new Rule((Rule)pr.rules.elementAt(i));
			for(int j=0; j<rule.goals.size(); j++) {
				Literal goal = (Literal)rule.goals.elementAt(j);
				if(goal.negated && idb.contains(goal.getPredicate2())) {
					goal.name += "'";
					init.add(goal.getRule());					
				}
			}
			pr1.add(rule);
		}
		for(int i=0; i<pr.rules.size(); i++) {
			Rule rule = new Rule((Rule)pr.rules.elementAt(i));
			rule.head.name += "'";
			for(int j=0; j<rule.goals.size(); j++) {
				Literal goal = (Literal)rule.goals.elementAt(j);
				if(!goal.negated && idb.contains(goal.getPredicate2())) {
					goal.name += "'";
				}
			}
			pr2.add(rule);
		}
	}
	public Relation eval(Program pr) {
		return eval(pr,true);
	}
	public Relation eval(Program pr, boolean initialize) {
		bottomup.show_iterations = show_bottomup;
		if(pr!=null) {

			init = new Program();
			pr1 = new Program();
			pr2 = new Program();
			makeDoubled(pr);
			if(show_iterations) {
				
				System.out.println("Doubled program:");
				System.out.println("---------------");
				System.out.println();
				System.out.println(pr1);
				System.out.println(pr2);
							
			}
			if(initialize) {
				bottomup.eval(init);
				bottomup.saveFacts();
				if(show_iterations) {				
					System.out.println("Initialization: "+bottomup.permanent.values());
					System.out.println();
				}
			}
			Hashtable before = bottomup.permanent;
			boolean change;
			if(initialize) {
				bottomup.eval(pr1);
				bottomup.saveFacts();
				if(show_iterations) {				
					System.out.println("Definitely true: "+bottomup.permanent.values());
					System.out.println();
				}
			}
			Hashtable after = bottomup.permanent;
			do {								
				bottomup.eval(pr2);
				bottomup.saveFacts();
				after = bottomup.permanent;	
				
				if(show_iterations) {				
					System.out.println("Possibly true:   "+bottomup.permanent.values());					
				}
				bottomup.eval(pr1);
				bottomup.saveFacts();
				if(show_iterations) {				
					System.out.println("Definitely true: "+bottomup.permanent.values());
					System.out.println();
				}
				after.putAll(bottomup.permanent);
				
				change = before.size() != after.size();
				if(!change) {
					for(int i=0; i<before.size(); i++) {
						Relation rel1 = (Relation)before.values().toArray()[i];
						Relation rel2 = (Relation)after.values().toArray()[i];
						change = change || rel2 == null || rel1.tuples.size()!= rel2.tuples.size();
					}
				}
				
				if(!change) {
					for(int i=0; i<before.size(); i++) {
						Relation rel1 = (Relation)before.values().toArray()[i];
						Relation rel2 = (Relation)after.values().toArray()[i];
						change = change || rel2 == null || !rel2.tuples.containsAll(rel1.tuples);
					}
				}
				
				before = after;
				wfmodel = after;
			} while(change);
			if(show_iterations) {
				System.out.println("Fixpoint reached");
				System.out.println();
				System.out.println("Well-founded model:");
				System.out.println(wfmodel.values());
				System.out.println();					
			}
			if(pr.query != null) {
				Relation answer = bottomup.computeRelation(pr.query);				
				return answer;
			} else return null;
		} else return null;
		
	}
	
	public static void main(String[] args) {
		if(args.length>0) {
			
			Program pr = new Program(args[0]);
			NaiveEvaluation bottomupmethod = null;
		
			System.out.println("Program:");
			System.out.println("--------");			
			System.out.println(pr+"?-"+pr.query);
			System.out.println();
			
			String dbinifile = null;
			boolean sql = false;
			boolean pbottomup =false;
			for(int i=1; i<args.length; i++) {
				if(args[i].equals("-sql")) {
					sql = true;
				} else if(sql) {
					dbinifile = args[i];
					sql = false;
				}
				if(args[i].equals("-bottomup")) {
					pbottomup = true;
				} else if(pbottomup) {
					try{
						System.out.println("Loading class: "+args[i]);
						bottomupmethod = (NaiveEvaluation)Class.forName(args[i]).newInstance();
					} catch(Exception e) {
						System.err.println(e);
					}
					pbottomup = false;
				}
				
			}
			Connection c =null;
			if(dbinifile!=null) {
				c = JdbcCreator.getConnection(dbinifile, true);
			}
			DoubledProgramEvaluation w = new DoubledProgramEvaluation();
			if(bottomupmethod!=null) {
				w.bottomup = bottomupmethod;
				w.bottomup.setConnection(c);
			} else {
				w.bottomup = new NaiveEvaluation(c);
			}
			
			String output = null;
			boolean setoutput = false;
			sql = false;
			pbottomup = false;
			
			for(int i=1; i<args.length; i++) {
				if(args[i].startsWith("-")) {
					
					if(args[i].equals("-o")) {
						setoutput = true;
					}
					if(args[i].equals("-sql")) {
						sql = true;
					}
					if(args[i].equals("-bottomup")) {
						pbottomup = true;
					}

				}else if(setoutput) {
					output = args[i];
					setoutput = false;
				} else if(sql) {
					sql = false;
				} else if(pbottomup) {
					pbottomup = false;
				} else {
					w.bottomup.addEdb(new Relation(args[i]));
					System.out.println("Loaded EDB table: "+args[i]);
				}
			}
			System.out.println();			
			w.show_iterations = true;
			//w.show_bottomup = true;
							 
			Relation answer = w.eval(pr);
			System.out.println("Answer:"+pr.query+" = "+answer);

			if(answer!=null && output!=null) {
				System.out.println("Writting output file: "+output);
				answer.saveToFile(output);					
			}
			if(c!=null) {
				try {
					c.close();
				} catch (SQLException x){
			    }
			}
			
		}
	}
}
