import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.io.*;


public class JdbcCreator {
	public static Connection getConnection(String driverClassName, String host, String port, String databaseName, String subprotocol, String user, String password, boolean interactive) {

		Connection c = null;
		BufferedReader stdin = new BufferedReader (new InputStreamReader(System.in));
		if(interactive && (
				driverClassName == null ||
				host == null ||
				port == null ||
				databaseName == null ||
				subprotocol == null ||
				user == null ||
				password == null)) {
			System.out.println("Enter missing values");
			System.out.println("(Leave empty, if you want to use defaults)");
			System.out.println();
		}
		if(driverClassName==null) {
			if(interactive) {
				try {
					System.out.print("Enter java class name for JDBC driver [com.mysql.jdbc.Driver]:");
					driverClassName = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}				
			}
		}
		if(driverClassName==null || driverClassName.equals("")) {
			driverClassName = "com.mysql.jdbc.Driver";
		}

		if(subprotocol==null) {
			if(interactive) {
				try {
					System.out.print("Enter subprotocol [mysql]:");
					subprotocol = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}
		}
		if(subprotocol==null || subprotocol.equals("")) {
			subprotocol = "mysql";
		}

		
		if(host==null) {
			if(interactive) {
				try {
					System.out.print("Enter hostname or ip where sql service is running [127.0.0.1]:");
					host = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}							
		}
		if(host==null || host.equals("")) {
			host = "127.0.0.1";	
		}

		if(port==null) {
			if(interactive) {
				try {
					System.out.print("Enter port number [3306]:");
					port = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}
		}
		if(port==null || port.equals("")) {
			port = "3306";
		}
		
		if(user==null) {
			if(interactive) {
				try {
					System.out.print("Enter username []:");
					user = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}
		}
		if(user==null || user.equals("")) {
			user = "";
		}
		
		if(password==null) {
			if(interactive) {
				try {
					System.out.print("Enter password []:");
					password = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}
		}
		if(password==null || password.equals("")){
			password = "";
		}

		if(databaseName==null) {
			if(interactive) {
				try {
					System.out.print("Enter default database name []:");
					databaseName = stdin.readLine();
				} catch (IOException e) {
					System.out.println("Error reading standard input");
				}
			}
		}
		if(databaseName==null || databaseName.equals("")) {
			databaseName = "";
		}

	    try {
	    	Class.forName(driverClassName).newInstance();
	    }
	    catch(Exception x){ 
	    	System.out.println( "Unable to load the DB driver class!" );
	    }
	    try {
	    	String url = "jdbc:"+subprotocol+"://"+host+":"+port+"/"+databaseName;	    	
	    	if(interactive) {
	    		System.out.println("Using url: "+url);
	    	}
	    	c = DriverManager.getConnection (url,user, password);
	    } catch (SQLException e){
	    	System.out.println( "Couldn't get connection!" );
	    }
		return c;
	}
	
	public static Connection getConnection(String filename, boolean interactive) {
		String driverclassname=null;
		String host=null;
		String port=null;
		String databasename=null;
		String subprotocol=null;
		String user=null;
		String password=null;
		
		try {
			BufferedReader in = new BufferedReader(new FileReader(filename));
			String str;
			while ((str = in.readLine()) != null) {
				String[] line = str.split("=");
				String paramname = "";
				String paramvalue = "";
				if(str.replaceAll("\\s*", "").startsWith(";")) {
					line = null;
				}
				if(line!=null && line.length >= 2 ) {
					paramname = line[0].replaceAll("\\s*", "");
					paramvalue = line[1].replaceAll("\\s*", "");
				}
				if(paramname.equals("driverclassname")) {
					driverclassname = paramvalue;
				}
				if(paramname.equals("host")) {
					host = paramvalue;
				}
				if(paramname.equals("port")) {
					port = paramvalue;
				}
				if(paramname.equals("databasename")) {
					databasename = paramvalue;
				}
				if(paramname.equals("subprotocol")) {
					subprotocol = paramvalue;
				}
				if(paramname.equals("user")) {
					user = paramvalue;
				}
				if(paramname.equals("password")) {
					password = paramvalue;
				}

			}
			
			
			
			in.close();
			
		} catch (IOException e) {
			System.err.println(e);
		}

		
		return getConnection(driverclassname, host, port, databasename, subprotocol, user, password, interactive);
	}
	
}
