import java.util.Vector;

public class Literal {
	String name = "";
	String[] params = null;
	String addorn = "";
	boolean negated = false;
	int position = -1;
	

	public Literal(String source, int position) {
		source = Parser.noWhiteSpace(source);
		Token nametoken = null;
		if(source!=null && (source.length()>0)){
			nametoken = Parser.getName(source, position);
			name = nametoken.lexeme;
			if(name.charAt(0)=='~') {
				negated=true;
				name=name.substring(1);
			}
			Parameters par = Parser.getParams(source,nametoken.position); 
			params = par.params;
			this.position = par.position;
			if(params!=null) {
				for(int i=0;i<params.length;i++) {
					if(Character.isUpperCase(params[i].charAt(0)) || params[i].charAt(0)=='_') {
						addorn+="f";
					} else {
						addorn+="b";
					}
					
				}
			}
		}
	}

	public Literal(String name, String[] params, String addorn, boolean negated) {
		this.name = name;
		this.params = params;
		this.addorn = addorn;
		this.negated=negated;
	}
	public Literal(Literal Literal) {
		name = ""+Literal.name;
		params = Literal.params;
		addorn = ""+Literal.addorn;
		negated=Literal.negated;
	}
	
	public void makeMagic() {
		name="magic_"+name;

		int arity=0;
		Vector v = new Vector();
		for(int i=0;i<addorn.length();i++) {
			if(addorn.charAt(i)=='b') {
				arity++;
				v.add(params[i]);
			}
		}

		params = new String[arity];
		for(int i=0;i<arity;i++) {
			params[i]=(String)v.elementAt(i);
		}
		addorn="";
		for(int i=0;i<params.length;i++) {
			addorn+="b";
		}

	}
	
	public void bind(Vector bound) {
		if(params!=null) {
			String addorn2 = "";
			for(int i=0;i<params.length;i++){
				if(bound.contains(params[i])) {
					addorn2+="b";
				} else {
					addorn2+=addorn.charAt(i);
				}
			}
		addorn=addorn2;
		}
	}
	
	public Vector getParamsVector() {
		Vector bound = new Vector();
		if(params!=null) {
			for(int j=0;j<params.length;j++){		
				bound.add(params[j]);
			}
		}
		return bound;
	}
	
	
	public String getPredicate() {
		return name+"/"+addorn;
	}
	public String getPredicate2() {
		int arity = 0;
		if(params!=null) {
			arity = params.length;
		}
		return name+"/"+arity;
	}
	
	public String toString() {
		String s="";
		if(negated) {
			s+="~";
		}
		s+=name;
		if (params!=null) {
			s+="(";
			for(int j=0;j<params.length;j++){
				s += params[j];
				if(j+1<params.length) {
					s+=",";
				}
			}
			s+=")";
		}
		return s;
	}
	public Rule getRule() {
		String s="";
		
		s+=name;
		if (params!=null) {
			s+="(";
			for(int j=0;j<params.length;j++){
				s += params[j];
				if(j+1<params.length) {
					s+=",";
				}
			}
			s+=")";
		}
		return new Rule(s);
	}
}
