public class Parser {
	public static Token getName(String source, int position) {
		return getToken(source,position,"\\(|:-|\\.|,");
	}
	public static boolean isVariable(String arg, String regexp) {
		return arg.matches(regexp);
	}
	
	public static Parameters getParams(String source, int position) {
		String[] params = null;
		if(source!= null && position<source.length() && source.charAt(position)=='(') {
			position++;
			Token par = getToken(source, position, "\\)");
			position=par.position+1;
			params = par.lexeme.split(",");
			
		} else {
			position++;
		}
		if(source!= null && position<source.length() && source.charAt(position)==',') {
			position++;
		}
		return new Parameters(params,position);
	}
	
	public static Token getToken(String source, int position, String regexp) {
		String src = source.substring(position);
		String t = src.split(regexp)[0];
		position+=t.length();
		return new Token(t,position);	
	}
	
	public static String noWhiteSpace (String source) {
		return source.replaceAll("\\s*", "");
	}
}
