import java.util.Vector;

public class Rule {
	Literal head = null;
	Vector goals = new Vector();

	public Rule(String source) {
		source = Parser.noWhiteSpace(source);
		String[] s = source.split(":-|\\.");

		if(s!=null){
			head = new Literal(s[0],0);
			if (s.length>1) {
				int pos = 0;
				while(pos<s[1].length()) {
					Literal a = new Literal(s[1],pos);
					goals.add(a);
					pos = a.position;
					
				}

			}
		}
	}
	public Rule(Rule rule) {
		head=new Literal(rule.head);
		goals=new Vector();
		for(int i=0;i<rule.goals.size();i++) {
			Literal goal = (Literal)rule.goals.elementAt(i);
			goals.add(new Literal(goal));
		}
	}
	public Rule(Literal head, Vector goals) {
		this.head=head;
		this.goals=goals;
	}
	
	
	public Vector getBoundVariables() {
		Vector bound = new Vector();
		if(head.params!=null) {
			for(int i=0;i<head.params.length;i++) {
				if(head.addorn.charAt(i)=='b') {
					bound.add(head.params[i]);
				}
			}
		}
		return bound;
	}
	
	public boolean bind(String pattern) {
		String[] s = pattern.split("/");
		boolean ok=false;
		if(head.name.compareTo(s[0])==0) {
			if(s.length>1 && s[1].length()==head.addorn.length()) {
		
				head.addorn=s[1]; 	
				Vector bound = head.getParamsVector();
		
				for(int i=0;i<goals.size();i++) {
					Literal goal = (Literal)goals.elementAt(i);
					goal.bind(bound);
					bound.addAll(goal.getParamsVector());
				}
				ok=true;
			}
			if(s.length==1) {
				ok=true;
			}			
		}
		
		return ok;
	}
	public String toString() {
		String s = head.toString();
		if(goals.size()>0) {
			s+=":-";
			for(int j=0;j<goals.size();j++){
				
				s += goals.elementAt(j).toString();
				if(j+1<goals.size()) {
					s+=",";
				}
			}
		}
		s+=".";
		return s;
	}
}
