import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;


public class GeneralizedMagic extends Magic{

	public Program getTransformedProgram(Program p, Literal query){
		return GeneralizedMagic.magic(p, query);
	}
	public Program getTransformedProgram(Program p){
		return GeneralizedMagic.magic(p, p.query);
	}
	
	public static Program magic(Program p, Literal query) {
		Program ap = GeneralizedMagic.addorn(p,query);
		Program pp = new Program();
		Program mm = new Program();
		Vector heads = new Vector();
		
		for(int i=0;i<ap.rules.size();i++) {
			Rule r = (Rule)ap.rules.elementAt(i);
			Rule rr = new Rule(r);
			Literal mfact = new Literal(rr.head);
			mfact.makeMagic();
			rr.goals.add(0,mfact);
			pp.add(rr);
			String head=r.head.name+"/"+r.head.addorn.length();
			heads.add(head);
		}
		for(int i=0;i<ap.rules.size();i++) {
			Rule r = (Rule)ap.rules.elementAt(i);
			Literal ph = new Literal(r.head);
			ph.makeMagic();
			for(int j=0;j<r.goals.size();j++) {
				Literal q=(Literal)r.goals.elementAt(j);
				Literal magicq = new Literal(q);
				magicq.makeMagic();
				magicq.negated=false;
				Vector v = new Vector();
				v.add(ph);
				for(int k=0;k<j;k++) {
					Literal lit=(Literal)r.goals.elementAt(k);
					v.add(lit);
				}
				Rule mr = new Rule(magicq,v);
				String qstring = q.name+"/"+q.addorn.length();
				if(heads.contains(qstring)) {
					mm.add(mr);
				}
			}
		}
		
		pp.query = new Literal(query);
		Literal seed = new Literal(query);
		seed.makeMagic();
		mm.add(new Rule(seed,new Vector()));		
		pp.add(mm);		
		return pp;
	}
	
	
	public static Program addorn(Program p, Literal query) {
		Program ap = new Program();
		Vector front = new Vector();
		query.addorn = query.addorn.replaceAll("f", "b");
		front.add(query.getPredicate());

		int i=0;
		while(i<front.size()) {
			String pattern=(String)front.elementAt(i);
			for(int j=0;j<p.rules.size();j++) {
				Rule r = (Rule)p.rules.elementAt(j);
				r.head.addorn = r.head.addorn.replaceAll("f", "b");
				Rule rr=new Rule(r);
				if(rr.bind(pattern)) {
					ap.add(rr);
					for(int k=0;k<rr.goals.size();k++) {
						Literal goal = (Literal)rr.goals.elementAt(k);
						goal.addorn = goal.addorn.replaceAll("f", "b");
						if(!front.contains(goal.getPredicate())) {
							front.add(goal.getPredicate());
						}
					}
				}
			}
			i++;
		}
		return ap;

	}
	public static void main(String[] args) {
		if(args.length>0) {
			
			Program p = new Program(args[0]);
			
			String output = null;
			boolean setoutput = false;
			for(int i=1; i<args.length; i++) {
				if(args[i].startsWith("-")) {
					
					if(args[i].equals("-o")) {
						setoutput = true;
					}

					
				} else if(setoutput) {
					output = args[i];
					setoutput = false;
				}
			}
			
			if (p.query!=null) {
				System.out.println("Program:");
				System.out.println("--------");
				System.out.print(p);
				System.out.println("?-"+p.query+"\n");
				Program mp = GeneralizedMagic.magic(p,p.query);
				System.out.println("Magic program:");
				System.out.println("--------------");
				System.out.print(mp);
				System.out.println("?-"+mp.query+"\n");
				if(output!=null) {
					System.out.println("Writting output file: "+output);
					try {
						FileOutputStream out = new FileOutputStream(output);
						out.write((""+mp+"?-"+mp.query).getBytes()); 
						out.close();
					} catch (FileNotFoundException e) {
						System.out.println("Error: Cannot open file for writing.");
					} catch (IOException e) {
						System.out.println("Error: Cannot write to file.");
					} 								
				}
				
			} else {
				System.out.println("Query missing -- magic transformations are not possible");				
			}
		} 
	}
}
