import java.util.*;
import java.util.HashSet;

public class JoinRelation extends Relation{
	public JoinRelation(Relation relation1, Relation relation2) {
		HashSet par = new HashSet();
		par.addAll(string2Vector(relation1.params));
		par.addAll(string2Vector(relation2.params));

		name = "joined";

		Vector par2 = new Vector(par);
		params = new String[par2.size()];
		
		for(int i=0;i<par2.size();i++) {
			name += par2.elementAt(i);
			params[i] = (String)par2.elementAt(i);
		}
		arity = par.size();
		
		Vector allpars = new Vector();
		Vector allvalues = new Vector();		

		allpars.addAll(string2Vector(relation1.params));
		allpars.addAll(string2Vector(relation2.params));
		
		for(int i=0; i<relation1.tuples.size(); i++) {
			for(int j=0;j<relation2.tuples.size(); j++) {
				allvalues.clear();

				Vector t1 = (Vector)relation1.tuples.toArray()[i];
				Vector t2 = (Vector)relation2.tuples.toArray()[j];
				Vector rt2 = new Vector();

				Hashtable map2 = getRename(t1, t2);
				for(int k=0; k<t2.size(); k++) {
					rt2.add(map2.get(t2.elementAt(k)));
				}
				
				allvalues.addAll(t1);
				allvalues.addAll(rt2);
				
				Hashtable map = unify(allpars,allvalues);

				if(map!=null) {
					Vector mt = new Vector();

					for(int k=0; k<par.size(); k++) {
						String p1 = (String)map.get((par.toArray()[k]));
						mt.add(p1);							
					}

					Vector v = new Vector();
					for(int k=0; k<arity; k++) {
						v.add(map.get(mt.elementAt(k)));
					}
					addTuple(v);
				}
			}
		}
	}
}
