import java.util.Vector;
import java.util.Hashtable;
import java.sql.*;

public class NaiveEvaluation {

	/**
	 * @param args
	 */
	Hashtable database = new Hashtable();  //hashtable of hashtables
	Vector activedb = new Vector();
	
	Hashtable edb = new Hashtable();
	Hashtable idb = new Hashtable();
	Hashtable permanent = new Hashtable();
	Hashtable iteration = new Hashtable();
	Connection con = null;

	
	
	Program pr = new Program();
	boolean show_iterations = false;
	
	void addRelation(Relation source, String targetname) {
		Hashtable target = (Hashtable)database.get(targetname);
		if(target == null) {
			target = new Hashtable();
			database.put(targetname, target);
		}
		if(target.containsKey(source.name+"/"+source.arity)) {
			Relation r = (Relation)(target.get(source.name+"/"+source.arity));
			r.addTuples(source);
			
		} else {
			
			target.put(source.name+"/"+source.arity, source);
			String[] newparams = new String[source.arity]; 
			for(int i=0; i<source.arity;i++) {
				newparams[i] = "X"+i;
			}
			if(!source.external) {
				source.params = newparams;
			}
		}
		
	}
	
	void addIdb(Relation relation) { //vyratane idb relacie
		addRelation(relation, "idb");
	}
	void addEdb(Relation relation) { //vyratane Edb relacie
		addRelation(relation, "edb");
	}
	
	
	
	Relation computeRelation(Literal Literal) {		
		Relation answer = new Relation(Literal);
		Relation answer2 = new Relation(Literal);
		String key = answer.name+"/"+answer.arity;
		Relation r = new Relation();
		
		for(int i=0; i<activedb.size(); i++) {
			Hashtable relations = (Hashtable)database.get((String)activedb.elementAt(i));
			if(relations.containsKey(key)) {
				r = (Relation)relations.get(key);
				if(!r.external) {
					answer.addTuples(r);
				} else {
					if(r!=null && r.params!=null) {
						try {
							Statement st = con.createStatement();
							String query = "select ";
							for(int j=0;j<r.arity;j++) {
								if(j<r.arity-1) {
									query += r.params[j]+",";
								} else {
									query += r.params[j]+" from "+r.name+" where 1=1 ";
								}
							}
							
							for(int j=0;j<r.arity;j++) {
								if(!Character.isUpperCase(Literal.params[j].charAt(0))) {
									query += "and "+r.params[j]+"='"+Literal.params[j]+"' ";
								}
							}
							
							ResultSet rs = st.executeQuery(query);
							while(rs.next()) {
								Vector tuple = new Vector();
								for(int j=0; j<r.arity;j++) {
									tuple.add(rs.getString(j+1));
								}
								answer.addTuple(tuple);
							}							
						} catch (SQLException e) {
							System.out.println(e);
						}
					}
				}
			}
		}
		
		if(answer.params!=null) {
			Hashtable map = new Hashtable();
			Hashtable map2 = new Hashtable();
			for(int i=0;i<answer.tuples.size(); i++) {				
				if(map!=null) {
					map.clear();
				}
				if(map2!=null) {
					map2.clear();
				}
				Vector t = (Vector)answer.tuples.toArray()[i];
				
				map = Relation.unify(Relation.string2Vector(answer.params),t);
				
				if(map!=null) {
					Vector v = new Vector();
					for(int k=0; k<answer.arity; k++) {
						String s = (String)map.get(answer.params[k]);
						v.add(s);							
					}
					answer2.addTuple(v);
				}
				
			}
		} else {
			answer2.tuples.addAll(answer.tuples);
		}
		
		
		
		return answer2;
	}	
	

	public void saveFacts() {
		permanent = idb;			
		database.put("permanent", permanent);
		idb = new Hashtable();
		database.put("idb", idb);
		
	}
	
	public void clearFacts() {
		permanent = new Hashtable();		
		database.put("permanent", permanent);
	}
	boolean iteration() {
		boolean change = false;		
		for(int i=0; i<pr.rules.size(); i++) {  //pre vsetky pravidla
			boolean emptygoal = true;			
			Rule rule = (Rule)pr.rules.elementAt(i);			
			Relation headrelation = new Relation(rule.head);			
			
			boolean firstpositive = true;
			for(int j=0; j<rule.goals.size(); j++) {  //pre vsetky nenegovane podciele
				Literal goal = (Literal)rule.goals.elementAt(j);
				if(!goal.negated) {
					Relation goalrelation = computeRelation((Literal)rule.goals.elementAt(j));
					
					if(firstpositive) {
						headrelation = goalrelation;
						firstpositive = false;
						emptygoal = false;
					} else {
						headrelation = new JoinRelation(headrelation,goalrelation);						
					}					
				}							
			}
			
			for(int j=0; j<rule.goals.size(); j++) {  //pre vsetky negovane podciele
				Literal goal = (Literal)rule.goals.elementAt(j);
				if(goal.negated) {
					Relation goalrelation = computeRelation((Literal)rule.goals.elementAt(j));
					
					if(firstpositive) {
						emptygoal &= goalrelation.tuples.isEmpty();
					} else {
						headrelation = new AntijoinRelation(headrelation,goalrelation);
					}
				} 
			}			

			if(rule.goals.size()==0 || emptygoal) {
				headrelation.addTuple(rule.head);
			}
			if(headrelation.tuples.size()>0) {
				headrelation = new ProjectRelation(headrelation,rule.head.params);
				headrelation.name = rule.head.name;
				
				addRelation(headrelation, "iteration");
			}
		}
		change = idb.size() != iteration.size();
		if(!change) {
			for(int i=0; i<iteration.size(); i++) {
				Relation rel1 = (Relation)iteration.values().toArray()[i];
				Relation rel2 = (Relation)idb.values().toArray()[i];
				change = change || rel2 == null || rel1.tuples.size()!= rel2.tuples.size();
			}
		}
		
		if(!change) {
			for(int i=0; i<iteration.size(); i++) {
				Relation rel1 = (Relation)iteration.values().toArray()[i];
				Relation rel2 = (Relation)idb.values().toArray()[i];
				change = change || rel2 == null || !rel2.tuples.containsAll(rel1.tuples);
			}
		}
		
		idb = iteration;			
		database.put("idb", idb);
		iteration = new Hashtable();
		database.put("iteration", iteration);		
		return change;
	}
	public NaiveEvaluation() {
		database.put("edb", edb);
		database.put("idb", idb);
		database.put("permanent", permanent);
		database.put("iteration", iteration);
		activedb.add("edb");
		activedb.add("idb");
		activedb.add("permanent");

	}
	public NaiveEvaluation(Program p) {
		this();
		pr = p;
	}
	public NaiveEvaluation(Program p, Connection con) {
		this(con);
		pr = p;
	}
	public void setConnection(Connection con) {
		if(con != null) {
			this.con = con;
			activedb.add("sql");
			try {
				DatabaseMetaData md = con.getMetaData();
				ResultSet rs = md.getTables(null, null, "%", null);			
				while (rs.next()){
					String tablename = rs.getString("TABLE_NAME");
					Vector columns = new Vector();
					
					ResultSet rs2 = md.getColumns(null, null, tablename, "%");
					while (rs2.next()) {
						columns.add(rs2.getString(4));
					}
					String[] s = new String[columns.size()];
					for(int i=0; i< columns.size();i++) {
						s[i] = (String)columns.elementAt(i);
					}
					Relation r = new Relation(tablename,s);
					r.external = true;
					r.arity = columns.size();
					addRelation(r, "sql");				
				}
			} catch (SQLException e) {
				System.out.println(e);
			}		
		}
		
	}
	public NaiveEvaluation(Connection con) {
		this();
		setConnection(con);
	}
	
	public void eval1(Program program) {
		pr = program;
		if(pr!=null) {
			int k=0;
			iteration();
			if(show_iterations) {
				System.out.println("Iteration "+k+":");
			
				for(int i=0; i<idb.size();i++) {
					System.out.println((Relation)idb.values().toArray()[i]);
				}
				System.out.println();
			}
		}
	}
	public Relation eval() {
		if(pr!=null) {
			int k=0;
			while (iteration()) {
				if(show_iterations) {
					System.out.println("Iteration "+k+":");
					for(int i=0; i<idb.size();i++) {
						System.out.println((Relation)idb.values().toArray()[i]);
					}
					System.out.println();
					k++;
				}				
			}			
			if(pr.query != null) {
				Relation answer = computeRelation(pr.query);
				return answer;
			} else return null;
		} else return null;
	}
	public Relation eval(Program program) {
		pr = program;
		return eval();
	}
	public static void main(String[] args) {

		

		if(args.length>0) {
			Program prog = new Program(args[0]);
			System.out.println("Program:");
			System.out.println("--------");				
			System.out.println(prog+"?-"+prog.query);
			System.out.println();

		
			String dbinifile = null;
			boolean sql = false;
			for(int i=1; i<args.length; i++) {
				if(args[i].equals("-sql")) {
					sql = true;
				} else if(sql) {
					dbinifile = args[i];
					sql = false;
				}
			}
			Connection c =null;
			if(dbinifile!=null) {
				c = JdbcCreator.getConnection(dbinifile, true);
			}
			
			NaiveEvaluation n = new NaiveEvaluation(c);
		    
			
			String output = null;
			boolean setoutput = false;
			sql = false;
			for(int i=1; i<args.length; i++) {
				if(args[i].startsWith("-")) {
					
					if(args[i].equals("-o")) {
						setoutput = true;
					}
					if(args[i].equals("-sql")) {
						sql = true;
					}

					
				} else if(setoutput) {
					output = args[i];
					setoutput = false;
				} else if(sql) {
					sql = false;
				} else {
					System.out.println("'"+args[i]+"'");
					n.addEdb(new Relation(args[i]));
					System.out.println("Loaded EDB table: "+args[i]);
				}
			}
			
			System.out.println();
			n.show_iterations = true;
			Relation answer = n.eval(prog);
			if(answer!= null) { 				
				System.out.println("Answer: "+n.pr.query+" = "+answer);			
				if(output!=null) {
					System.out.println("Writting output file: "+output);
					answer.saveToFile(output);					
				}
			}
			if(c!=null) {
				try {
					c.close();
				} catch (SQLException x){
			    }
			}
		}
		
	}
}