import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Program {
	Literal query=null;
	Vector rules = new Vector();
	public void add(Rule rule) {
		rules.add(rule);
	}
	public void add(Program p) {
		rules.addAll(p.rules);
	}
	public Vector getRules() {
		return rules;
	}
	public Program() {
		
	}
	public Program(String filename) {
		try {
			BufferedReader in = new BufferedReader(new FileReader(filename));
			String str;
			int ind;
			while ((str = in.readLine()) != null) {
				ind = str.indexOf("?-");
				if(ind >= 0){
					query = new Literal(str.substring(ind+2),0);
				} else if(str.indexOf(".") >= 0) {
					add(new Rule(str));
				}
			}
			in.close();
			
		} catch (IOException e) {
			System.err.println(e);
		}
	}
	
	public Vector getPredicates() {
		Vector v = new Vector();
		for(int i=0;i<rules.size();i++) {
			Rule r = (Rule)rules.elementAt(i);
			if(!v.contains(r.head.getPredicate())) {
				v.add(r.head.getPredicate());
			}
		}
		return v;
	}
	
	public Vector getIdbPredicates() {
		Vector v = new Vector();
		for(int i=0;i<rules.size();i++) {
			Rule r = (Rule)rules.elementAt(i);
			if(!v.contains(r.head.getPredicate2())) {
				v.add(r.head.getPredicate2());
			}
		}
		return v;
	}
	
	public String toString() {
		String s = "";
		for(int i=0;i<rules.size();i++) {
			Rule r = (Rule)rules.elementAt(i);
			s+=r+"\n";
		}
		return s;
	}
}
