import java.util.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;

public class Relation {
	String name = "";
	int arity = 0;
	String[] params = null;
	boolean external = false;

	HashSet tuples = new HashSet();

	public void saveToFile(String filename) {
		try {

            FileOutputStream fileOut = new FileOutputStream(filename);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(name);
            out.writeObject(params);
            out.writeObject(tuples);
            out.close();
            fileOut.close();
           
        } catch(FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
	}
	
	public void loadFromFile(String filename) {


        try {
            FileInputStream fileIn = new FileInputStream(filename);
            ObjectInputStream in = new ObjectInputStream(fileIn);

            name = (String)in.readObject();
            params = (String[])in.readObject();
            tuples = (HashSet)in.readObject();
            if(params!=null) {
            	arity = params.length;
            } else {
            	arity = 0;
            }
            in.close();
            fileIn.close();

        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch(FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
	
	public Relation(String filename) {		
		loadFromFile(filename);
	}

	
	public Relation() {
	}
	
	public Relation(String name, String[] params) { 
		this.name = name;
		this.params = params;
		arity = 0;
		if(params!=null) {
			arity = params.length;			
		}
	}
	
	public Relation(Literal predicate) { 
		name = predicate.name;
		if(predicate.params!=null) {
			arity = predicate.params.length;	
		} else {
			arity = 0;
		}
		params = predicate.params;
	}
	public static Vector string2Vector(String[] s) {
		Vector result = new Vector();
		if(s!=null) {
			for(int i=0; i<s.length; i++) {
				result.add(s[i]);
			}
		}
		return result;
	}
	

	public static Hashtable getRename(Vector pattern, Vector tuple) {

				
		Hashtable map2 = new Hashtable();
		Vector tuple2 = new Vector();
		map2.clear();

		for(int i=0; i<tuple.size(); i++) {
			String arg = (String)tuple.elementAt(i);
			String newarg = ""+arg;
			if(Character.isUpperCase(arg.charAt(0)) && !map2.contains(arg)) {
				int ind = 0;
				while(pattern.contains(newarg)) {
					newarg = arg+ind;
					ind++;
				}
				map2.put(arg, newarg);
			} else {
				map2.put(arg, arg);
			}
			/*
			 * make copy of arguments to prevent unwanted modification
			 */
			tuple2.add(newarg);			
		}
		return map2;
	}
	
	public static Hashtable unify(Vector pattern, Vector tuple) {
		Hashtable map = new Hashtable();
		Hashtable map2 = new Hashtable();
		Vector pattern2 = new Vector();
		Vector tuple2 = new Vector();
		map.clear();
		map2.clear();
		boolean ok = pattern.size()==tuple.size();
		if(!ok) {
			return null;
		}
		
		/*
		 * First create substitution map2 to rename variables in tuple to be distinct from pattern
		 */
		
		map2 = getRename(pattern, tuple);
		
		for(int i=0; i<tuple.size(); i++) {
			String arg = (String)tuple.elementAt(i);
			String newarg = (String)map2.get(arg);
			
			pattern2.add(""+pattern.elementAt(i));
			tuple2.add(newarg);			
		}
		
		/*
		 * create substitution map such that map(pattern) == map(map2(tuple))
		 */
		for(int i=0; i<tuple2.size(); i++) {
			String arg1 = (String)pattern2.elementAt(i);
			String arg2 = (String)tuple2.elementAt(i);
			String x = null;
			String t = null;
			if(Character.isUpperCase(arg1.charAt(0))) {
				x = ""+arg1;
				t = ""+arg2;
			} else if(Character.isUpperCase(arg2.charAt(0))) {
				x = ""+arg2;
				t = ""+arg1;
			}
			if(x!=null) {
				if(t.equals(x)) {
					return null;
				} else {
					map.put(x, t);
					//System.out.println("newsub: "+x+" -> "+t);
					for(int j=0; j<tuple2.size(); j++) {
						if(tuple2.elementAt(j).equals(x)) {
							tuple2.setElementAt(t, j);
						}
						if(pattern2.elementAt(j).equals(x)) {
							pattern2.setElementAt(t, j);
						}
					}
					Vector keys = new Vector(map.keySet());
					for(int j=0; j<map.size(); j++) {
						String key = (String)keys.elementAt(j);
						String val = (String)map.get(key);
						if(val.equals(x)){
							map.put(key, t);
													}
					}
				}
			} else if(arg1.equals(arg2)) {
				map.put(arg1, arg2);
			} else {
				return null;
			}
		}
		
		/*
		 * Make substitution complete
		 */
		for(int i=0; i<tuple2.size(); i++) {
			String s1 = (String)map2.get(tuple.elementAt(i)); 
			String s2 = (String)pattern.elementAt(i); 
			if(map.get(s1)==null) {
				map.put(s1, s1);
			}
			if(map.get(s2)==null) {
				map.put(s2, s2);
			}
		}

			
			
			
		for(int k=0; k<pattern.size(); k++) {
			String s1 = (String)map.get(pattern.elementAt(k));
			String s2 = (String)map.get(map2.get(tuple.elementAt(k)));
			if(!s1.equals(s2)) {
				return null;
			}
			
			
		}
		if(ok) {
			return map;			
		} else {
			return null;
		}
	}
	
	
	
	
	public void addTuple(Vector tuple) {
		if(arity == tuple.size()) {
			boolean ok = true;
			for(int i=0; i<arity;i++) {
				ok &= Character.isUpperCase(params[i].charAt(0)) || params[i].equals((String)tuple.elementAt(i)); 
			}			
			tuples.add(tuple);				
		}
	}
	public void addTuple(Literal literal) {
		if(name.equals(literal.name) && arity == string2Vector(literal.params).size()) {
			Vector newtuple = new Vector();
			for(int k=0;k<arity;k++) {
				newtuple.add(literal.params[k]);							
			}			
			addTuple(newtuple);
		}
	}
	public void addTuples(Relation relation) {
		for(int i=0; i<relation.tuples.size();i++) {
			addTuple((Vector)relation.tuples.toArray()[i]);
		}
	}
	public String toString() {
		String s = name+tuples;
		return s;
	}
	public String tableOutput() {
		String s = name+"\n";
		Object[] ar = tuples.toArray();
		for(int i=0; i<tuples.size(); i++) {
			s+=""+ar[i]+"\n";
		}
		return s;
	}
	
}
