import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.Hashtable;
public class WellFoundedMagicSetEvaluation extends DoubledProgramEvaluation{
	Magic transformation = new Magic();
	boolean show_phases = false;
	boolean twoValuedMagicFacts() {
		boolean result = true;
		Vector keys = new Vector(wfmodel.keySet());
		Relation rel1;
		Relation rel2=null;
		for(int i=0; i<keys.size(); i++) {
			String key = (String)keys.elementAt(i);			
			if(key.startsWith("magic_")) {
				rel1 = (Relation)wfmodel.get(key);

				if (rel1.name.endsWith("'")) {
					rel2 = (Relation)wfmodel.get(rel1.name.substring(0,rel1.name.length()-1)+"/"+rel1.arity);
					result &= rel2!=null && rel2.tuples.containsAll(rel1.tuples);
				}
			}
		}
		return result;
	}
	

	
	
	public Relation eval(Program pr) {
		Relation answer = null;		
		if(pr.query != null) {
			Program mp;
			mp = transformation.getTransformedProgram(pr, pr.query);
			
			if(show_phases) {
				System.out.println("Phase 1:");
				System.out.println("--------");
				System.out.println("Magic program:");
				System.out.println();
				System.out.println(mp+"?-"+mp.query);				
			}

			answer = super.eval(mp, true);
			if(show_phases) {
				System.out.println("Well-founded model:");
				System.out.println(wfmodel.values());
				System.out.println();
				System.out.println("Phase 1 answer:"+pr.query+" = "+answer);
				System.out.println();
			}

			if(!twoValuedMagicFacts()) {
				if(show_phases) {
					System.out.println("Magic predicates are not two-valued");
					System.out.println();
					System.out.println("Phase 2:");
					System.out.println("--------");

				}
				Program pm = new Program();
				for(int i=0; i<mp.rules.size(); i++) {
					Rule rule = (Rule)mp.rules.elementAt(i);
					if(!rule.head.name.startsWith("magic_")) {
						pm.add(rule);
					}
				}
				pm.query = new Literal(pr.query);
				Vector keys = new Vector(wfmodel.keySet());
				for(int j=0; j<keys.size(); j++) {
					String key = (String)keys.elementAt(j);
					Relation rel = (Relation)wfmodel.get(key);

					if (rel.name.startsWith("magic_") && rel.name.endsWith("'")) {
					 	Relation r = new Relation(rel.name.substring(0,rel.name.length()-1), rel.params);
						r.addTuples(rel);
						bottomup.addRelation(r,"magicfacts");
						bottomup.addRelation(rel,"magicfacts");
						bottomup.activedb.add("magicfacts");
					} else 	if (!rel.name.startsWith("magic_") && !rel.name.endsWith("'")) {
						bottomup.addRelation(rel, "permanent");
					}
				}				
				answer = super.eval(pm, false);
			}
			
		} else {
			if(show_phases) {
				if(pr.query==null) {
					System.out.println("Query missing -- magic transformations are not possible");
				} else {
					System.out.println("Query contains only free variables -- magic transformations are not necessary");
				}
				System.out.println();
			}
			answer = super.eval(pr, true);
		}
		if(show_phases) {
			System.out.println("Well-founded model:");
			Hashtable magicf = (Hashtable)bottomup.database.get("magicfacts");
			if(magicf!=null) {
				System.out.println(magicf.values());
			}
			System.out.println(wfmodel.values());
			System.out.println();					
		}

		return answer;
	}	

	public static void main(String[] args) {
		if(args.length>0) {
			
			Program pr = new Program(args[0]);
			Magic trans = new Magic();
			NaiveEvaluation bottomupmethod = null;
			
			System.out.println("Program:");
			System.out.println("--------");			
			System.out.println(pr+"?-"+pr.query);
			System.out.println();
			
			String dbinifile = null;
			boolean sql = false;
			boolean pmagic = false;
			boolean pbottomup =false;
			for(int i=1; i<args.length; i++) {
				if(args[i].equals("-sql")) {
					sql = true;
				} else if(sql) {
					dbinifile = args[i];
					sql = false;
				}
				if(args[i].equals("-magic")) {
					pmagic = true;
				} else if(pmagic) {
					try{
						System.out.println("Loading class: "+args[i]);
						trans = (Magic)Class.forName(args[i]).newInstance();
					} catch(Exception e) {
						System.err.println(e);
					}
					pmagic = false;
				}
				if(args[i].equals("-bottomup")) {
					pbottomup = true;
				} else if(pbottomup) {
					try{
						System.out.println("Loading class: "+args[i]);
						bottomupmethod = (NaiveEvaluation)Class.forName(args[i]).newInstance();
					} catch(Exception e) {
						System.err.println(e);
					}
					pbottomup = false;
				}
			}
			Connection c =null;
			if(dbinifile!=null) {
				c = JdbcCreator.getConnection(dbinifile, true);
			}
			
			WellFoundedMagicSetEvaluation w = new WellFoundedMagicSetEvaluation();
			
			if(bottomupmethod!=null) {
				w.bottomup = bottomupmethod;
				w.bottomup.setConnection(c);
			} else {
				w.bottomup = new NaiveEvaluation(c);
			}
			
			
			w.transformation = trans;
			
			String output = null;
			boolean setoutput = false;
			sql = false;
			pmagic = false;
			pbottomup = false;
			
			for(int i=1; i<args.length; i++) {
				if(args[i].startsWith("-")) {
					
					if(args[i].equals("-o")) {
						setoutput = true;
					}
					if(args[i].equals("-sql")) {
						sql = true;
					}
					if(args[i].equals("-magic")) {
						pmagic = true;
					}
					if(args[i].equals("-bottomup")) {
						pbottomup = true;
					}

				}else if(setoutput) {
					output = args[i];
					setoutput = false;
				} else if(sql) {
					sql = false;
				} else if(pmagic) {
					pmagic = false;
				} else if(pbottomup) {
					pbottomup = false;
				} else {
					w.bottomup.addEdb(new Relation(args[i]));
					System.out.println("Loaded EDB table: "+args[i]);
				}
			}
			System.out.println();			
			w.show_iterations = true;
			//w.show_bottomup = true;
							 
			Relation answer = w.eval(pr);
			System.out.println("Answer:"+pr.query+" = "+answer);

			if(answer!=null && output!=null) {
				System.out.println("Writting output file: "+output);
				answer.saveToFile(output);					
			}
			if(c!=null) {
				try {
					c.close();
				} catch (SQLException x){
			    }
			}
			
		}
	}
	
}
