#!/usr/bin/python3

import typing
from configurator import parse_data, Node
import sys


def get_latex_node_str(nid: str, name: str, inn: str, out: str):
    return "\\vrchol{" + nid + "}{" + name.replace("\\n", " ").replace("\\l", " ") + "}{" + inn + "}{" + out + "}"


def print_latex(nodes: typing.Dict[str, Node]):
    for k, v in nodes.items():
        print(get_latex_node_str(k, v.label, v.get_parents_str(nodes.values()), v.get_children_str()))


def process_latex_file(input_filename, output_filename, nodes: typing.Dict[str, Node]):
    out_lines = []
    with open(input_filename, "r") as i:
        lines = i.read().split("\n")
    for line in lines:
        if line.find("\\vrchol{") == 0:
            nid = line[line.find("{") + 1:line.find("}")]
            node = nodes[nid]
            out_lines.append(
                get_latex_node_str(nid, node.label, node.get_parents_str(nodes.values()), node.get_children_str()))
            out_lines.append("\n")
        else:
            out_lines.append(line)
            out_lines.append("\n")
    with open(output_filename, "w") as o:
        o.writelines(out_lines)


with open(sys.argv[1]) as f:
    data_s = f.read()
graph = parse_data(data_s)

process_latex_file(sys.argv[2], sys.argv[3], graph)
