# Prot386 Text output and input functions
# (C) 2006-2007 Peter Ambroz
# This code is free software and is distributed under the terms of GNU GPL

	.text
	.globl clrscr
	.globl gotoxy, get_x, get_y
	.globl hide_cursor, show_cursor
	.globl highlight
	.globl write, put_char
	.globl window, save_window, load_window
	.globl save_screen, load_screen, init_screen_stack
	.globl inttostr, bintostr, hextostr, strtoint, strtobin, strtohex
	.globl regtostr
	.globl pad_right
	.globl readkey, read_enter, _read_enter, read_char, xlat_char, read_string
	.globl textattr, clearchar, pos_x, pos_y, win_x1, win_y1, win_x2, win_y2
	.globl min, max
	.globl use_eol, newl, no0x

win_data:
textattr: .long 7
clearchar: .long 32
pos_x:	.long 0
pos_y:	.long 0
win_x1:	.long 0
win_y1:	.long 0
win_x2:	.long 79
win_y2:	.long 24
use_eol: .long 0
newl: .string "\n"
no0x: .long 0
scr_sp: .long 0  # Initialized via call to init_screen_stack from main.s

# void clrscr(void)
# clear the text screen with clearchar and reset cursor to the upper left corner
clrscr:
	push %es
	push %gs
	pop %es
	push %edi
	movw clearchar, %ax	# char
	movb textattr, %ah	# color
	movl $25*80, %ecx	# text screen size
	xorl %edi, %edi		# ES:EDI = starting offset of text mode video-ram
	rep stosw		# store color+char information to every position
	# next we will reset cursor positon
	xorw %ax, %ax
	movb $0x0E, %al
	movw $0x3D4, %dx
	outw %ax, %dx		# output value 0x00 to CRT register 0x0E (16 bit port 0x3D4)
	movb $0x0F, %al
	outw %ax, %dx		# output value 0x00 to CRT register 0x0F
	# adjust local cursor position variables
	movl $0, pos_x
	movl $0, pos_y
	pop %edi
	pop %es
	ret

# void gotoxy(int x, int y)
# Move text cursor to new position
gotoxy:
	push %ebp
	movl %esp, %ebp
	
	push %ebx
	movl 8(%ebp), %ebx
	movl 12(%ebp), %edx
	
	addl win_x1, %ebx
	addl win_y1, %edx
	
	movl %ebx, pos_x
	movl %edx, pos_y
	
	call move_cursor
	
	pop %ebx
	leave
	ret

get_x:
	movl pos_x, %eax
	subl win_x1, %eax
	ret

get_y:
	movl pos_y, %eax
	subl win_y1, %eax
	ret

# Internal, cursor update function
# ebx = x coordinate
# edx = y coordinate
move_cursor:
	movl %edx, %eax
	movl $80, %ecx
	mull %ecx
	addl %ebx, %eax
	
	pushw %ax
	movb $0x0E, %al
	movw $0x3D4, %dx
	outw %ax, %dx
	popw %ax
	xchgb %al, %ah
	movb $0x0F, %al
	outw %ax, %dx

	ret

.macro _set_cursor value1 value2
	movw \value1, %ax
	movw $0x3D4, %dx
	outw %ax, %dx
	movw \value2, %ax
	outw %ax, %dx
.endm

hide_cursor:
	_set_cursor $0x200A $0x000B
	ret

show_cursor:
	_set_cursor $0x0E0A $0x0F0B
	ret

# void highlight(int x1, int x2, int y, int atr)
# highlight selected portion of the line y with color attribute atr
highlight:
	push %ebp
	movl %esp, %ebp
	
	push %es
	push %gs
	pop %es
	push %edi
	movl 16(%ebp), %eax
	movl $80, %ecx
	mull %ecx
	addl 8(%ebp), %eax
	shll %eax
	incl %eax
	movl %eax, %edi		# edi = (y*80 + x1)*2 + 1
	movl 20(%ebp), %eax	# eax = atr
	
	movl 12(%ebp), %ecx
	subl 8(%ebp), %ecx
	incl %ecx		# ecx = x2 - x1 + 1
	
_for1:	
	stosb			# [es:edi] = al edi++
	incl %edi
	loop _for1
	
	pop %edi
	pop %es
	leave
	ret

# The exclusive text-output function
write:
	push %ebp
	movl %esp, %ebp
	
	push %es
	push %gs
	pop %es
	push %ebx
	push %esi
	push %edi
	movl win_x1, %edx
	movl win_x2, %ebx
	
	movl 8(%ebp), %esi
	test %esi, %esi
	jz _end_wr
	
_for3:	movl pos_y, %eax
	movl $80, %ecx
	push %edx
	mull %ecx
	pop %edx
	addl pos_x, %eax
	shll %eax
	movl %eax, %edi
	movb textattr, %ah
	
_for2:	movb (%esi), %al
	incl %esi
	cmpb $0, %al
	je _end_wr
	cmpb $0x0A, %al
	je _nline0
	stosw
	incl pos_x
	cmpl %ebx, pos_x
	jle _for2
	jmp _nline
_nline0:
	cmpl $0, use_eol
	jnz _end_wr
_nline:
	movl %edx, pos_x
	incl pos_y
	jmp _for3
_end_wr:
	movl pos_y, %edx
	movl pos_x, %ebx
	call move_cursor
	
	pop %edi
	pop %esi
	pop %ebx
	pop %es
	leave
	ret

# void put_char(int ch)
# Put one character on the screen and update cursor
put_char:
	push %ebp
	movl %esp, %ebp

	push %es
	push %gs
	pop %es
	push %ebx
	push %edi
	movl win_x1, %edx
	movl win_x2, %ebx

	movl pos_y, %eax
	movl $80, %ecx
	push %edx
	mull %ecx
	pop %edx
	addl pos_x, %eax
	shll %eax
	movl %eax, %edi

	movb textattr, %ah
	movb 8(%ebp), %al
	movw %ax, %es:(%edi)
	incl pos_x
	cmpl %ebx, pos_x
	jle _end_putchar

	movl %edx, pos_x
	incl pos_y

_end_putchar:
	movl pos_y, %edx
	movl pos_x, %ebx
	call move_cursor

	pop %edi
	pop %ebx
	pop %es
	leave
	ret

# Write the 4 characters encoded within 32-bit number
write_num:
	enter $0,$0
	push %ebx
	movl 8(%ebp), %ebx
	subl $4, %esp
_wn_rep:
	movb %bl, (%esp)
	call put_char
	shrl $8, %ebx
	cmpl $0, %ebx
	jne _wn_rep

	pop %ebx
	leave
	ret

# void window(x1, y1, x2, y2)
window:
	push %ebp
	movl %esp, %ebp
	
	movl 8(%ebp), %eax
	movl %eax, win_x1
	movl %eax, pos_x
	movl 12(%ebp), %eax
	movl %eax, win_y1
	movl %eax, pos_y
	movl 16(%ebp), %eax
	movl %eax, win_x2
	movl 20(%ebp), %eax
	movl %eax, win_y2
	
	leave
	ret

# void save_window(&data)
save_window:
	enter $0,$0
	
	movl 8(%ebp), %eax
	subl $12, %esp
	movl $36, 8(%esp)
	movl $win_data, 4(%esp)
	movl %eax, (%esp)
	call memcpy

	leave
	ret

# void load_window(&data)
load_window:
	enter $0,$0

	movl 8(%ebp), %eax
	subl $12, %esp
	movl $36, 8(%esp)
	movl %eax, 4(%esp)
	movl $win_data, (%esp)
	call memcpy

	leave
	ret

init_screen_stack:
	movl $0x8000, scr_sp
	ret

# Fast screen save
# Needed for interrupts which garble the screen
# These 2 functions perform no range checks. If the stack space is overrun, protected mode will handle it.
save_screen:
	push %esi
	push %edi
	push %ds
	push %es

	xorl %esi, %esi
	subl $4096, scr_sp
	movl scr_sp, %edi
	movl $1024, %ecx

	movw %gs, %ax
	movw %ax, %ds
	movw %ax, %es

	rep movsl
	
	pop %es
	pop %ds
	pop %edi
	pop %esi
	ret

# Fast screen restore
# Needed for interrupts which garble the screen
load_screen:
	push %esi
	push %edi
	push %ds
	push %es

	xorl %edi, %edi
	movl scr_sp, %esi
	movl $1024, %ecx

	movw %gs, %ax
	movw %ax, %ds
	movw %ax, %es

	rep movsl
	
	pop %es
	pop %ds
	pop %edi
	pop %esi

	addl $4096, scr_sp

	ret

# integer to string conversion: first part
.macro _inttostr_1 base
	push %ebx
	push %esi
	movl 8(%ebp), %eax
	movl 12(%ebp), %ebx
	movl \base, %esi
	xorl %ecx, %ecx
	decl %ecx
.endm

# integer to string conversion: last part
.macro _inttostr_2 id
	xorl %edx, %edx
	# Reverse the string from local array into ebx (indices are ecx, edx)
_for5\id:
	incl %ecx
	movb (%ebp,%ecx,1), %al
	movb %al, (%ebx,%edx,1)
	incl %edx
	cmpl $-1, %ecx
	jnz _for5\id

	movb $0, (%ebx,%edx,1)
	movl %ebx, %eax
.endm

# Convert unsigned integer to decimal string
inttostr:
	push %ebp
	movl %esp, %ebp
	subl $16, %esp	# Local array
	_inttostr_1 $10

	# Divide number by 10 and store remainders into local array (index is ecx)
_for4:
	xorl %edx, %edx
	divl %esi
	addb $48, %dl
	movb %dl, (%ebp,%ecx,1)
	decl %ecx
	cmpl $0, %eax
	jnz _for4
	
	_inttostr_2 int

	pop %esi
	pop %ebx
	leave
	ret

# Convert unsigned integer to binary string
bintostr:
	push %ebp
	movl %esp, %ebp
	subl $36, %esp	# Local array
	_inttostr_1 $2

	# Divide number by 2 and store remainders into local array (index is ecx)
_for42:
	shrl %eax
	setc %dl
	addb $48, %dl
	movb %dl, (%ebp,%ecx,1)
	decl %ecx
	cmpl $0, %eax
	jnz _for42
	
	_inttostr_2 bin

	pop %esi
	pop %ebx
	leave
	ret

# Convert unsigned integer to hexadecimal string
hextostr:
	push %ebp
	movl %esp, %ebp
	subl $16, %esp	# Local array
	_inttostr_1 $16

	# Divide number by 16 and store remainders into local array (index is ecx)
_for41:
	xorl %edx, %edx
	divl %esi
	cmpl $9, %edx
	jle _dec
	addb $7, %dl	# correct for HEXA characters (A-F)
_dec:	addb $48, %dl   # correct for HEXA and DEC characters
	movb %dl, (%ebp,%ecx,1)
	decl %ecx
	cmpl $0, %eax
	jnz _for41

	cmpl $1, no0x
	je _no0x
# Attach "0x" prefix before to indicate hexa. (here in reverse order)
	movb $120, (%ebp,%ecx,1)
	decl %ecx
	movb $48, (%ebp,%ecx,1)
	decl %ecx

_no0x:
	_inttostr_2 hex

	pop %esi
	pop %ebx
	leave
	ret

# string to integer conversion: first part
.macro _strtoint_1 base len id
	push %ebx
	push %esi

	movl 8(%ebp), %ebx
	movl \base, %esi

	push %ebx
	call strlen
	addl $4, %esp
        cmpl $0, %eax
        je _err_strto\id
	cmpl \len, %eax
	jbe _cont_strto\id

_err_strto\id:
	movl $-1, %eax
	jmp _end_strto\id
	
_cont_strto\id:
	xorl %ecx, %ecx
	xorl %eax, %eax
_start_strto\id:
	movzbl (%ebx,%ecx,1), %edx
	cmpl $0, %edx
	jz _end_strto\id
.endm

# Convert decimal string to integer (if possible)
# int strtoint(char *src);
strtoint:
	enter $0,$0
	_strtoint_1 $10 $10 int
	cmpl $48, %edx
	jb _err_strtoint
	cmpl $57, %edx
	ja _err_strtoint
	push %edx
	mull %esi
	pop %edx
	subl $48, %edx
	addl %edx, %eax
	incl %ecx
	jmp _start_strtoint

_end_strtoint:
	pop %esi
	pop %ebx
	leave
	ret

# Convert binary string to integer (if possible)
# int strtobin(char *src);
strtobin:
	enter $0,$0
	_strtoint_1 $2 $32 bin
	shrl %edx
	rcll %eax
	cmpl $24, %edx
	jb _err_strtobin
	incl %ecx
	jmp _start_strtobin

_end_strtobin:
	pop %esi
	pop %ebx
	leave
	ret

# Convert hexadecimal string to integer (if possible)
# int strtohex(char *src);
strtohex:
	enter $0,$0
	_strtoint_1 $16 $10 hex
	cmpl $48, %edx	# ascii 0
	jb _err_strtohex
	cmpl $57, %edx  # ascii 9
	jbe _num_strtohex
	cmpl $65, %edx  # ascii A
	jb _err_strtohex
	cmpl $70, %edx  # ascii F
	jbe _LTR_strtohex
        cmpl $88, %edx  # ascii X
	je _next_strtohex
	cmpl $97, %edx	# ascii a
	jb _err_strtohex
	cmpl $102, %edx	# ascii f
	jbe _ltr_strtohex
	cmpl $120, %edx # ascii x
	je _next_strtohex
	jmp _err_strtohex

_ltr_strtohex:
	subl $32, %edx	# correction for a-f letters
_LTR_strtohex:
	subl $7, %edx	# correction for A-F letters
_num_strtohex:
	push %edx
	mull %esi
	pop %edx
	subl $48, %edx
	addl %edx, %eax
_next_strtohex:
	incl %ecx
	jmp _start_strtohex

_end_strtohex:
	pop %esi
	pop %ebx
	leave
	ret

# convert 32-bit value to string
regtostr:
	enter $0,$0
	movl 8(%ebp), %eax
	movl 12(%ebp), %edx
	movl $4, %ecx
_rts_rep:
	movb %al, (%edx)
	shrl $8, %eax
	incl %edx
	decl %ecx
	jnz _rts_rep
	movb $0, (%edx)
	movl 12(%ebp), %eax
	leave
	ret

#
pad_right:
	push %ebp
	movl %esp, %ebp

	push %ebx
	push %esi
	movl 8(%ebp), %esi
	movl 12(%ebp), %ebx
	push %ebx
	call strlen
	addl $4, %esp
	subl %eax, %esi
	js _end_pad
	jz _end_pad
	movl %ebx, %edx
	addl %esi, %edx
	incl %eax
	
_for6:
	decl %eax
	movb (%ebx,%eax,1), %cl
	movb %cl, (%edx,%eax,1)
	test %eax, %eax
	jnz _for6

	movl 16(%ebp), %eax
_for7:
	decl %esi
	movb %al, (%ebx,%esi,1)
	test %esi, %esi
	jnz _for7

_end_pad:
	movl %ebx, %eax

	pop %esi
	pop %ebx
	leave
	ret

# Wait for keypress and return its scan-code (only press events, with prefixes)
readkey:
	xor %ecx,%ecx
_read_key:
	call empty_8042
	xor %eax, %eax
	inb $0x60, %al
	cmpb $0xE0, %al
	jne _read_key_c1
	movb $1, %cl
	call empty_8042
	xor %eax, %eax
	inb $0x60, %al
	cmpb $0x7F, %al
	ja readkey
	movb %cl, %ah
	ret
_read_key_c1:
	cmpb $0x7F, %al
	ja _read_key
	ret

# Wait for enter key to be pressed
read_enter:
	# Put the register-debug window procedure here, so it gets refreshed rapidly
	call okno_reg
_read_enter:
	call readkey
	cmpb $28, %al
	jne _read_enter
	ret

# Internal function - poll for key press
empty_8042:
	.word	0x00eb,0x00eb
	inb	$0x64, %al	# 8042 status port
	testb	$1, %al		# is output buffer empty?
	jz	empty_8042	# yes - loop
	ret

# read keyboard scan code and translate into ASCII char
read_char:
	push %ebx
	lea scan2ascii, %ebx
_for8:
	call readkey
	cmpb $28, %al
	je _read_char_c1
	cmpb $0, %ah
	jne _for8
_read_char_c1:
	xlatb
	cmpb $0, %al
	je _for8
	andl $0xFF, %eax
	pop %ebx
	ret

# Only translate the provided byte to ascii
xlat_char:
	enter $0,$0
	push %ebx
	movzwl 8(%ebp), %eax
	cmpb $0, %ah
	je _xlat_char_c1
	xor %al, %al
	jmp _xlat_char_end
_xlat_char_c1:
	lea scan2ascii, %ebx
	xlatb
_xlat_char_end:
	pop %ebx
	leave
	ret

# char *read_string(char *dest, int size);
# read characters into <dest> until enter pressed or <size> characters was read
read_string:
	push %ebp
	movl %esp, %ebp

	push %ebx
	push %esi
	movl 8(%ebp), %ebx
	movl 12(%ebp), %ecx
	xorl %edx, %edx

_start_read_string:
	push %ecx
	push %edx
	call read_char
	pop %edx
	pop %ecx
	cmpb $28, %al
	je _end_read_string
	cmpb $1, %al
	je _esc_read_string
	cmpb $14, %al
	jne _cont_read_string
	cmpl $0, %edx
	je _start_read_string
	movl pos_x, %esi
	cmpl $0, %esi
	je _start_read_string
	decl %esi
	movl %esi, pos_x
	push %edx
	push %ecx
	push %ebx
	subl $4, %esp
	movl $32, (%esp)
	call put_char
	addl $4, %esp
	movl %esi, pos_x
	movl %esi, %ebx
	movl pos_y, %edx
	call move_cursor
	pop %ebx
	pop %ecx
	pop %edx
	decl %edx
	jmp _start_read_string
	
_cont_read_string:
	movb %al, (%ebx,%edx,1)

	push %edx
	push %ecx
	push %eax
	call put_char
	addl $4, %esp
	pop %ecx
	pop %edx

	incl %edx
	cmpl %edx, %ecx
	jg _start_read_string
	jmp _end_read_string

_esc_read_string:
	xorl %edx, %edx
_end_read_string:
	movb $0, (%ebx,%edx,1)
	movl %ebx, %eax

	pop %esi
	pop %ebx
	leave
	ret

# min and max functions
# both have 2 parameters
min:
	enter $0,$0
	movl 8(%ebp), %eax
	movl 12(%ebp), %ecx
	cmpl %eax, %ecx
	ja _min_end
	movl %ecx, %eax
_min_end:
	leave
	ret

max:
	enter $0,$0
	movl 8(%ebp), %eax
	movl 12(%ebp), %ecx
	cmpl %eax, %ecx
	jbe _max_end
	movl %ecx, %eax
_max_end:
	leave
	ret

scan2ascii:
	.ascii "\000\0011234567890-=\016\000QWERTYUIOP[]\034\000AS"
	.ascii "DFGHJKL;'`\000\\ZXCVBNM,./\000*\000 \000\000\000\000\000\000"
	.ascii "\000\000\000\000\000\000\000789-456+1230."
	.fill 44,1,0
