// Prot386 Debuging functions
// (C) 2006-2007 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

#include "prototypes.h"

char *reg_names[10] = {"GDTR ","LDTR ","IDTR ","TR   ","CR2  ","CR3  ","CS   ","DS   ","SS   "};
char *reg_parts[3] = {"Base ","Limit ","Sel. "};
char *unknown = "Unknown\n";
char *dbg_dlg0 = "Converter\nHexadecimal\nDecimal\n";
char *dbg_dlg1 = "Hex value\n";
char *dbg_dlg2 = "Decimal value\n";
char *dbg_dlg3 = "Address Mapping\nLogical\nLinear\nPhysical\n";
char *dbg_dlg4 = "\nOffset\n(hexadecimal)\n";
char *dbg_dlg5 = "\nLin. Address\n(hexadecimal)\n";
char *dbg_dlg6 = "Soft protect\nTurn on (recommended)\nTurn off\nBack";

char *dbg_notfound  = "Not found";
char *dbg_invalid   = "Invalid addr.";
char *dbg_nolimit   = "Out of limit";
char *dbg_nopresent = "Not present";

extern int enforce_protect;

MEM_MAP *map;

/* window with the generic parameters */
void okno_ex(char *body) {
  okno(3, 45, 9, 3, 0x4F, "Exception", body);
}

#define ST_SIZE 8
/* stack-trace window */
void okno_st(int sp0, ...) {
  int sc;  // stack parameter count
  char body[ST_SIZE*30], tmps[11], tmps2[11];
  char desc[ST_SIZE][12];
  unsigned int sp[ST_SIZE];  // stack parameters
  __builtin_va_list list;

  body[0]='\0';
  desc[0][0]='\0';
  sp[0]=sp0;
  __builtin_va_start(list, sp0);
    for (sc=1; sc<ST_SIZE; sc++) {
      desc[sc][0]='\0';
      sp[sc] = __builtin_va_arg(list, int);
    }
  __builtin_va_end(list);
  for (sc=0; sc<ST_SIZE; sc++) {
    if (sp[sc] < 2048) strcat(desc[sc], " (", descriptor_name(sp[sc]), ")", 0);
    inttostr(sc*4, tmps);
    strcat(body, "[ESP+",pad_right(2,tmps, '0'),"] = ", hextostr(sp[sc], tmps2), desc[sc], "\n", 0);
  }
  okno(47, 79, 14, ST_SIZE, 0x4F, "Stack Dump", body);
}

/* Core registers window */
void okno_reg(void) {
  char body[10*27], tmps[11], tmps2[11];
  TR_STRUCT gdtr, idtr;
  DESCRIPTOR ldtr, tr;
  WINDOW old_win;
  int ldtr_sel, tr_sel, cr3, cr2, cpl, xs;

  body[0]='\0';
  load_gdtr(&gdtr);
  load_idtr(&idtr);
  ldtr_sel = load_ldtr();
  load_descriptor(ldtr_sel >> 3, (ldtr_sel >> 2) & 1, &ldtr);
  tr_sel = load_tr();
  load_descriptor(tr_sel >> 3, (tr_sel >> 2) & 1, &tr);
  cpl = getcpl();
  if (cpl == 0) {
    cr3 = load_pdbr();
    cr2 = load_cr2();
  } else {
    cr3 = 0;
    cr2 = 0;
  }

  strcat(body, "System registers:\n", 0);
  strcat(body, reg_names[0], 0);
  strcat(body, hextostr(gdtr.base,tmps), ",", hextostr(gdtr.limit,tmps2), "\n", 0);
  strcat(body, reg_names[2], 0);
  strcat(body, hextostr(idtr.base,tmps), ",", hextostr(idtr.limit,tmps2), "\n", 0);
  strcat(body, reg_names[1], 0);
  strcat(body, hextostr(ldtr.base,tmps), ",", hextostr(ldtr.limit,tmps2), ",", descriptor_name(ldtr.sel_min),"\n", 0);
  strcat(body, reg_names[3], 0);
  strcat(body, hextostr(tr.base,tmps), ",", hextostr(tr.limit,tmps2), ",", descriptor_name(tr.sel_min), "\n", 0);
  strcat(body, reg_names[4], 0);
  if (!cpl) strcat(body, hextostr(cr2,tmps), "\n", 0);
  else strcat(body, unknown, 0);
  strcat(body, reg_names[5], 0);
  if (!cpl) strcat(body, hextostr(cr3,tmps), "\n", 0);
  else strcat(body, unknown, 0);
  xs = getcs();
  strcat(body, reg_names[6], 0);
  strcat(body, hextostr(xs, tmps), ",", descriptor_name(xs), ", CPL ", inttostr(cpl, tmps2), "\n", 0);
  xs = getds();
  strcat(body, reg_names[7], 0);
  strcat(body, hextostr(xs, tmps), ",", descriptor_name(xs), "\n", 0);
  xs = getss();
  strcat(body, reg_names[8], 0);
  strcat(body, hextostr(xs, tmps), ",", descriptor_name(xs), "\n", 0);
  save_window(&old_win);
  okno(47, 79, 1, 10, 0x1F, "Registers", body);
  load_window(&old_win);
}

/* count the available memory, and return pointer to the map */
unsigned int memory(void) {
  MEM_MAP *m;
  unsigned int free = 0;
  int i;

  m = _memory_map;
  for (i = 0; i < m->size; i++) {
    free += (m->range[i].limit[0] >> 10);
    free += ((m->range[i].limit[1] & 0x3FF) << 22);
  }
  return free;
}

/* CPU info window */
void okno_cpuinfo(void) {
  char body[100], tmps[11];
  REGISTERS reg;
  unsigned int i,free;

  body[0]='\0';
  strcat(body, "CPU: ", 0);
  cpu_id(0, &reg);
  strcat(body, regtostr(reg.ebx, tmps), 0);
  strcat(body, regtostr(reg.edx, tmps), 0);
  strcat(body, regtostr(reg.ecx, tmps), "\n ", 0);

  for (i=2; i<=4; i++) {
    cpu_id(i+0x80000000, &reg);
    strcat(body, regtostr(reg.eax, tmps), 0);
    strcat(body, regtostr(reg.ebx, tmps), 0);
    strcat(body, regtostr(reg.ecx, tmps), 0);
    strcat(body, regtostr(reg.edx, tmps), 0);
  }
  free = memory();
  map = _memory_map;
  strcat(body, "\nMemory: ", inttostr(free, tmps), " kB\n", 0);
  okno(10,62,10,3,0x1F,"System Information",body);
  _read_enter();
}

void cpuid_any(void) {
  char tmps[120], temp[40], temp2[15];
  int id_num;
  REGISTERS r;

  tmps[0]='\0'; temp[0]='\0'; temp2[0]='\0';
  id_num = HEXDIALOG(1,"CPUID\n");
  cpu_id(id_num,&r);
  strcat(tmps, "EAX = ", hextostr(r.eax, temp), " ", regtostr(r.eax, temp2), "\n", 0);
  strcat(tmps, "EBX = ", hextostr(r.ebx, temp), " ", regtostr(r.ebx, temp2), "\n", 0);
  strcat(tmps, "ECX = ", hextostr(r.ecx, temp), " ", regtostr(r.ecx, temp2), "\n", 0);
  strcat(tmps, "EDX = ", hextostr(r.edx, temp), " ", regtostr(r.edx, temp2), "\n", 0);
  okno(21,48,6,5,0x1F,"CPUID",tmps);
  _read_enter();
}

void converter(void) {
  static unsigned int num = 0;
  char temp[12];
  int ch;
  int c1 = 0x30;
  int c2 = 0x03;
  int ht = 0;
  int olda;

  do {
    okno(21,48,6,2,c1,0,dbg_dlg0);
    olda = textattr;
    textattr = c1;
    gotoxy(35,7);
    write(pad_right(12, hextostr(num, temp), ' '));
    gotoxy(35,8);
    write(pad_right(12, inttostr(num, temp), ' '));
    do {
      highlight(35,46,7+ht,c2);
      highlight(35,46,8-ht,c1);
      ch=readkey();
      switch(ch) {
        case K_UP:
        case K_DOWN: ht=1-ht; break;
	case K_ESC: textattr = olda; return;
      }
    } while ((ch&255) != K_ENTER);

    save_screen();
    switch (ht) {
      case 0: num = HEXDIALOG(1,dbg_dlg1); break;
      case 1: num = DIALOG(1,dbg_dlg2); break;
    }
    load_screen();
  } while (1);
  textattr = olda;
  return;
}

// reused functions from hex.c
extern int ed_seg3(void);
extern unsigned int ed_paddr(void);

unsigned int ed_ofs4(char *dlgitem) {
  unsigned int val;
  char temp[12];
  val = HEXDIALOG(3, dlgitem);
  if (val == -1) return 0;
  return val;
}

void mapping(void) {
  static int log_s = 0x10;
  static unsigned int log_o = 0;
  static unsigned int lin = 0;
  static unsigned int phy = 0;
  static int log_valid = ADDR_OK;
  static int lin_valid = ADDR_OK;
  static int phy_valid = ADDR_OK;
  char temp[16], tmp2[12];
  int ch;
  int c1 = 0x30;
  int c2 = 0x03;
  int ht = 0;
  int olda;

  do {
    okno(21,47,6,3,c1,0,dbg_dlg3);
    olda = textattr;
    textattr = c1;

    no0x = 1;
    pad_right(4, hextostr(log_s,temp), '0');
    pad_right(8, hextostr(log_o,tmp2), '0');
    no0x = 0;
    strcat(temp, ":", tmp2, 0);
    gotoxy(33,7);
    switch (log_valid) {
      case ADDR_OK: write(temp); break;
      case ADDR_NOTFOUND: write(dbg_notfound); break;
    }
    gotoxy(33,8);
    switch (lin_valid) {
      case ADDR_OK: write(pad_right(13, hextostr(lin, temp), ' ')); break;
      case ADDR_NOTFOUND: write(dbg_notfound); break;
      case ADDR_INVALID: write(dbg_invalid); break;
      case ADDR_OUTOFLIMIT: write(dbg_nolimit); break;
    }
    gotoxy(33,9);
    switch (phy_valid) {
      case ADDR_OK: write(pad_right(13, hextostr(phy, temp), ' ')); break;
      case ADDR_NOTFOUND: write(dbg_notfound); break;
      case ADDR_INVALID: write(dbg_invalid); break;
      case ADDR_OUTOFLIMIT: write(dbg_nolimit); break;
      case ADDR_NONPRESENT: write(dbg_nopresent); break;
    }

    do {
      highlight(32,45,7,c1);
      highlight(32,45,8,c1);
      highlight(32,45,9,c1);
      highlight(32,45,7+ht,c2);
      ch=readkey();
      switch(ch) {
        case K_UP: ht-=1; if (ht < 0) ht=2; break;
        case K_DOWN: ht+=1; if (ht > 2) ht=0; break;
	case K_ESC: textattr = olda; return;
      }
    } while ((ch&255) != K_ENTER);

    save_screen();
    switch (ht) {
      case 0:
	log_valid = ADDR_OK;
	log_s = ed_seg3();
	log_o = ed_ofs4(dbg_dlg4);
	lin_valid = log2lin(log_s, log_o, &lin);
	if (lin_valid == ADDR_OK)
	  phy_valid = lin2phys(lin, &phy);
	else
	  phy_valid = lin_valid;
	break;
      case 1:
	lin_valid = ADDR_OK;
	lin = ed_ofs4(dbg_dlg5);
	log_valid = lin2log(lin, &log_s, &log_o);
	phy_valid = lin2phys(lin, &phy);
	break;
      case 2:
	phy_valid = ADDR_OK;
	phy = ed_paddr();
	lin_valid = phys2lin(phy, &lin);
	if (lin_valid == ADDR_OK)
	  log_valid = lin2log(lin, &log_s, &log_o);
	else
	  log_valid = lin_valid;
	break;
    }
    load_screen();
  } while (1);
  textattr = olda;
  return;
}

char *cred_text = "\
The Credits\n\
Prot386\n\
Version 2.0\n\
Author: Peter Ambroz\n\
Thanks to: RNDr. Jaroslav Janacek\n\
Purpose: Real simulator of Intel-family CPU properties and behaviour\
         in 386 protected mode. Created for educational purposes.\n\
History:\n\
 2004/2005 - First idea of doing some kind of application like this.\
 Nov 2006 - Registered as a bachelor's thesis at FMFI-UK.\n\
 May 2007 - Version 1.0 is capable of manipulating descriptors,\n\
   executing sample code, has interrupt handlers and also some bugs.\
 Nov 2007 - Registered as a master's thesis.\n\
 Apr 2009 - Finishing version 2.0\n\
\n\
Program is free, distributed under GNU GPL license.\
";

void credits(void) {
  save_screen();
  poz(0,0);
  okno(4,75,4,15,0x20,0,cred_text);
  _read_enter();
  load_screen();
  return;
}

char *bigwarn = "\
Big Warning!!!\n\
  Data protection prevents you from modifying essential\
kernel descriptors (GDT0 - GDT6), creating own segments\
inside kernel memory (0-2 MB), and changing the page\n\
mapping, which must be 1:1 in the kernel memory region.\
  Turning off the soft protection in this program could\
result in unpredictable behaviour and data corruption.\n\
  On the other hand it allows you to experiment\n\
with everything.\n\
Please bear in mind that freedom means responsibility!\
";

extern char *main_down;

void data_protect(void) {
  int what;

  poz(0,0);
  okno(11,69,3,9,0x74,0,bigwarn);
  _read_enter();
  what = menu(25,55,14,0,112,1,0,AL_LEFT,dbg_dlg6, 0);
  switch (what) {
    case 1: enforce_protect = 1; main_down[55] = '\0'; break;
    case 2: enforce_protect = 0; main_down[55] = ' '; break;
  }
}
