// Prot386 Execution
// (C) 2006-2007 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

#include "prototypes.h"

char *s3 = "Execute Code\nSetup\nStart!\nBack";

char *e_types[2] = {"CALL", "JMP"};
extern char *sys_types[];
extern char *user_types[];
extern char *user_flags[][4];
extern char *bit_sizes[];
extern char *dt0[];

char *nocall = "Warning\nOnly code segments can be called.\nPress enter";
char *nolimit = "Warning\nDestination segment limit too low.\nExpect faults or hard resets.\nLimit should be at least \0           ";

extern char *dlg0;
extern char mnu1[];
char *mnu4 = "\nCALL\nJMP";

// modules.c
extern char *mod_list[];
extern void (*mod_fn[])();
extern int setup;

// descriptors.c
extern void ed_flags(DESCRIPTOR *d1, int action);
extern void ed_dpl(DESCRIPTOR *d1, int action);

extern char info[];
extern int exec_old0; // From menu.c
int exec_old1;

EX_PARAMS etmp = { E_CALL, TB_GDT, 7, 3, 3, 0, 0 };
DESCRIPTOR dtmp3, dtmp4;
MENU_STATE mtmp2, mtmp3;

char *parse_ex_params(EX_PARAMS *e1, char *info) {
  char tmps[11];

  if (info) info[0] = '\0';
  strcat(info, "Exec parameters", 0);
  strcat(info, "\nType: ", e_types[e1->type], 0);
  strcat(info, "\nSegment: ", descriptor_name(8*e1->index + 4*e1->dti), 0);
  strcat(info, "\nCaller CPL: ", inttostr(e1->cpl, tmps), 0);
  strcat(info, "\nCalled RPL: ", inttostr(e1->rpl, tmps), 0);
  strcat(info, "\nModule: ", mod_list[e1->module], 0);

  if (info) e1->pc = mod_setup(e1->module, -1);
  if (hide_code) return info; // Info about called segment can be suppressed
  strcat(info, "\n-- Called Segment Info --\nType: ", 0);

  // Info about called segment
  load_descriptor(e1->index, e1->dti, &dtmp3);
  if ((!dtmp3.s) && (!dtmp3.type)) {
    strcat(info, "Invalid Descriptor", 0);
    return info;
  }
  if (dtmp3.s) {
    strcat(info, user_types[dtmp3.type<8?0:1], bit_sizes[dtmp3.d], 0);
    strcat(info, "\nFlags: ", user_flags[dtmp3.type<8?0:1][(dtmp3.type>>1)&0x03], 0);
  } else strcat(info, sys_types[dtmp3.type], 0);
  strcat(info, "\nDPL: ", inttostr(dtmp3.dpl, tmps), 0);

  // Info about segment called by gate
  if ((!dtmp3.s) && (((dtmp3.type >> 2)&0x01) == 1) && (dtmp3.type != 13))
  { // Descriptors with segment field (system, bit 2 in type flags set)
    load_descriptor(dtmp3.seg >> 3, (dtmp3.seg >> 2)&0x01, &dtmp4);
    strcat(info, "\n-- Segment pointed by the gate --\nType: ", 0);
    if ((!dtmp4.s) && (!dtmp4.type)) {
      strcat(info, "Invalid Descriptor", 0);
      return info;
    }
    dtmp3.ofs = (int)mod_fn[e1->module];
    store_descriptor(&dtmp3);
    if (dtmp4.s) {
      strcat(info, user_types[dtmp4.type<8?0:1], bit_sizes[dtmp4.d], 0);
      strcat(info, "\nFlags: ", user_flags[dtmp4.type<8?0:1][(dtmp4.type>>1)&0x03], 0);
    } else strcat(info, sys_types[dtmp4.type], 0);
    strcat(info, "\nDPL: ", inttostr(dtmp4.dpl, tmps), 0);
  } else {
    dtmp4 = dtmp3;
  }

  return info;
}

void ed_etype(EX_PARAMS *e1) {
  int et;
  et = e1->type + 1;
  et = menu(22, 31, 7, 2, 48, et, 0, AL_LEFT, mnu4, 0);
  if (et == -1) return;
  e1->type = et - 1;
}

void ed_seg2(EX_PARAMS *e1) {
  int val, dt;
  dt = e1->dti + 1;
  dt = menu(22, 31, 7, 2, 48, dt, 0, AL_LEFT, mnu1, 0);
  switch (dt) {
    case -1: val = -1; break;
    case 1: val = menu_ex(32, 69, 7, 8, 48, &mtmp2, 256, dt0[0], summary, 0); break;
    case 2: val = menu_ex(32, 69, 7, 8, 48, &mtmp2, 256, dt0[1], lsummary, 0); break;
  }
  if (val == -1) return;
  e1->dti = dt - 1;
  e1->index = val;
}

void ed_cpl(EX_PARAMS *e1) {
  int val;
  char temp[12];
  val = DIALOG(2, dlg0);
  if ((val < 0) || (val > 3)) return;
  e1->cpl = val;
}

void ed_rpl(EX_PARAMS *e1) {
  int val;
  char temp[12];
  val = DIALOG(2, dlg0);
  if ((val < 0) || (val > 3)) return;
  e1->rpl = val;
}

void ed_mod(EX_PARAMS *e1) {
  int val;
  mtmp3.ht = 1; mtmp3.it = 0;
  val = menu_ex(22, 47, 7, mod_count > 8?8:mod_count, 48, &mtmp3, mod_count, "Modules", mod_iterate, mod_info_display);
  if (val < 0) return;
  e1->module = val;
//  mod_setup(val);
}

void execute(void)
{
  char tmps[11];
  int o8;

  do {
    switch(exec_old0=menu(menu_x,55,menu_y,0,112,exec_old0,0,AL_LEFT,s3, 0)) {
      case 1:
	save_screen();
	exec_old1 = 1;
	mtmp2.ht = 1; mtmp2.it = 0;
	do {
	  poz(0,0);
	  parse_ex_params(&etmp, info);
          o8=menu(20,59,4,5,112,exec_old1,0,AL_LEFT,info, 0);
	  exec_old1 = o8;
	  if (exec_old1 == -1) break;
	  switch (o8) {  // serve first 5 constant entries in menu
	    case 1: ed_etype(&etmp); break;
	    case 2: ed_seg2(&etmp); break;
	    case 3: ed_cpl(&etmp); break;
	    case 4: ed_rpl(&etmp); break;
	    case 5: ed_mod(&etmp); break;
          }
	  if (o8 > 5) {
	    o8 -= 5;
	    if (etmp.pc >= o8) {
	      mod_setup(etmp.module, o8);
	      continue;
	    }
	    if (hide_code) {
	      continue;
	    }
	    o8 -= etmp.pc;
	    switch (o8) {
	      case 3: if (dtmp3.s) ed_flags(&dtmp3, EDIT);
		      else ed_dpl(&dtmp3, EDIT);
		      store_descriptor(&dtmp3);
		      break;
	      case 4: if (dtmp3.s) { ed_dpl(&dtmp3, EDIT); store_descriptor(&dtmp3); } break;
	      case 6: if (dtmp4.s) ed_flags(&dtmp4, EDIT);
		      else ed_dpl(&dtmp4, EDIT);
		      store_descriptor(&dtmp4);
		      break;
	      case 7: ed_dpl(&dtmp4, EDIT); store_descriptor(&dtmp4); break;
	    }
	  }
	} while (1);
	load_screen();
	break;
      case 2:
	save_screen();
	dtmp4.type = 0; dtmp4.s = 0;
	load_descriptor(etmp.index, etmp.dti, &dtmp3); // Load the called descriptor
	if ((!dtmp3.s) && (((dtmp3.type >> 2)&0x01) == 1) && (dtmp3.type != 13))
	{ // Descriptors with segment field (system, bit 2 in type flags set)
	  load_descriptor(dtmp3.seg >> 3, (dtmp3.seg >> 2)&0x01, &dtmp4); // Load the descriptor called through gate
	  dtmp3.ofs = (int)mod_fn[etmp.module]; // Modify offset in the gate
	  store_descriptor(&dtmp3);
	} else dtmp4 = dtmp3;  // dtmp4 is our working segment descriptor

	if (dtmp4.s) {
	  if (dtmp4.limit < (int)&mod_end) { // Code doesn't fit into segment
	    strcat(nolimit, hextostr((int)&mod_end, tmps), 0);
	    okno(4, 44, 4, 3, 116, 0, nolimit);
	    read_enter();
	  }
          _memcpy(0, 0, (void *)dtmp4.base, (void *)0, (int)&mod_end); // Copy whole kernel memory into called segment
	  tss_prep(etmp.type==E_CALL?0x9A:0xEA, etmp.index*8+etmp.dti*4+etmp.rpl, (int)mod_fn[etmp.module], etmp.cpl);
	  gotoxy(64, 24);
	  textattr=0xF4;
	  write("Performing ");
	  write(e_types[etmp.type]);

	  tss_call();
	} else {
	  okno(22, 58, 10, 2, 116, 0, nocall);
	  read_enter();
	}
	load_screen();
	break;
      case 3:
      case -1: return;
    }
  } while (1);
  return;
}
