// Prot386 Memory Hex viewer / editor
// (C) 2008-2009 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

#include "prototypes.h"

char *hex_s0 = "Hex Editor\nBy Segment:Offset\nBy Linear address\nBy Physical address\nBack";
char *hx_title = "Hex Editor";
char *hx_noedit = "Error\nThis segment has no data";
char *hx_notfound = "Error\nReverse mapping not found";
char *hx_dlg0 = "\nStarting offset\n(hexadecimal)\n";
char *hx_dlg1 = "\nPhys. Address\n(hexadecimal)\n";
char *hx_nomodify = "Warning\nKernel memory (0-2MB)\ncan not be modified.\nChange will be dropped.";
int hex_old0;
int src_seg, src_sel, src_tab;
unsigned char hx_buf[17];
extern char mnu1[];
extern char *dt0[];
extern unsigned int mem_protect;
extern int enforce_protect;

DESCRIPTOR hx_dtmp;

int ed_seg3(void) {
  int val, dt;
  dt = menu(22, 31, 7, 2, 48, 1, 0, AL_LEFT, mnu1, 0);
  switch (dt) {
    case -1: val = -1; break;
    case 1: val = menu_ex(32, 69, 7, 8, 48, NULL, 256, dt0[0], summary, NULL); break;
    case 2: val = menu_ex(32, 69, 7, 8, 48, NULL, 256, dt0[1], lsummary, NULL); break;
  }
  if (val == -1) return 0;
  return (val << 3) + ((dt-1) << 2);
}

unsigned int ed_ofs3(void) {
  unsigned int val;
  char temp[12];
  val = HEXDIALOG(3, hx_dlg0);
  if (val == -1) return 0;
  return val;
}

unsigned int ed_paddr(void) {
  unsigned int val;
  char temp[12];
  val = HEXDIALOG(3, hx_dlg1);
  if (val == -1) return 0;
  return val;
}

char *getmemline(unsigned int src_ofs, char *data) {
  int max_n=16, i;
  char tmps[12], tmps2[12];

  data[0] = '\0';
  src_ofs <<= 4;
  _memcpy(0, src_seg==0x10?0:src_seg, hx_buf, (void *)src_ofs, max_n);
  no0x = 1;
  strcat(data, pad_right(4, hextostr(src_seg, tmps), '0'), ":", pad_right(8, hextostr(src_ofs, tmps2), '0'), "  ", 0);
  for (i=0; i<8; i++) {
    strcat(data, pad_right(2, hextostr(hx_buf[2*i], tmps), '0'), pad_right(2, hextostr(hx_buf[2*i+1], tmps2), '0'), " ", 0);
  }
  for (i=0; i<16; i++) {
    if ((hx_buf[i] == '\0') || (hx_buf[i] == '\n')) hx_buf[i] = ' ';
  }
  hx_buf[16] = '\0';
  strcat(data, " ", hx_buf, 0);
  no0x = 0;
  return data;
}

void hl(int x1, int x2, int y, int a, int b, int c1, int c2) {
  int st, en, ln;

  st = x1+17+((5*a)/2);
  en = st+1;
  ln = y+b;
  highlight(x1+1, x2-1, ln-1, c2);
  highlight(x1+1, x2-1, ln+1, c2);
  highlight(x1+1, x2-1, ln, c2);
  highlight(st, en, ln, c1);
  st = x1+58+a;
  highlight(st, st, ln, c1);
}

void wr_data(int a, int b, char *data) {
  int st;

  st = 15+((5*a)/2);
  gotoxy(st, b-1);
  write(data);
}


// Hexeditor with scrolling
void hex_edit(unsigned int src_ofs)
{
  int lng;
  int ht=1,it=0,lp=0;
  int i,x;
  int ch, ch2, scroll;
  int ephase=0;
  unsigned int eaddr, laddr;
  char edata[3] = {'0', '0', '\0'};
  char tmps[80];

  int x1=2, x2=77, y=5;
  int lines=16, color=112, items;

  poz(0,0);

  src_sel = src_seg >> 3;
  src_tab = (src_seg >> 2)&1;
  load_descriptor(src_sel, src_tab, &hx_dtmp);
  if (!hx_dtmp.s) {
    okno(20, 49, 6, 1, 116, 0, hx_noedit);
    _read_enter();
    return;
  }
  items = hx_dtmp.limit >> 4;

  it = src_ofs >> 4;

  textattr = color;
  window(x1, y, x2, y+lines+2);
  lng = (x2-x1)+1;

  header(lng, hx_title);
  emptylines(lng, lines);
  footer(lng);

  scroll = 1;

  do {
   if (lp < 0) { lp = 15; ht--; }
   if (lp > 15) { lp = 0; ht++; }
   if (ht < 1) { ht = 1; it--; scroll = 1; }
   if (ht > lines) { ht = lines; it++; scroll = 1; }
   while (it < 0) it+=items;
   while (it >= items) it-=items;

   if (scroll) {
     window(x1+2, y+1, x2-2, y+lines+1);
     for (i=0; i < lines; i++)
       write(getmemline((it+i)%items,tmps));
   }

   scroll = 0;

   hl(x1,x2,y,lp,ht,31,color);
   ch=readkey();
   ch2 = xlat_char(ch);
   if (((ch2 >= '0') && (ch2 <= '9')) || ((ch2 >= 'A') && (ch2 <= 'F'))) {
     switch (ephase) {
       case 0:
       case 1:
	 ephase++;
       case 2:
	 edata[0]=edata[1];
	 edata[1]=ch2;
	 break;
     }
     wr_data(lp,ht,edata);
     continue;
   }
   if (ephase) {
     ephase=0;
     x=strtohex(edata);
     edata[0]='0'; edata[1]='0';
     // commit 1 changed byte into memory
     eaddr = ((it+ht-1)<<4)+lp;
     if (log2lin(src_seg, eaddr, &laddr) != ADDR_OK) continue;
     if (enforce_protect) {
      if ((laddr <= 0xA0000) || ((laddr >= 0xC0000) && (laddr <= mem_protect))) {
        okno(13, 45, 6, 3, 116, 0, hx_nomodify);
        scroll = 1;
        _read_enter();
        continue;
      }
     }
     _memcpy(src_seg==0x10?0:src_seg, 0, (void *)eaddr, &x, 1);
     if ((x==0) || (x==10)) x=32;
     gotoxy(56+lp, ht-1);
     put_char((char)x);
   }
   
   switch(ch) {
     case K_UP: ht--; break;
     case K_DOWN: ht++; break;
     case K_LEFT: lp--; break;
     case K_RIGHT: lp++; break;
     case K_PGUP: it-=lines; scroll=1; break;
     case K_PGDN: it+=lines; scroll=1; break;
     case K_ESC: break;
   }
  } while (ch != K_ESC);
  window(0,0,79,24);
}

void hexeditor_menu(void) {
  unsigned int laddr;

  hex_old0 = 1;
  do {
    save_screen();
    switch(hex_old0=menu(menu_x,61,menu_y,0,112,hex_old0,0,AL_LEFT,hex_s0, 0)) {
      case 1:
	src_seg = ed_seg3();
	hex_edit(ed_ofs3());
	break;
      case 2:
	src_seg = 0x10;
	hex_edit(ed_ofs3());
	break;
      case 3:
	src_seg = 0x10;
	if (phys2lin(ed_paddr(), &laddr) != ADDR_OK) {
	  okno(20, 49, 6, 1, 116, 0, hx_notfound);
	  _read_enter();
	  break;
	} else
	  hex_edit(laddr);
	break;
      case 4:
      case -1: load_screen(); return;
    }
    load_screen();
  } while (1);
  return;
}
