// Prot386 Modules
// (C) 2006-2007 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

/*
 * Executable call modules
 *
 * Every module occupies exactly one function without parameters.
 * Module can have some parameters. To manage them, module must respond to the global variable 'setup'.
 * setup == 0 is normal operation of module.
 * setup == -1 denotes that we want module to return its parameters as user-readable strings
 * setup >= 1 invokes change of selected parameter
 * Changing the setup variable is done through calling the mod_setup function (see the actual code).
 * mod_setup returns 0 everytime except when requested parameters list (setup == -1).
 *  mod_setup then returns number of lines written to info string in paramcount global variable.
 * Module can hide other info (about code segment) by setting hide_code to 1
 * Module is registered in 3 arrays:
 *  - void (*mod_fn[])() : pointers to the module functions
 *  - char *mod_list[] : short names of modules
 *  - char *mod_desc[] : longer (max 65 chars) description of module function.
 * Descriptions are displayed through mod_info_display calback.
 * Names are enumerated by mod_iterate iterator function.
 * init_modules should be called before starting the work with modules to set the mod_count variable correctly
 */

#include "prototypes.h"

char *mod_list[] = {"Soft Interrupt", "Show CPL", "Data Access", "*"};
void (*mod_fn[])();
char *mod_desc[] = {"Invoke interrupt handler by executing the software int","Show the CPL after CALL/JMP",
		    "Perform different accesses to the selected descriptors"};

char msg1[48] = "Info\nExecution successful\nRunning at CPL = \0 ";
char *msg2 = "Info\nSegment successfuly accessed";
char temp[11], tmps[11];

char *dlg4 = "\nEnter int no.\n";
char *a_types[2] = {"Read","Write"};
char *mnu6 = "\nRead\nWrite";
extern char *sys_types[];
extern char *user_types[];
extern char *user_flags[][4];
extern char *bit_sizes[];
extern char *dlg1;
extern char *dt0[];
extern char info[];

extern EX_PARAMS etmp;
extern void ed_seg2(EX_PARAMS *);
extern void ed_flags(DESCRIPTOR *d1, int action);
extern void ed_dpl(DESCRIPTOR *d1, int action);

int mod_count;
int setup = 0;	// Indicate that we want to call setup routine of the module
int paramcount = 0;
int hide_code = 0; // Enable or disable displaying code segment properties

DESCRIPTOR dtmp5, dtmp6;

void init_modules(void) {
  int i;

  mod_count = 0;
  i = 0;
  while (mod_list[i][0] != '*') i++;
  mod_count = i;
}

char *mod_iterate(int sel, char *data) {
  data[0]='\0';
  if (!mod_count) { return data; }
  sel%=mod_count;
  strcat(data, mod_list[sel], 0);

  return data;
}

void mod_info_display(int num) {
  int i, ot;
  WINDOW old_win;

  ot = textattr;
  save_window(&old_win);
  window(0,0,79,24);
  gotoxy(0,23);
  textattr = 112;
  write(" Module info: ");
  write(mod_desc[num]);
  for (i=0; i<(66-strlen(mod_desc[num])); i++) write(" ");
  load_window(&old_win);
  textattr = ot;
}

int mod_setup(int mnum, int snum) {
  setup = snum;
  paramcount = 0;
  mod_fn[mnum]();
  setup = 0;
  return paramcount;
}

void mod_sw_int() {
  static int intno = 0x1F;
  int val;

  switch(setup) {
  case 1:
    val = HEXDIALOG(2,dlg4);
    if ((val < 0) || (val > 255)) return;
    intno = val;
    return;
  case -1:
    hide_code = 0;
    strcat(info, "\nInt no.: ", hextostr(intno,temp), 0);
    paramcount = 1;
    return;
  case 0: break;
  default: return;
  }
  sw_int(intno);
  __asm__ __volatile__ ("iret");
}

void mod_showcpl() {
  int cpl;

  hide_code = 0;
  paramcount = 0;
  if (setup) return;
  cpl = getcpl();
  inttostr(cpl, temp);
  strcat(msg1, temp, 0);
  okno(16,42,8,2,31,0,msg1);
  read_enter();
  __asm__ __volatile__ ("iret");
}

void ed_atype(int *atype) {
  int val;
  val = *atype + 1;
  val = menu(22, 31, 7, 2, 48, val, 0, AL_LEFT, mnu6, 0);
  if (val == -1) return;
  *atype = val - 1;
}

void ed_dpl2(DESCRIPTOR *d1, DESCRIPTOR *d2) {
  ed_dpl(d1, EDIT);
  store_descriptor(d1);
  d2->dpl = d1->dpl;
  store_descriptor(d2);
}

void ed_offset(int *offset) {
  unsigned int val;
  val = HEXDIALOG(3, dlg1);
  *offset = val;
}

void mod_access() {
  static EX_PARAMS etmp2 = { E_CALL, TB_GDT, 8, 0, 0, 0, 0 };
  static int atype = 0;
  static int a_offset = 0;

  switch(setup) {
  case 1:
    ed_atype(&atype);
    return;
  case 2:
    ed_seg2(&etmp2);
    return;
  case 3:
    ed_offset(&a_offset);
    return;
  case 6:
    if (dtmp5.s) ed_flags(&dtmp5, EDIT);
    else ed_dpl2(&dtmp5, &dtmp6);
    store_descriptor(&dtmp5);
    return;
  case 7:
    if (dtmp5.s) ed_dpl2(&dtmp5, &dtmp6);
    return;
  case -1:
    paramcount = 5;
    hide_code = 1;
    strcat(info, "\n", a_types[atype], " Access", 0);
    strcat(info, "\nData segment: ", descriptor_name(8*etmp2.index + 4*etmp2.dti), 0);
    strcat(info, "\nData offset: ", hextostr(a_offset, tmps), 0);
    strcat(info, "\n-- Data Segment Info --\nType: ", 0);
    load_descriptor(etmp2.index, etmp2.dti, &dtmp5);
    load_descriptor(etmp.index, etmp.dti, &dtmp6);
//    dtmp6.dpl = dtmp5.dpl;
    dtmp6.dpl = etmp.cpl;
    store_descriptor(&dtmp6);

    if ((!dtmp5.s) && (!dtmp5.type)) {
      strcat(info, "Invalid Descriptor", 0);
      return;
    }
    if (dtmp5.s) {
      paramcount += 2;
      strcat(info, user_types[dtmp5.type<8?0:1], bit_sizes[dtmp5.d], 0);
      strcat(info, "\nFlags: ", user_flags[dtmp5.type<8?0:1][(dtmp5.type>>1)&0x03], 0);
    } else {
      strcat(info, sys_types[dtmp5.type], 0);
      paramcount += 1;
    }
    strcat(info, "\nDPL: ", inttostr(dtmp5.dpl, tmps), 0);

    return;
  case 0: break;
  default: return;
  }
  __asm__ __volatile__ ("\
    push %%fs\n\
    movw %%ax, %%fs\n\
    movb %%fs:(%%edx), %%al\n\
    jecxz _ac_end\n\
    movb $255, %%fs:(%%edx)\n\
    movb $0, %%fs:(%%edx)\n\
    movb %%al, %%fs:(%%edx)\n\
  _ac_end:\n\
    pop %%fs\n\
    ": : "eax"(etmp2.index*8+etmp2.dti*4+etmp.rpl),"ecx"(atype),"edx"(a_offset) );

  okno(16,48,8,1,31,0,msg2);
  read_enter();

  __asm__ __volatile__ ("iret");
}

void (*mod_fn[])() = {mod_sw_int, mod_showcpl, mod_access};

int mod_end;
