// Prot386 Menu functions
// (C) 2006-2007 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

#include "prototypes.h"

char *def_u = 0, *def_d = 0;
int menu_left_right = 0;
int menu_lr_dir;
extern int pos_x, pos_y;

void header(int lng, char *data) {
  int i,lft, rgt;

  rgt = lng-(strlen(data)+6);
  // strlen(data) == 0
  if (rgt == lng-6) {
    write("");
    for (i=0; i < lng-2; i++) write("");
    write("");
    return;
  }
  // strlen(data) == lng
  if (rgt == -6) {
    write(data);
    return;
  }

  lft = rgt / 2;
  rgt = rgt-lft;
  write("");
  for (i=0; i < lft; i++) write("");
  write(" ");
  write(data);
  write(" ");
  for (i=0; i < rgt; i++) write("");
  write("");
}

void emptylines(int lng, int count) {
  int i,j;

  for (i=0; i < count; i++) {
    write("");
    for (j=0; j < lng-2; j++) write(" ");
    write("");
  }
}

void footer(int lng) {
  int i;

  write("");
  for (i=0; i < lng-2; i++) write("");
  write("");
}

void poz(char *u, char *d)
{
  int i,l1,l2;

  if (!u) {
    if (!def_u) return;
    u = def_u;
  } else def_u = u;
  if (!d) {
    if (!def_d) return;
    d = def_d;
  } else def_d = d;
  textattr=1;
  clearchar=0xB0;
  clrscr();
  textattr=112;
  gotoxy(0,24);
  write(d);
  l1=80-strlen(d);
  for (i=0; i<l1; i++) write(" ");
  gotoxy(0,0);
  l1=(80-strlen(u))/2;
  l2=80-strlen(u)-l1;
  for (i=0; i<l1; i++) write(" ");
  write(u);
  for (i=0; i<l2; i++) write(" ");
  return;
}

char *next_text(char *current) {
  while ((*current != '\n') && (*current)) current++;
  return ++current;
}

int menu(int x1, int x2, int y, int minlines, int color, int defitem, int spacing, ALIGN align, char *texts, void (*callback)())
{
  static int ht=1;
  int h1,h2, items=0;
  int lng,lft,rgt;
  int i,j;
  int ch;

  if (defitem != -1) ht = defitem;
  use_eol = 1;
  i=0;
  while (texts[i]) {
    if (texts[i] == '\n') items++;
    i++;
  }
  textattr = color;
  window(x1, y, x2, y+items+spacing*(items+1)+2);
  lng = (x2-x1)+1;

  header(lng, texts);

  for (i=1; i <= items; i++) {
    texts = next_text(texts);
    switch(align) {
      case AL_CENTER:
        rgt = lng-(strlen(texts)+2);
        lft = rgt / 2;
        rgt = rgt-lft;
        break;
      default:
      case AL_LEFT:
        rgt = lng-(strlen(texts)+2);
        lft = 1;
        rgt = rgt-lft;
        break;
      case AL_RIGHT:
        lft = lng-(strlen(texts)+2);
        rgt = 1;
        lft = lft-rgt;
        break;
    }

    emptylines(lng, spacing);

    write("");
    for (j=0; j < lft; j++) write(" ");
    write(texts);
    for (j=0; j < rgt; j++) write(" ");
    write("");
  }

  if (items < minlines) emptylines(lng, (spacing+1)*(minlines-items));
  emptylines(lng, spacing);
  footer(lng);

  do {
   if (ht < 1) ht = items;
   if (ht > items) ht = 1;
   h1 = ht+1; if (h1 > items) h1 = 1;
   h2 = ht-1; if (h2 < 1) h2 = items;
   if (callback) callback(ht);
   highlight(x1+1, x2-1, y+h1*(spacing+1), color);
   highlight(x1+1, x2-1, y+h2*(spacing+1), color);
   highlight(x1+1, x2-1, y+ht*(spacing+1), 31);
   menu_lr_dir = 0;
   ch=readkey();
   switch(ch) {
     case K_UP: ht--; break;
     case K_DOWN: ht++; break;
     case K_LEFT: menu_lr_dir = K_LEFT; break;
     case K_RIGHT: menu_lr_dir = K_RIGHT; break;
     case K_ESC: ht = -1;
   }
   if (!menu_left_right) menu_lr_dir = 0;
  } while (((ch&255) != K_ENTER) && (ch != K_ESC) && (!menu_lr_dir));
  window(0,0,79,24);
  use_eol = 0;
  return ht;
}

// Menu with scrolling
int menu_ex(int x1, int x2, int y, int lines, int color, MENU_STATE *m, int items, char *title, char *(*getstr)(), void (*callback)() )
{
  int lng,h1,h2;
  static int ht=1,it=0;
  int i,j;
  int ch, scroll;
  char tmps[80];

  if (m) {
    ht = m->ht;
    it = m->it;
  }

  textattr = color;
  window(x1, y, x2, y+lines+2);
  lng = (x2-x1)+1;

  header(lng, title);
  emptylines(lng, lines);
  footer(lng);

  scroll = 1;

  do {
   if (ht < 1) { ht = 1; it--; scroll = 1; }
   if (ht > lines) { ht = lines; it++; scroll = 1; }
   if (it < 0) it+=items;
   if (it >= items) it-=items;

   if (scroll) {
     window(x1+2, y+1, x2-2, y+lines+1);
     for (i=0; i < lines; i++) {
       write(getstr(it+i,tmps));
       for (j=0; j < lng-(strlen(tmps)+4); j++) write(" ");
     }
   }

   scroll = 0;

   h1 = ht+1; if (h1 > lines) h1 = 1;
   h2 = ht-1; if (h2 < 1) h2 = lines;
   highlight(x1+1, x2-1, y+h1, color);
   highlight(x1+1, x2-1, y+h2, color);
   highlight(x1+1, x2-1, y+ht, 31);
   if (callback) callback((ht+it-1)%items);
   menu_lr_dir = 0;
   ch=readkey();
   switch(ch) {
     case K_UP: ht--; break;
     case K_DOWN: ht++; break;
     case K_LEFT: menu_lr_dir = K_LEFT; break;
     case K_RIGHT: menu_lr_dir = K_RIGHT; break;
     case K_ESC: h2 = -1;
   }
   if (!menu_left_right) menu_lr_dir = 0;
  } while (((ch&255) != K_ENTER) && (ch != K_ESC) && (!menu_lr_dir));
  window(0,0,79,24);

  if (m) {
    m->ht = ht;
    m->it = it;
  }

  return h2==-1?-1:(it+ht-1)%items;
}

void okno(int x1, int x2, int y, int lines, int color, char *head, char *body)
{
  int lng, oldattr;

  lng = (x2-x1)+1;
  oldattr = textattr;
  textattr = color;
  window(x1, y, x2, y+lines+2);

  if (!head) {
    if (!body) return;
    use_eol = 1;
    header(lng, body);
    body = next_text(body);
    use_eol = 0;
  } else
    header(lng, head);
  emptylines(lng, lines);
  footer(lng);

  if (body) {
    window(x1+2, y+1, x2-2, y+lines+1);
    write(body);
  }
  textattr = oldattr;
  window(0,0,79,24);
}

/* Dialog box with text string input */
char *dialog(int x1, int x2, int y, int lines, int color, char *texts, char *dest)
{
  int lng;

  lng = (x2-x1)+1;
  textattr = color;
  window(x1, y, x2, y+lines+2);

  use_eol = 1;
  header(lng, texts);
  texts = next_text(texts);
  use_eol = 0;
  emptylines(lng, lines);
  footer(lng);

  window(x1+2, y+1, x2-2, y+lines+1);
  write(texts);
  show_cursor();
  read_string(dest, x2-pos_x-1);
  hide_cursor();
  window(0,0,79,24);

  return dest;
}

/* Binary field editor */
int binfield_dialog(int x1, int x2, int y, int lines, int color, char *texts, int data)
{
  int lng;
  int bits = 32;
  int min_x,max_x,oy;
  int ht, h1, h2, ch;
  char tmps[33];

  lng = (x2-x1)+1;
  textattr = color;
  window(x1, y, x2, y+lines+2);

  use_eol = 1;
  header(lng, texts);
  texts = next_text(texts);
  use_eol = 0;
  emptylines(lng, lines);
  footer(lng);

  window(x1+2, y+1, x2-2, y+lines+1);
  write(texts);
  min_x = get_x(); oy = get_y();
  max_x = min_x + bits - 1;
  write(pad_right(bits, bintostr(data,tmps), '0'));

  show_cursor();
  ht = bits;
  do {
   if (ht < 1) ht = bits;
   if (ht > bits) ht = 1;
   h1 = ht+1; if (h1 > bits) h1 = 1;
   h2 = ht-1; if (h2 < 1) h2 = bits;
   gotoxy(min_x + ht - 1, oy);
   ch=readkey();
   switch(ch) {
     case K_LEFT:  ht--; break;
     case K_RIGHT:  ht++; break;
     case K_DOWN:
     case 82: // NUMPAD 0
     case 11: // KEYPAD 0
	put_char('0');
	tmps[ht-1] = '0';
	break;
     case K_UP:
     case 79: // NUMPAD 1
     case 2:  // KEYPAD 1
	put_char('1');
	tmps[ht-1] = '1';
	break;
     case K_ESC: ht = -1;
   }
  } while ((ch != K_ENTER) && (ch != K_ESC));
  window(0,0,79,24);
  hide_cursor();

  if (ht == -1) return data;
  ht = strtobin(tmps);
  if (ht == -1) return 0;
  return ht;
}
