# Prot386 Low-level Page manipulation
# (C) 2006-2009 Peter Ambroz
# This code is free software and is distributed under the terms of GNU GPL

.globl page_setup, load_pdbr, load_cr2
.globl invalidate_all, invalidate
.globl pxe_read, pxe_write

# Create 1 page directory with 2 page tables filled with all 1024 page entries
# thus covering the first 8MB of physical memory, 1:1 mapping from linear addresses.

page_setup:
	push %edi
	# Page directory
	# Setup first entry in page directory. Point it to the page table
	movl _page_table, %eax    # page table linear address 
	andl $0xFFFFF000, %eax    # align to 4kB boundary
	orl $0x7, %eax            # set User, Writable, Present flags
	movl _page_dir, %edi
	movl %eax, (%edi)

	addl $0x1000, %eax	  # next page table is +4kB after the current.
	addl $4, %edi		  # offset in page directory for the next entry
	movl %eax, (%edi)         # Fill first 2 entries as present

	movl $1022, %ecx	  # Rest entries will be non-present, but with initialized values
	decl %eax
_ps_rep0:
	addl $0x1000, %eax	  # next page table is +4kB after the current.
	addl $4, %edi		  # offset in page directory for the next entry
	movl %eax, (%edi)
	decl %ecx
	jnz _ps_rep0

	# Page tables no.0 and 1
	movl _page_table, %edi
	movl $7, %eax     # Initial physical address (0x0) + flags
	movl $0x40000, %ecx  # Nuber of pages (256x full page table)
_ps_rep1:
	movl %eax, (%edi)
	addl $0x1000, %eax  # Next page is 4kB higher
	addl $4, %edi       # Next page entry is 4B higher
	decl %ecx
	jnz _ps_rep1

	# Load the PDBR with physical address of page directory
	movl _page_dir, %eax
	andl $0xFFFFF000, %eax
	movl %eax, %cr3
	# Put the address also into current TSS
	movl _tss_base, %edi
	movl %eax, 28(%edi)	# CR3 field

	# Enable Paging and write protecting mechanism for pages
        # This will also flush all TLB caches
	movl %cr0, %eax
	orl $0x80010000, %eax
	movl %eax, %cr0

	pop %edi
	ret

load_pdbr:
	movl %cr3, %eax
	ret

load_cr2:
	movl %cr2, %eax
	ret

invalidate_all:
	movl %cr3, %eax
	movl %eax, %cr3
	ret

invalidate:
	enter $0,$0
	movl 8(%ebp), %eax
	shll $10, %eax
	addl 12(%ebp), %eax
	shll $12, %eax
	invlpg (%eax)
	leave
	ret

# Read the page entry. If index2 < 0, read the page dir entry. Else read page table entry
# Returns 0 if trying to read PTE from non-present PDE, else returns 1
# int pxe_read(int index1, int index2, int *data)
pxe_read:
	enter $0,$0
	push %edi
	movl 8(%ebp), %eax
	movl 12(%ebp), %ecx
	movl 16(%ebp), %edi
	movl _page_dir, %edx
	shll $2, %eax
	addl %eax, %edx
	movl (%edx), %eax
	movl %eax, 4(%edi)
	movl %eax, (%edi)

	cmpl $-1, %ecx
	je _pxe_read_success # Requested PDE (index2 == -1), returning PDE

	bt $0, %eax
	jnc _pxe_read_np  # PDE is non-present, thus returning invalid non-present PTE
	
	andl $0xFFFFF000, %eax
	movl %eax, %edx
	shll $2, %ecx
	addl %ecx, %edx
	movl (%edx), %eax
	movl %eax, (%edi)
	jmp _pxe_read_success  # Returned PTE

_pxe_read_np:
	xorl %eax, %eax  # return 0 on failure
	jmp _pxe_read_end

_pxe_read_success:
	xorl %eax, %eax
	incl %eax
	
_pxe_read_end:
	pop %edi
	leave
	ret

# Write the page entry. If index2 < 0, write the page dir entry. Else write page table entry
# Returns 0 if trying to write PTE into non-present PDE, else returns 1
# int pxe_write(int index1, int index2, int data)
pxe_write:
	enter $0,$0
	push %edi
	movl 8(%ebp), %eax
	movl 12(%ebp), %ecx
	movl 16(%ebp), %edx
	movl _page_dir, %edi
	shll $2, %eax
	addl %eax, %edi

	cmpl $-1, %ecx
	je _pxe_write_pde

	movl (%edi), %eax
	bt $0, %eax
	jnc _pxe_write_np  # PDE is non-present, thus returning invalid non-present PTE
	
	andl $0xFFFFF000, %eax
	movl %eax, %edi
	shll $2, %ecx
	addl %ecx, %edi

_pxe_write_pde:
	movl %edx, (%edi)
	xorl %eax, %eax
	incl %eax	# return 1 on success
	jmp _pxe_write_end

_pxe_write_np:
	xorl %eax, %eax # return 0 on failure
	
_pxe_write_end:
	pop %edi
	leave
	ret
