/* function headers */

#define NULL (void *)0

#define DIALOG(lines, data) strtoint(dialog(17, 36, 10, lines, 48, data, temp))
#define BINDIALOG(lines, data, init) binfield_dialog(10, 47, 10, lines, 48, data, init)
#define HEXDIALOG(lines, data) strtohex(dialog(17, 36, 10, lines, 48, data, temp))

#define K_LEFT 0x14B
#define K_RIGHT 0x14D
#define K_UP 0x148
#define K_DOWN 0x150
#define K_PGUP 0x149
#define K_PGDN 0x151
#define K_ENTER 0x1C
#define K_ENTER2 0x11C
#define K_ESC 1

/* crt.s */
typedef struct s_window {
  int textattr, clearchar;
  int px, py;
  int x1, y1, x2, y2;
  int use_eol;
} WINDOW;

extern void highlight(int x1, int x2, int y, int atr);
extern int textattr;
extern int clearchar;
extern int use_eol;
extern char *newl;
extern int no0x;
extern void clrscr(void);
extern void gotoxy(int x, int y);
extern int get_x(void);
extern int get_y(void);
extern void write(char *data);
extern void put_char(int ch);
extern void window(int x1, int y1, int x2, int y2);
extern void save_window(WINDOW *win);
extern void load_window(WINDOW *win);
extern void save_screen(void);
extern void load_screen(void);
extern void hide_cursor(void);
extern void show_cursor(void);
extern char *inttostr(int src, char *dest);
extern char *bintostr(int src, char *dest);
extern char *hextostr(int src, char *dest);
extern char *regtostr(int src, char *dest);
extern int strtoint(char *src);
extern int strtobin(char *src);
extern int strtohex(char *src);
extern char *pad_right(int num, char *dest, int padchar);
extern int readkey(void);
extern void read_enter(void);
extern void _read_enter(void);
extern int read_char(void);
extern int xlat_char(int ch);
extern char *read_string(char *dest, int size);
extern int min(int a, int b);
extern int max(int a, int b);

/* string.c */
extern int strlen(char *data);
extern char *strcat(char *dest, ...);

/* mymenu.c */
typedef enum {
  AL_CENTER, AL_LEFT, AL_RIGHT
} ALIGN;

typedef struct {
  int ht, it;
} MENU_STATE;

extern int menu_left_right;
extern int menu_lr_dir;
extern void poz(char *u, char *d);
extern void header(int lng, char *data);
extern void emptylines(int lng, int count);
extern void footer(int lng);
extern int menu(int x1, int x2, int y, int minlines, int color, int defitem, int spacing, ALIGN align, char *texts, void (*callback)() );
extern int menu_ex(int x1, int x2, int y, int lines, int color, MENU_STATE *m, int items, char *title, char *(*getstr)(), void (*callback)() );
extern void okno(int x1, int x2, int y, int lines, int color, char *head, char *body);
extern char *dialog(int x1, int x2, int y, int lines, int color, char *texts, char *dest);
extern int binfield_dialog(int x1, int x2, int y, int lines, int color, char *texts, int data);

/* debug.c */
extern void okno_ex(char *body);
extern void okno_st(int sp0, ...);
extern void okno_reg(void);
extern void okno_cpuinfo(void);
extern void cpuid_any(void);
extern void converter(void);
extern void mapping(void);
extern void credits(void);
extern void data_protect(void);

/* descriptor.c */
enum {
  NO_OP,    // require no additional action
  TO_RAW,   // structured data was changed, require parse_to_raw
  FROM_RAW  // raw data was changed, require parse_from_raw
};

enum {
  EDIT,   // edit action - invoke dialog or sth. else
  HLIGHT  // hilight action - hilight corresponding portion in the raw data
};

typedef enum {
  TB_GDT = 0,
  TB_LDT = 1,
  TB_IDT = 2,
  TB_DIR = 4, // Page directory entry (page table)
  TB_TAB = 5, // Page table entry (page)
} TABLE;

typedef struct s_descriptor {
  int type, s, d, g, dpl, p;
  int seg, ofs, pc, sel_min, sel_max;
  TABLE dti;		// Descriptor table indicator
  int index;
  unsigned int base;
  unsigned int limit;
  unsigned int desc[2];
} DESCRIPTOR;

typedef struct s_pageent {
  int index;
  struct s_pageent *parent;
  TABLE type;
  unsigned int base;
  unsigned int lin_base, lin_limit;
  int p, rw, us, wt, cd, a, d, s, pat, g, avl;
  int valid;
  unsigned int raw;
} PAGE_ENTRY;

typedef enum {
  E_CALL = 0,
  E_JMP = 1
} E_TYPE;

typedef struct s_execparam {
  E_TYPE type;
  TABLE dti;		// Descriptor table identifier
  int index;		// Called segment selector index
  int cpl;		// CPL of calling process (will drop privileges to this before call)
  int rpl;		// RPL of called segment
  int module;		// Code module that will be copied into destination code segment
  int pc;		// Module parameters count
} EX_PARAMS;

enum {
  ADDR_OK = 0,
  ADDR_INVALID = 1,
  ADDR_OUTOFLIMIT = 2,
  ADDR_NOTFOUND = 3,
  ADDR_NONPRESENT = 4,
};

extern int range_overlap(DESCRIPTOR *r1, int st2, int e2);
extern int has_base_limit(DESCRIPTOR *d1);
extern int is_expand_down(DESCRIPTOR *d1);
extern DESCRIPTOR *load_descriptor(int selector, TABLE tab, DESCRIPTOR *d1);
extern void store_descriptor(DESCRIPTOR *d1);
extern char *descriptor_name(int no);
extern void descriptor_menu(void);
extern void idescriptors(void);
extern void init_menus(void);
extern char *summary(int sel, char *data);
extern char *lsummary(int sel, char *data);
extern int log2lin(int seg, int ofs, unsigned int *addr);
extern int lin2log(unsigned int addr, int *seg, unsigned int *ofs);

/* exec.c */
extern void execute(void);


typedef struct s_tr {
  int base;
  int limit;
  int selector;
} TR_STRUCT;

typedef struct regs {
  int eax;
  int ebx;
  int ecx;
  int edx;
} REGISTERS;

typedef struct mem_entry {
  int base[2];
  int limit[2];
  int type;
  int reserved[3];
} MEM_ENTRY;

typedef struct mem_map {
  int size;
  int reserved[3];
  MEM_ENTRY range[31];
} MEM_MAP;

extern MEM_MAP *_memory_map;

/* main.s */
extern void rm_reboot(void);
extern void sw_int(int intno);
extern void cpu_id(int fn, REGISTERS *data);
extern void xdt_read(int selector, int table, unsigned int *data);
extern void xdt_write(int selector, int table, unsigned int *data);
extern int load_ldtr(void);
extern int load_tr(void);
extern TR_STRUCT *load_gdtr(TR_STRUCT *data);
extern TR_STRUCT *load_idtr(TR_STRUCT *data);
extern void store_ldtr(int selector);
extern int getcpl(void);
extern int getcs(void);
extern int getds(void);
extern int getss(void);
extern void *memcpy(void *dest, void *src_ofs, int n);
extern void *_memcpy(int dest_seg, int src_seg, void *dest, void *src_ofs, int n);
extern unsigned int _page_table;

/* page.s */
extern int load_pdbr(void);
extern int load_cr2(void);
extern void invalidate_all(void);
extern void invalidate(int index1, int index2);
extern int pxe_read(int index1, int index2, unsigned int *data);
extern int pxe_write(int index1, int index2, unsigned int data);

/* pages.c */
extern void pagedir_menu(void);
extern int lin2phys(unsigned int laddr, unsigned int *paddr);
extern int phys2lin(unsigned int paddr, unsigned int *laddr);

/* hex.c */
extern void hexeditor_menu(void);

/* tss.s */
extern void tss_prep(int opcode, int sel, int ofs, int cpl);
extern void tss_call(void);
extern void x_call(void);

/* menu.c */
extern int menu_x, menu_y;

// modules.c
extern int hide_code;
extern int mod_count;
extern char *mod_iterate(int sel, char *data);
extern void mod_info_display(int num);
extern int mod_setup(int mnum, int snum);
extern int mod_end;

