// Prot386 String functions
// (C) 2006-2007 Peter Ambroz
// This code is free software and is distributed under the terms of GNU GPL

extern int use_eol;

int strlen_ex(char *data)
{
  int len = 0;
  while ((*data) && (*data != '\n')) data++,len++;
  return len;
}

int strlen(char *data)
{
  int len = 0;
  if (use_eol) return strlen_ex(data);
  while (*data++) len++;
  return len;
}

char *strcat(char *dest, ...)
{
  __builtin_va_list list;
  char *src, *orig;

  if (!dest) return (char *)0;
  orig = dest;
  __builtin_va_start(list, dest);
  while (*dest) dest++;
  while ((src = __builtin_va_arg(list, char *))) {
    while ((*dest++ = *src++));
    dest--;
  }
  __builtin_va_end(list);
  return orig;
}
