from matplotlib import pyplot as plt
from glob import glob
import cv2 as cv


f, ax = plt.subplots(5, 3)

for i, image in enumerate(sorted(glob('image*'))):
    ax[i, 0].imshow(cv.imread(image))
    ax[0, 0].set_title('Image')
    ax[i, 0].axis('off')

for i, true in enumerate(sorted(glob('true*'))):
    ax[i, 1].imshow(cv.imread(true))
    ax[0, 1].set_title('True label')
    ax[i, 1].axis('off')

for i, prediction in enumerate(sorted(glob('prediction*'))):
    ax[i, 2].imshow(cv.imread(prediction))
    ax[0, 2].set_title('Prediction')
    ax[i, 2].axis('off')

plt.savefig('out.png')
plt.show()
